<?php

    require('../partials/header.php');

?>      

<section id="transactions">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">All-Time Transactions</h4>

        </div>

        <!-- <div class="dashBanner_header space">

            <div class="dBHeader_item">

                <p>Filter By:</p>

                <select class="form_field" id="scope">

                    <option value="" data-display="All Transactions">All</option>
                    
                    <option value="">Swap</option>

                    <option value="">Transfers</option>

                    <option value="">Withdrawals</option>

                    <option value="">Payments</option>


                </select>

                <select class="form_field" id="currency">

                    <option value="" data-display="All Accounts">All</option>
                    
                    <option value="">USD</option>

                    <option value="">EUR</option>

                    <option value="">GBR</option>

                    <option value="">JPY</option>


                </select>

            </div>

            <div class="dBHeader_item">

                <p>Sort Date:</p>

                <div class="field_group">

                    <div class="field_item">

                        <input type="date" name="" id="from" class="form_field smPd">

                    </div>

                    <div class="field_item">

                        <input type="date" name="" id="to" class="form_field smPd">

                    </div>

                </div>

                

            </div>

        </div> -->

        <div class="table_con" id="table-1">

            <table>

                <thead>

                    <tr>

                        <th>Date</th>

                        <th>Amount</th>

                        <th class="mobile-0">Type</th>

                        <th class="mobile-0">Description</th>

                        <th class="mobile-0">Status</th>

                        <th>Actions</th>

                    </tr>

                </thead>

                <tbody>

                    <?php
                    
                        // Get User Transactions

                        $foundTransc = false; // Flag

                        $transactions = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `user_id` = ? ORDER BY `date` DESC"); // Prepare Statement

                        mysqli_stmt_bind_param($transactions, "s", $currentUser); // Bind Parameter(s) 

                        mysqli_stmt_execute($transactions); // Execute Statement

                        $result = mysqli_stmt_get_result($transactions); // Get Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                            $foundTransc = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($transactions); // Close Statement

                        // Check Flag

                        if ($foundTransc) {

                            // Iterate Through Data 

                            foreach ($data as $row) :

                                $currency = $row['currency'];

                                $symbol = $currSymbol[$currency];

                                $date = strtotime($row['date']);

                                $type = $row['type'];

                                $desc = $row['descr'] == null ? '-' : $row['descr'];

                                $amount = '<span translate="no">' . $symbol . '</span>' . number_format($row['amount'], 2);

                                $status = $row['status'];

                                $scope = $row['action'];

                                $id = $row['trans_id'];

                                if ($type == 'CREDIT') {

                                    $type = '<span class="i-element green">'. $type .'</span>';

                                } else {

                                    $type = '<span class="i-element red">'. $type .'</span>';

                                }

                                if ($status === 'COMPLETED') {

                                    $icon = '<svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>';

                                    $class = ' verified';

                                } else if ($status === 'INCOMPLETE' || $status === 'DISPUTED') {

                                    $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-alert mr-2 h-4 w-4"><circle cx="12" cy="12" r="10"></circle><line x1="12" x2="12" y1="8" y2="12"></line><line x1="12" x2="12.01" y1="16" y2="16"></line></svg>';

                                    $class = ' error';

                                } else {

                                    $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer mr-2 h-4 w-4 text-muted-foreground"><line x1="10" x2="14" y1="2" y2="2"></line><line x1="12" x2="15" y1="14" y2="11"></line><circle cx="12" cy="14" r="8"></circle></svg>';

                                    $class = ' orange';

                                }

                                $status = '<div class="verif v2 sm'. $class .'">

                                    <div class="icon">' . $icon . '</div>       
                                    
                                    <span>' . ucwords($status) . '</span>
                            
                                </div>';

                            ?>
                            
                            <tr class="iQ_tRow" data-date="<?= $date ?>" data-currency="<?= $currency ?>" data-scope="<?= $scope ?>">

                                <td><span class="hint--bottom" aria-label="<?php echo date('h:i A', $date); ?>"><?= date('l M d, Y', $date) ?></span></td>

                                <td><?= $amount . '<sup class="label" translate="no">' . $currency . '</sup>' ?></td>

                                <td class="mobile-0"><?= $type ?></td>

                                <td class="mobile-0"><?= $desc ?></td>

                                <td class="mobile-0"><?= $status ?></td>

                                <td>

                                    <div class="flx">

                                        <div class="fetch-trans-details mobile-0">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill iQ_rqust" iQ-target="#iQ_transDetails">Details</span>

                                        </div>

                                        <div class="iQ_rqustCon2">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill plain iQ_rqust" iQ-target="#iQ_transReceipt">Receipt</span>

                                        </div>

                                    </div>    

                                </td>

                            </tr>

                            <?php endforeach;

                        } else {

                            emptyTable('Ready to make your first transaction?');

                        }

                    ?>

                </tbody>

            </table>

            <?php
            
                if ($foundTransc) {

                    echo '<div class="table_nav">

                        <button class="prevPage" disabled>

                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                            
                            <span>Prev</span>
                    
                        </button>

                        <button class="nextPage" disabled>
                            
                            <span>Next</span>

                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                    
                        </button>

                    </div>';

                }

            ?>

        </div>

    </div>

</section>

<?php

    require('../partials/footer.php');

?>