<?php

    require('partials/landing-header.php');

?>

<main class="max-w-4xl mx-auto px-6 py-12">
    
    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">FDIC Insurance Information</span></h2>
      <p class="mb-4">
        <span translate="no"><?= SITE_NAME ?></span> is proud to be a member of the Federal Deposit Insurance Corporation (FDIC), a U.S. government agency that protects depositors by insuring deposits at participating banks. This membership ensures that your deposits with <span translate="no"><?= SITE_NAME ?></span> are safeguarded up to the maximum limits established by federal law, currently $250,000 per depositor, per insured bank, for each account ownership category. This insurance coverage applies to a wide range of deposit accounts, including savings accounts, checking accounts, money market accounts, and certificates of deposit (CDs).
      </p>
      
      <p class="mb-4">The FDIC insurance provides peace of mind to our customers by guaranteeing the safety of their funds in the unlikely event of a bank failure. This protection is automatic and requires no additional action on the part of the depositor. <span translate="no"><?= SITE_NAME ?></span>’s commitment to maintaining strong financial health and regulatory compliance ensures that we continue to meet and exceed the standards necessary to maintain FDIC membership and the security it provides.</p>

      <p class="mb-4">We encourage all customers to understand the scope and limits of FDIC insurance and to review their accounts accordingly. For detailed information about coverage limits, account ownership categories, and additional protections, please visit the FDIC’s official website at <a class="text-blue-400 text-underline" href="https://www.fdic.gov" target="_blank">www.fdic.gov<i class="fa-solid fa-arrow-up-right-from-square font-sm ml-1 text-xs"></i></a>. At <span translate="no"><?= SITE_NAME ?></span>, safeguarding your assets is our highest priority, and we remain dedicated to providing you with secure, reliable, and seamless banking services.</p>

    </section>

</main>

<?php

    require('partials/landing-footer.php');

?>