<?php

    require('partials/landing-header.php');

?>

<main class="max-w-5xl mx-auto px-6 py-12">

    <!-- Hero Section -->
    <section class="text-center py-16 px-4">
        <div class="mb-6">
            <div class="flex justify-center mx-auto mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" style="width: 7em" viewBox="0 0 24 24" fill="none">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M21 18V8C21 7.44772 20.5523 7 20 7H16V15C16 15.5523 15.5523 16 15 16H9V18C9 18.5523 9.44772 19 10 19H15.4901L18.7337 20.9462C18.8929 21.0417 19.0851 20.8876 19.0264 20.7114L18.4559 19H20C20.5523 19 21 18.5523 21 18Z" fill="url(#paint0_linear_3632_287)"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M3 4V15C3 15.5523 3.44772 16 4 16H5.36244L4.84492 17.5526C4.7862 17.7287 4.97833 17.8828 5.13756 17.7873L8.11638 16H15C15.5523 16 16 15.5523 16 15V4C16 3.44772 15.5523 3 15 3H4C3.44772 3 3 3.44772 3 4ZM7.43454 7.61058C7.60675 7.29198 7.84786 7.04226 8.17507 6.85283C8.49367 6.66339 8.87254 6.56867 9.3203 6.56867C9.73362 6.56867 10.0953 6.63756 10.4053 6.77533C10.7153 6.9131 10.9477 7.11115 11.12 7.35225C11.2836 7.60197 11.3697 7.88612 11.3697 8.19611C11.3697 8.57499 11.2922 8.86775 11.1372 9.08302C10.9822 9.29829 10.7669 9.50495 10.4742 9.703C10.2158 9.87522 10.0264 10.0302 9.92306 10.1508C9.81973 10.2799 9.76807 10.4263 9.76807 10.5985C9.76807 10.6603 9.71795 10.7105 9.65613 10.7105H8.87254C8.73938 10.7105 8.63144 10.6025 8.63144 10.4694C8.63144 10.1422 8.70033 9.89244 8.84671 9.703C8.99309 9.52218 9.22558 9.34135 9.54419 9.15191C9.74223 9.03136 9.88862 8.9022 9.98334 8.76442C10.0694 8.63526 10.1211 8.48027 10.1211 8.30805C10.1211 8.10139 10.0436 7.93779 9.90584 7.80863C9.75946 7.67946 9.57002 7.61058 9.32892 7.61058C9.05337 7.61058 8.82949 7.71391 8.66588 7.90334C8.62063 7.95313 8.58191 8.00767 8.54942 8.06665C8.38538 8.36449 8.14052 8.6611 7.8005 8.6611C7.46047 8.6611 7.17335 8.38051 7.26039 8.05181C7.30097 7.89851 7.35853 7.75119 7.43454 7.61058ZM8.71755 11.5113C8.85532 11.3821 9.02754 11.3132 9.2342 11.3132C9.44086 11.3132 9.60446 11.3821 9.74223 11.5113C9.88001 11.6404 9.94889 11.804 9.94889 12.0021C9.94889 12.2087 9.88001 12.3724 9.74223 12.5015C9.60446 12.6393 9.43224 12.6996 9.2342 12.6996C9.02754 12.6996 8.86393 12.6393 8.72616 12.5015C8.58839 12.3724 8.5195 12.2087 8.5195 12.0021C8.5195 11.804 8.57977 11.6404 8.71755 11.5113Z" fill="url(#paint1_linear_3632_287)"/>
                    <defs>
                    <linearGradient id="paint0_linear_3632_287" x1="15" y1="7" x2="15" y2="20.199" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#A0C0F3" stop-opacity="0.7"/>
                    <stop offset="1" stop-color="#A0C0F3"/>
                    </linearGradient>
                    <linearGradient id="paint1_linear_3632_287" x1="9.5" y1="3" x2="9.5" y2="17.8166" gradientUnits="userSpaceOnUse">
                    <stop stop-color="#2467E3"/>
                    <stop offset="1" stop-color="#2467E3" stop-opacity="0.7"/>
                    </linearGradient>
                    </defs>
                </svg>
            </div>
            <h1 class="text-3xl font-semibold">How can we help?</h1>
            <p class="text-blue-400 mt-2">Find solutions to your banking needs through our resources & guides.</p>
        </div>
        <div class="max-w-xl mx-auto">
            <input type="text" placeholder="Search..."
                class="w-full px-4 py-3 rounded bg-gray-800 border border-gray-700 text-gray-300 focus:outline-none focus:border-blue-500">
        </div>
    </section>

    <section class="px-6 py-12 text-center border-t border-gray-800">
        <h2 class="text-xl font-semibold mb-6">Explore our Help Resources</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Card -->
            <div class="bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
                <h3 class="text-lg font-semibold mb-4">Terms & Conditions</h3>
                <ul class="space-y-2">
                <li><a href="terms-conditions" class="hover:text-blue-400">Read <i class="fas fa-arrow-right ml-2 text-blue-400"></i></a></li>
                </ul>
            </div>
            <div class="bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
                <h3 class="text-lg font-semibold mb-4">Privacy Policy</h3>
                <ul class="space-y-2">
                <li><a href="privacy-policy" class="hover:text-blue-400">Read <i class="fas fa-arrow-right ml-2 text-blue-400"></i></a></li>
                </ul>
            </div>
            <div class="bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
                <h3 class="text-lg font-semibold mb-4">Legal Disclaimer</h3>
                <ul class="space-y-2">
                <li><a href="legal" class="hover:text-blue-400">Read <i class="fas fa-arrow-right ml-2 text-blue-400"></i></a></li>
                </ul>
            </div>
        </div>
    </section>

    <!-- Accordion FAQ Section -->
    <section class="px-6 py-12 border-t border-gray-800" id="faq">
        <h2 class="text-xl font-semibold text-center mb-6">Frequently Asked Questions</h2>
        <div class="max-w-2xl mx-auto">
            <div class="space-y-4">
                <!-- FAQ Item 1 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>1. How do I open an account with <span translate="no"><?= SITE_NAME ?></span>?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        Opening an account with <span translate="no"><?= SITE_NAME ?></span> is easy! You simply apply online through our website (<a href="auth/register" translate="no" class="text-blue-400"><?= SITE_BASE_URL . '/auth/register' ?></a>) or mobile app. You will need to provide personal information such as your name, address, date of birth and proof of identification.
                    </div>
                </div>

                <!-- FAQ Item 2 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>2. What types of accounts does <span translate="no"><?= SITE_NAME ?></span> offer?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        <span translate="no"><?= SITE_NAME ?></span> offers a variety of accounts including:
                        <ul class="list-disc list-inside space-y-2 mt-2">
                            <li><strong>Checking Accounts</strong> – For everyday transactions, payments, and withdrawals.</li>
                            <li><strong>Savings Accounts</strong> – For earning interest on your deposits.</li>
                            <li><strong>Business Accounts</strong> – Designed for business owners to manage business finances.</li>
                            <li><strong>Loans and Mortgages</strong> – Personal loans, auto loans, and home mortgages.</li>
                        </ul>
                    </div>
                </div>

                <!-- FAQ Item 3 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>3. How do I reset my online banking password?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        If you have forgotten your password, follow these steps:
                        <ol class="list-decimal list-inside space-y-2 mt-2">
                            <li>Go to the login page of <span translate="no"><?= SITE_NAME ?></span>'s online banking portal.</li>
                            <li>Click on the "Forgot Password" link.</li>
                            <li>Enter the email associated with your account.</li>
                            <li>Follow the instructions sent to your email to reset your password.</li>
                        </ol>
                        If you need further assistance, contact customer service.
                    </div>
                </div>

                <!-- FAQ Item 4 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>4. How do I report fraudulent activity on my account?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        If you suspect fraudulent activity on your account, immediately contact ApexBank’s customer service at <a href="tel:18005552739" class="text-blue-600 hover:underline"><?= BANK_PHONE ?></a> or email us at <a href="mailto:<?= SUPPORT_MAIL ?>" class="text-blue-600 hover:underline"><?= SUPPORT_MAIL ?></a>. We will work with you to investigate the issue and take the necessary actions to protect your account.
                    </div>
                </div>

                <!-- FAQ Item 5 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>5. How can I check my account balance?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        You can check your account balance through:
                        <ul class="list-disc list-inside space-y-2 mt-2">
                            <li><strong>Online Banking:</strong> Log into your <span translate="no"><?= SITE_NAME ?></span> account on our website.</li>
                            <li><strong>Mobile App:</strong> Use our mobile app to view your account balance on-the-go.</li>

                            <li><strong>Customer Service:</strong> Call our customer service number for balance inquiries.</li>
                        </ul>
                    </div>
                </div>

                <!-- FAQ Item 6 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>6. Can I transfer funds between my accounts?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        Yes, you can transfer funds between your accounts as well as swap between accounts through:
                        <ul class="list-disc list-inside space-y-2 mt-2">
                            <li><strong>Online Banking</strong> – Transfer money easily from one account to another via our website.</li>
                            <li><strong>Mobile App</strong> – Use the mobile app to transfer funds from your phone.</li>
                            <li><strong>Phone Banking</strong> – Call customer service for assistance with transfers.</li>
                        </ul>
                    </div>
                </div>

                <!-- FAQ Item 7 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>7. How do I apply for a loan with <span translate="no"><?= SITE_NAME ?></span>?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        To apply for a loan with <span translate="no"><?= SITE_NAME ?></span>, you can:
                        <ul class="list-disc list-inside space-y-2 mt-2">
                            <li>Visit our website and fill out an online loan application.</li>
                            <li>Visit any of our branches to meet with a loan officer.</li>
                            <li>Call our customer service to schedule a consultation with a loan representative.</li>
                        </ul>
                        We offer personal loans, auto loans, and mortgages. You will need to provide financial information such as income details, credit history, and employment status.
                    </div>
                </div>

                <!-- FAQ Item 8 -->
                <div class="border border-gray-700 rounded faq-item">
                    <button class="w-full flex justify-between items-center px-4 py-3 text-left focus:outline-none">
                        <span>8. How do I delete my virtual card?</span>
                        <span class="ind-icon">+</span>
                    </button>
                    <div class="hidden px-4 pb-4 faq-content">
                        <p style="mb-4">Please get in touch with our support team to carry out this action. So that you know, your request will be reviewed within 24 working hours. Once you delete your card, any remaining balance is returned to your <span translate="no"><?= SITE_NAME ?></span> Account balance.</p>

                        <p style="mb-4">Also, could you confirm that you are not expecting refunds to your card before deleting your card, as this action cannot be revoked. If you are expecting a refund or have transactions on hold, please contact the merchant first. </p>
                    </div>
                </div>

                
            </div>
        </div>
    </section>

</main>

<?php

    require('partials/landing-footer.php');

?>