// Invoice Payment Handler 

document.addEventListener("DOMContentLoaded", () => {

    let module = document.querySelector('#pay-invoice');

    if (module) {

        let command = module.querySelector('#checkout');

        let field = module.querySelector('input[type="hidden"]');

        if (command && field) {

            command.addEventListener("click", async (event) => {

                event.preventDefault(); // Prevent Default Event

                let content = command.innerHTML;

                formProcessZero(command); // Initiate Loading Sequence

                try {

                    let processor = await fetch('utility/processors/invoice-payment-processor.php', {

                        method: 'POST',

                        headers: {

                            'Content-Type': 'application/x-www-form-urlencoded'

                        },

                        body: new URLSearchParams({

                            'invoice-id': field.value

                        }),

                    }); // Request Handler, Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response 

                    if (response.invoiceError) {

                        setTimeout(() => {

                            popup({

                                header: 'ERROR!',

                                title: 'Invoice data invalid!',

                                text: 'Sorry, we couldn\'t find the requested invoice data!',

                                type: 'failure',

                            }).then(() => {

                                window.location.reload();

                            });

                            formProcessRestore(command, content); // Restore Button

                        }, 1200);

                    } else if (response.pay) {

                        setTimeout(() => {

                            window.location.href = 'pay'

                        }, 2500);

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'warning',

                            duration: 1500

                        });

                        formProcessRestore(command, content); // Restore Button

                    }, 1200);

                }

            });

        }

    }

});

// Crypto Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#invoice-via-crypto');

    let payMethod = 'CRYPTO';

    let button = document.querySelector('#payCrypto');

    if (form) {

        let options = form.querySelectorAll('input[type="radio"][name="channel"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML;

            formProcessZero(button); // Disable User Interaction

            isBlank = true;

            options.forEach((option) => {

                if (option.checked) {

                    isBlank = false;

                }

            });

            if (isBlank) {

                toast({

                    text: "Select asset!",

                    type: "warning",

                    duration: 7000,

                });

                setTimeout(() => {

                    formProcessRestore(button, content);

                }, 500)

            } else {

                // Process Form

                try {

                    let formData = new FormData(form); // Collect Form Data

                    formData.append('payMethod', payMethod);

                    let processor = await fetch('utility/processors/invoice-pay-processor.php', {

                        method: 'POST',

                        body: formData

                    });

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.getProof) {

                        let panels = document.querySelectorAll(".iQ_panel");
                        let preProcessor = document.querySelector("#payProcessor");
                        let proofCollector = document.querySelector("#payProof");

                        setTimeout(() => {

                            // Hide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {

                                let formBox = panel.querySelector("*");
                                if (formBox) { // Check if .payBox_con exists in the panel
                                    formBox.classList.add("n_displ");
                                }
                            });

                            // Show preProcessor panel
                            preProcessor.classList.remove("n_displ");

                        }, 1500);

                        // After 12 seconds, restore the original state
                        setTimeout(() => {

                            // Unhide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {
                                let formBox = panel.querySelector("*");
                                if (formBox) {
                                    formBox.classList.remove("n_displ");
                                }
                            });

                            // Hide the preProcessor and show the proofCollector
                            preProcessor.classList.add("n_displ");
                            proofCollector.classList.replace("n_displ", "fade_in");

                            // Animate the #iQ_proof element inside proofCollector
                            let proofElement = proofCollector.querySelector("#iQ_proof");
                            if (proofElement) { // Check if #iQ_proof exists
                                proofElement.classList.replace("n_displ", "float_up");
                            }

                            formProcessRestore(button, content); // Enable User Interaction

                        }, 30000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                    }, 1200);

                }

            }

        });

    }

});

// Other Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#invoice-via-misc');

    let payMethod = 'OTHERS';

    let button = document.querySelector('#payMisc');

    if (form) {

        let options = form.querySelectorAll('input[type="radio"][name="method"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Store Button Original Content

            formProcessZero(button); // Disable User Interaction

            isBlank = true;

            options.forEach((option) => {

                if (option.checked) {

                    isBlank = false;

                }

            });

            if (isBlank) {

                toast({

                    text: "Select payment method!",

                    type: "warning",

                    duration: 7000,

                });

                setTimeout(() => {

                    formProcessRestore(button, content);

                }, 500)

            } else {

                // Process Form

                try {

                    let formData = new FormData(form); // Collect Form Data

                    formData.append('payMethod', payMethod);

                    let processor = await fetch('utility/processors/invoice-pay-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.getProof) {

                        let panels = document.querySelectorAll(".iQ_panel");
                        let preProcessor = document.querySelector("#payProcessor");
                        let proofCollector = document.querySelector("#payProof");

                        setTimeout(() => {

                            // Hide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {

                                let formBox = panel.querySelector("*");
                                if (formBox) { // Check if .payBox_con exists in the panel
                                    formBox.classList.add("n_displ");
                                }
                            });

                            // Show preProcessor panel
                            preProcessor.classList.remove("n_displ");

                        }, 3000);

                        // After 12 seconds, restore the original state
                        setTimeout(() => {

                            // Unhide all .payBox_con elements inside each panel
                            panels.forEach((panel) => {
                                let formBox = panel.querySelector("*");
                                if (formBox) {
                                    formBox.classList.remove("n_displ");
                                }
                            });

                            // Hide the preProcessor and show the proofCollector
                            preProcessor.classList.add("n_displ");
                            proofCollector.classList.replace("n_displ", "fade_in");

                            // Animate the #iQ_proof element inside proofCollector
                            let proofElement = proofCollector.querySelector("#iQ_proof");
                            if (proofElement) { // Check if #iQ_proof exists
                                proofElement.classList.replace("n_displ", "float_up");
                            }

                            formProcessRestore(button, content); // Restore User Interaction

                        }, 30000);

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error to Console

                    setTimeout(() => {

                        toast({

                            text: 'Unable to process request!',

                            type: 'error',

                            duration: 5000

                        });

                        formProcessRestore(button, content); // Enable User Interaction

                    }, 1300);

                }

            }

        });

    }

});

// Bank Payment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#invoice-via-bank');

    let button = document.querySelector('#payBank');

    let payMethod = 'BANK TRANSFER';

    if (form) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            let content = button.innerHTML; // Store Button Content

            formProcessZero(button); // Disable User Interaction

            try {

                // Process Form

                let formData = new FormData(form);

                formData.append('payMethod', payMethod);

                let processor = await fetch('utility/processors/invoice-pay-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.getProof) {

                    formProcess(button, 3000);

                    let panels = document.querySelectorAll(".iQ_panel");
                    let preProcessor = document.querySelector("#payProcessor");
                    let proofCollector = document.querySelector("#payProof");

                    setTimeout(() => {

                        // Hide all .payBox_con elements inside each panel
                        panels.forEach((panel) => {

                            let formBox = panel.querySelector("*");
                            if (formBox) { // Check if .payBox_con exists in the panel
                                formBox.classList.add("n_displ");
                            }
                        });

                        // Show preProcessor panel
                        preProcessor.classList.remove("n_displ");

                    }, 1500);

                    // After 12 seconds, restore the original state
                    setTimeout(() => {

                        // Unhide all .payBox_con elements inside each panel
                        panels.forEach((panel) => {
                            let formBox = panel.querySelector("*");
                            if (formBox) {
                                formBox.classList.remove("n_displ");
                            }
                        });

                        // Hide the preProcessor and show the proofCollector
                        preProcessor.classList.add("n_displ");
                        proofCollector.classList.replace("n_displ", "fade_in");

                        // Animate the #iQ_proof element inside proofCollector
                        let proofElement = proofCollector.querySelector("#iQ_proof");
                        if (proofElement) { // Check if #iQ_proof exists
                            proofElement.classList.replace("n_displ", "float_up");
                        }

                    }, 30000);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    toast({

                        text: 'An error occurred',

                        type: 'error',

                        duration: 5000

                    });

                    formProcessRestore(button, content); // Enable User Interaction

                }, 1300);

            }

        });

    }

});

// Payment Proof Upload Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#inv-PayProof');

    let button = document.querySelector('#uploadProof');

    if (form && button) {

        form.addEventListener("submit", (event) => {

            event.preventDefault();

            let content = button.innerHTML;

            let field = document.querySelector('#proof-file');

            if (field.files.length === 0) {

                toast({

                    text: "Please upload proof!",

                    type: "warning",

                    duration: 7000,

                });

                field.focus();


            } else {

                // Process Form

                formProcessZero(button); // Button Feedback

                let formData = new FormData(form);

                formData.append('proof', field);

                fetch('utility/processors/invoice-pay-proof-processor.php', {

                    method: 'POST',

                    body: formData

                })
                .then(response => response.json())
                .then(data => {

                    if (data.refresh) {

                        window.location.reload();

                    } else if (data.extensionError) {

                        toast({

                            text: "Unsupported File Format!",

                            type: "warning",

                            duration: 7000,

                        });

                        formProcessRestore(button, content); // Restore Button

                    } else {

                        if (data.uploadError) {

                            toast({

                                text: "Error, try again!",

                                type: "warning",

                                duration: 7000,

                            });

                            formProcessRestore(button, content); // Restore Button

                        } else {

                            if (data.insertProof) {

                                toast({

                                    text: "Payment made!",

                                    type: "success",

                                    duration: 7000,

                                });

                                setTimeout(() => {

                                    window.location.href = `${data.id}`;

                                }, 3000);

                            } else {

                                formProcessRestore(button, content); // Restore Button

                                toast({

                                    text: "An error occurred!",

                                    type: "error",

                                    duration: 7000,

                                });

                            }

                        }

                    }

                })
                .catch(error => {

                    formProcessRestore(button, content);

                    console.error('Error:', error);

                    toast({

                        text: "Unable to process request!",

                        type: "error",

                        duration: 7000,

                    });

                });

            }

        });

    }

});
