<?php

    // Credentials

    session_name('INVSESSID');

    session_start(); // Establish Sessions

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Functions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['invoice-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $invoiceData = invoiceData($id, $conn); // Locate Invoice

        if (!$invoiceData) {

            echo json_encode(['invoiceError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $currency = $invoiceData['currency'];

        $invoiceNum = $invoiceData['invoice-number'];

        $recipient = $invoiceData['user-id'];

        $customer = $invoiceData['customer-id'];

        $amount = $invoiceData['total'];

        // Set Payment Essentials

        $_SESSION['USER-ID'] = $recipient;

        $_SESSION['CUSTOMER'] = $customer;

        $_SESSION['PAY'] = $invoiceNum . ' (INVOICE)';

        $_SESSION['PAY-AMOUNT'] = $amount;

        $_SESSION['PAY-DESC'] = $id;

        $_SESSION['SUBJECT-CURR'] = $currency;

        echo json_encode(['pay' => true]);

    }

?>