<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); //  Initiate Session

    require('../partials/auth-header.php');

    if (!isset($_SESSION['MFA']) || !isset($_SESSION['MFA-TYPE'])) {

        // Deny Unauthorized Access (Redirect To Login)

        echo '<script>
        
            window.history.go(-1);

        </script>';

        exit(); // Terminate Script

    }

    $pendingMail = true;

    $sess = ['MAIL', 'SUBJECT', 'RECIPIENT', 'MAIL-DEST'];

    foreach ($sess as $ses) {

        if (!isset($_SESSION[$ses])) {

            $pendingMail = false;

        }

    }

    if ($pendingMail) {

        require('../vendor/autoload.php'); // Composer Package File

        require('../controls/engines/mail-delivery-engine.php'); // Mail Delivery Functions

        $mail = $_SESSION['MAIL'];

        $subject = $_SESSION['SUBJECT'];

        $recipientName = $_SESSION['RECIPIENT'];

        $dest = $_SESSION['MAIL-DEST'];

        $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $dest, $recipientName);

        if (!$deliver) {

            $deliver = @deliverByPHPMail($dest, $subject, $mail); //  Fallback

        }

        foreach ($sess as $ses) {

            unset($_SESSION[$ses]);

        }

    }

    $extraScripts = <<<HTML

        <!-- UA Parser -->

        <script src="../resources/ua-parser/ua-parser.pack.js"></script>
        
    HTML; // Add UA-Parser

?>

<div class="viewBox max">

    <div class="vbox_item header">

        <div class="logo">

            <a<?= !is_null(HOME_PAGE) ? ' href="' . HOME_PAGE . '"' : null ?>> 

                <img class="light" src="<?= SITE_LOGO ?>" alt="">

                <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

            </a>

        </div>

    </div>

    <div class="vbox_item main">

        <div class="flx font-sm" style="color: var(--pg-error); padding: 0.5em 1em;">

            <div style="min-width: 1.2em;">

                <svg viewBox="0 0 13 13" aria-hidden="true"><path fill="currentColor" d="M6.5.5c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6m0 1c2.757 0 5 2.243 5 5s-2.243 5-5 5-5-2.243-5-5 2.243-5 5-5"></path> <path fill="currentColor" d="M7.75 3.8501c0 .2-.05.35-.2.5-.15.15-.3.2-.5.2s-.35-.05-.5-.2c-.15-.15-.2-.3-.2-.5s.05-.35.2-.5c.15-.15.3-.2.5-.2s.35.05.5.2c.1.15.2.3.2.5M7 7.5001h.45c-.4 1.45-.9 1.85-1.55 1.85-.25 0-.5-.05-.6-.15-.1-.1-.2-.3-.2-.5 0-.15.05-.35.15-.7l.55-1.5c.05-.1.05-.2-.3-.25v-.1c.35-.05.3 0 .25 0-.15 0-.35.2-.55.35h-.45c.4-.6.9-1.05 1.6-1.05.25 0 .45.05.55.2.1.15.2.3.2.5 0 .15-.05.4-.2.75l-.5 1.4c-.05.2-.1.3-.1.35 0 .05 0 .05.05.05s.05.05.1.05c.1 0 .15-.05.3-.2.15-.15.2-.25.25-1.05"></path></svg>

            </div>

            <span>Mail maybe delayed. Didn't see mail? Check your mail spam / trash folder. Please mark as not spam for your convenience. Yandex Mail?: Check Subscriptions.</span>

        </div>

        <div class="form_con">

            <p class="form_title">Enter your verification code</p>

            <form id="mfaForm" method="post" autocomplete="off">

                <p class="form_info">

                    <?= ($_SESSION['MFA-TYPE'] == 'PWRD RESET') ? 'Kindly enter the verification code sent to your email address' : 'To log in, kindly enter the verification code sent to your email address' ?>

                </p>
                                        
                <div class="form_item mltpl">

                    <input type="text" name="digit_1" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autofocus aria-autocomplete="none">

                    <input type="text" name="digit_2" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    <input type="text" name="digit_3" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    <input type="text" name="digit_4" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    <input type="text" name="digit_5" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    <input type="text" name="digit_6" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                </div>

                <div class="form_item">

                    <button type="submit" name="verify" id="verifyMfa" class="form_btn"><?= ($_SESSION['MFA-TYPE'] == 'PWRD RESET') ? 'Reset Password' : 'Log into your account' ?></button>

                </div>

                <div class="form_item">

                    <button type="button" class="action_btn" id="reMfa">

                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24" class="icon-md-heavy"><path fill="currentColor" d="M3.07 10.876C3.623 6.436 7.41 3 12 3a9.15 9.15 0 0 1 6.012 2.254V4a1 1 0 1 1 2 0v4a1 1 0 0 1-1 1H15a1 1 0 1 1 0-2h1.957A7.15 7.15 0 0 0 12 5a7 7 0 0 0-6.946 6.124 1 1 0 1 1-1.984-.248m16.992 1.132a1 1 0 0 1 .868 1.116C20.377 17.564 16.59 21 12 21a9.15 9.15 0 0 1-6-2.244V20a1 1 0 1 1-2 0v-4a1 1 0 0 1 1-1h4a1 1 0 1 1 0 2H7.043A7.15 7.15 0 0 0 12 19a7 7 0 0 0 6.946-6.124 1 1 0 0 1 1.116-.868"></path></svg>

                        <span>Resend code</span>

                    </button>

                </div>

            </form>

        </div>

    </div>

<?php

    require('../partials/auth-footer.php');

?>