<?php

    require('controls/config/config.php');

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">

        <link rel="icon" href="<?= SITE_FAVICON ?>">

        <link rel="stylesheet" href="assets/stylesheets/core.css">

        <script>
            window.history.go(-1);
        </script>
        
        <title>JavaScript Required</title>

        <style>
            
            .noscript-container {
                line-height: 1.6;
                border-radius: 5px;
                padding: 30px;
                /* margin-top: 50px; */
                max-width: 800px;
                margin: 2em auto;
            }
            h1 {
                color: var(--pg-error);
            }
            .instructions {
                text-align: left;
                /* background-color: #e9ecef; */
                padding: 15px;
                border-radius: 4px;
                margin: 20px 0;
            }
            .browser-icons {
                display: flex;
                justify-content: space-around;
                margin: 30px 0;
            }
            .browser-icon {
                text-align: center;
            }
            .browser-icon img {
                width: 48px;
                height: 48px;
            }
            a {
                color: var(--pg-link);
                text-decoration: none;
            }
            a:hover {
                text-decoration: underline;
            }
            .footer {
                margin-top: 30px;
                font-size: 0.9em;
                color: #6c757d;
            }
        </style>

    </head>

    <body>

        <div class="noscript-container">

            <svg id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="134" height="124">
                <defs>
                    <style>
                        .cls-1,
                        .cls-2 {
                            fill: none;
                        }
            
                        .cls-3 {
                            fill: #E56800; 
                        }
            
                        .cls-4 {
                            fill:  #EEBEBD;
                        }
            
                        .cls-5 {
                            fill:  #F68B1E;
                        }
            
                        .cls-6 {
                            fill: #232323;
                        }
            
                        .cls-7 {
                            fill:  #FFBD5A;
                        }
            
                        .cls-8 {
                            fill:  #D38989;
                        }
            
                        .cls-9 {
                            fill:  rgba(58, 96, 173, 0.75);
                            fill-rule: evenodd;
                        }
            
                        .cls-2 {
                            clip-path: url(#clippath);
                        }
                    </style>
                    <clipPath id="clippath">
                        <rect class="cls-1" y=".5" width="133.87" height="124"></rect>
                    </clipPath>
                </defs>
                <g class="cls-2">
                    <path class="cls-9" d="m96.86,97.64c-11.58,26.2-52.33,22.06-82.61,3.48-5.57-3.42-24.7-19.51-5.87-28.92s12.8-23.84,28-41.06c17.58-19.92,50.32-30.13,73.34-3.33,58.52,68.11-8.96,61.01-12.86,69.83Z"></path>
                    <path id="B" class="cls-4" d="m40.61,68.76l-9.86-25.04c-1.2-3.05-1.74-6.25-1.59-9.5.14-3.12.91-6.17,2.27-8.99,1.36-2.83,3.25-5.32,5.61-7.39,2.45-2.15,5.28-3.73,8.43-4.71,5.67-1.76,11.73-1.31,17.07,1.28s9.44,7.06,11.55,12.59l9.8,25.66-8.11,3.08-9.8-25.66c-1.32-3.46-3.91-6.28-7.24-7.89-3.33-1.62-7.16-1.91-10.69-.8-1.95.6-3.75,1.6-5.28,2.95-1.47,1.29-2.67,2.87-3.52,4.63-.85,1.76-1.34,3.68-1.42,5.63-.09,2.03.25,4.06,1,5.95l9.86,25.04-8.07,3.16h0Z"></path>
                    <path id="B-2" class="cls-6" d="m40.61,68.76l-9.86-25.04c-1.2-3.05-1.74-6.25-1.59-9.5.14-3.12.91-6.17,2.27-8.99,1.36-2.83,3.25-5.32,5.61-7.39,2.45-2.15,5.28-3.73,8.43-4.71,5.67-1.76,11.73-1.31,17.07,1.28s9.44,7.06,11.55,12.59l9.8,25.66-8.11,3.08-9.8-25.66c-1.32-3.46-3.91-6.28-7.24-7.89-3.33-1.62-7.16-1.91-10.69-.8-1.95.6-3.75,1.6-5.28,2.95-1.47,1.29-2.67,2.87-3.52,4.63-.85,1.76-1.34,3.68-1.42,5.63-.09,2.03.25,4.06,1,5.95l9.86,25.04-8.07,3.16h0Z"></path>
                    <path id="C" class="cls-5" d="m34.32,69.96c-1.07,2.42-1.13,5.18-.16,7.64l12.07,30.76c1.92,4.88,7.28,7.45,12.29,5.89l36.35-11.29c2.26-.7,4.2-2.18,5.47-4.18l4.54-11.14-66.02-27.28-4.53,9.59h0,0Z"></path>
                    <path class="cls-7" d="m34.04,69.83c0,.11.1.1.2-.17l-.05-.25-.15.41s0,0,0,0Zm1.07-1.6c.08-.33.12-.73-.1-.6,0,.36-.1.41-.09.8-.1.26-.26.43-.29.36,0,.11-.22.38-.2.56.26-.28.47-.7.59-1.18.08-.08.07.03.08.06Zm21.18-.43l-.16-.08c.05.03.1.06.16.08Zm15.82,6.63c-.12-.05-.18-.05-.19-.04.12.04.21.07.19.04Zm2.64,1.27l-.16-.08c.06.04.11.07.16.08Z"></path>
                    <path class="cls-7" d="m56.29,67.8l.4.22s-.2-.12-.4-.22Zm-19.89-3.17c-.03.08-.05.16-.07.24l.08-.22s0-.01-.02-.02c0,0,0,0,0,0Zm12.85.4l-.13-.05s-.09,0-.13.01c0,0,.26.04.26.04Zm-5.37-2.19c.12.06.21-.05.28-.08-.1.02-.2,0-.3-.03-.01.02,0,.06.02.11Zm-6.45.84l-.05.15.05-.15Zm15.65,2.96s.01.04.03.06c0-.01,0-.04-.03-.06Zm-19.86,10.04s.01,0,.02,0c-.02-.03-.03-.04-.02,0Zm1.13-6.71l-.03.09s.04.04.06.05l-.03-.14h0Zm45.29,7.93h-.02c-.14-.05-.06-.02.02,0Zm12.14,25.46c.57-.06-.82.41.02.29-.09-.03.67-.42-.02-.29Z"></path>
                    <path class="cls-7" d="m36.49,64.5l.1-.21-.1.21Zm55.31,39.15h0s.09-.01.09-.01h-.09Zm-.71-21.1s-.05-.07-.1-.1c0,.01.02.04.1.1Zm-8.43-3.68l.2.1-.2-.1Zm12.92,5.34c.11.06.14.09.31.14-.01-.01-.02-.02-.04-.03-.06,0-.14-.03-.26-.1,0,0,0,0,0,0Zm4.59,1.9s-.05-.04-.07-.06l-.15-.05.22.11h0Zm-61.42,4.68c0-.09,0-.17.03-.25-.06.11-.35-.56-.03.25Z"></path>
                    <path class="cls-7" d="m36.48,64.66s-.01-.08.01-.16l-.06.15s.03.03.05,0Zm59.67,18.67l.72.32-.72-.32Zm-36.02,30.98l-.17.07c.07-.02.13-.04.17-.07Zm38.92-29.78c.12.1.24.18.38.25.03,0,.07.01.1,0l-.47-.26h0Zm-60.28,5.99h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m43.36,101.98l-.14-.33.14.33h0Zm.54,1.37l-.23-.6c.02-.07.09-.03.14.11-.06-.06.04.27.09.49h0Zm-.3-3.23c.1.21.11.29.09.33l-.16-.37s-.02-.02-.03-.02c.03.01.06.03.09.06h0Z"></path>
                    <path class="cls-7" d="m43.28,99.8s-.03-.05-.04-.09l.02.14.07.06-.05-.12Zm12.83-32.09h.03s-.04-.01-.05-.03c.02.01.01.02.03.03h0s0,0,0,0Zm2.46,47.15v-.03s-.14.07-.14.07c0,0,.13-.03.14-.03Zm-9.8-50.67s-.03-.04-.09-.07c0,.01.04.04.09.07Zm-3.24-1.37l-.44-.23.44.23Zm-2.47-1.09s-.05.01-.07.03l.07-.03h0Zm39.76,16.26l.1.04c.24.07.08.01-.1-.04Zm-11.93-4.6l.4.1c-.21-.1-.37-.17-.4-.1Zm25.19,9.91s.05.02.08.04l-.08-.04Z"></path>
                    <path class="cls-7" d="m71.83,73.72c-.17-.1-.36-.17-.55-.23l.55.23Zm-36.46-6.92l-.06.11s.01.01.01.02l.05-.14h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m35.32,66.93l-.05.14c.03-.06.05-.11.05-.14Z"></path>
                    <path class="cls-7" d="m35.17,67.36l.1-.29c-.04.1-.1.21-.1.29Zm1.78-3.76l-.03-.06s0,.04.03.06Z"></path>
                    <path class="cls-7" d="m37.4,62.61c-.12.23-.37.54-.5.88l.02.05c0-.18.44-.67.48-.93Zm3.11-1.32l-.83-.38c.13.11.3.25-.09.1,1,.58-.18-.19.92.28Zm2.58,1.15c-.46-.17-.02.07-.06.09.3.08.38.1.06-.09Zm18.86,7.79l-.09.09c.35.13.02-.04.09-.09Zm3.84.93l-.31-.21-.2.03.51.18Zm1.81,1.66l-.16-.05.6.2-.44-.15h0Zm31.7,13.05l-.05-.18c-.25-.07-.36.06.05.18Zm1.89,9.94c-.19.21-.31.47-.36.75l.36-.75Zm-39.21,16.78l.27-.14-.52.21s.25-.07.25-.07Z"></path>
                    <path id="C-2" class="cls-3" d="m34.32,69.96c-1.07,2.42-1.13,5.18-.16,7.64l12.07,30.76c1.92,4.88,7.28,7.45,12.29,5.89l36.35-11.29c2.26-.7,4.2-2.18,5.47-4.18l4.54-11.14-66.02-27.28-4.53,9.59h0,0Z"></path>
                    <path id="D" class="cls-5" d="m44.02,55.44l36.35-11.29c5.01-1.56,10.36,1.01,12.29,5.89l12.07,30.77c2.11,5.39-.8,11.43-6.34,13.15l-36.35,11.29c-5.01,1.56-10.36-1.01-12.29-5.89l-12.07-30.77c-2.11-5.39.8-11.43,6.34-13.15Z"></path>
                    <path class="cls-7" d="m104.59,87.54s.12.05.12,0l-.14-.08.02.07h0Zm.36-.18c-.06-.07-.16-.16-.31-.17.13.09.06.08.21.18,0,.05-.07.06-.12.03.03.03-.05.05.03.1.13-.01.15-.08.08-.18.04,0,.07.02.1.03,0,0,0,0,0,0Zm.61-4.16v.03s0-.02,0-.03Zm-.58-2.59s.03.02.04.01c-.02-.01-.03-.02-.04-.01Zm0-.47s0,.02,0,.03c0-.01.01-.03,0-.03Z"></path>
                    <path class="cls-7" d="m105.55,83.2l.04-.08c-.05,0-.03.04-.04.08Zm-.81,3.52s.01.03.03.04c0-.01,0-.03,0-.04h-.02s0,0,0,0Zm1.01-2.35v.02s.04.01.06.02l-.06-.04Zm-.01.91s-.12-.04-.18-.05c.05.02.08.03.08.05.03,0,.06,0,.09,0h0Zm-.44,1.37v.03s0-.02,0-.03Zm.46-2.93s.03,0,.05-.01c-.02,0-.03,0-.05.01Zm-9.46-22.75s.01,0,.02,0c-.01,0-.02,0-.02,0Zm.23-1.18h.01s.07-.01.07-.01h-.08s0,.01,0,.01Zm8.31,19.54s.01,0,0,0Zm-2.81-6.9c-.08.12-.19-.07-.26.09.04-.03.23.03.26-.09Zm2.75,14.28s0-.02,0-.03c0,.01-.01.03,0,.03Z"></path>
                    <path class="cls-7" d="m101.75,72.52h0v.02s0-.02,0-.02Zm2.32,5.1s-.03.02-.05.04c.01,0,.03-.02.05-.04Zm.33,1.36v-.04s0,.03,0,.04Zm-.77-1.97s.02-.03,0-.05c0,.02.02.02,0,.05h0s0,0,0,0Zm-.28-.7s-.01.01-.02.02c0,0,.01.01.01.02v-.04s0,0,0,0Zm-6.18-13.23s.06-.05.1-.08c-.08.04-.15-.05-.1.08Zm7.63,23.66s-.04-.02-.05-.04c0,0,0,.02,0,.03.02,0,.04.01.05,0h0Zm-2.14-9.39l-.03-.12s.01.08.03.12Zm-3.5-9.25l-.02-.02s0,.02.02.02Zm3.32,8.81s.05-.07.06-.1c-.01,0-.02,0-.04,0l-.02.1h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m97.28,63h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m98.04,64.71l-.03-.05.03.05Zm.08.21s-.02-.06-.03-.09c.04-.02.08-.03.09-.01-.03,0-.04.06-.06.1h0Zm.67-.77s.01.05-.01.06c-.01-.02-.02-.04-.04-.05,0,0,.03,0,.05,0h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m98.61,64.16s-.03.01-.03.02h.04s0-.02,0-.02Zm6.92,19.08h0s0,0-.02,0h.01Zm-6.51-15.35h.03s-.03-.02-.03-.02v.02s0,0,0,0Zm6.14,16.6s-.02,0-.03.02c.01,0,.02,0,.03-.02Zm-.05.52l-.05.07s.04-.05.05-.07Zm-.1.39s.04.01.06.01h-.05s0-.01,0-.01Zm-1.41-6.07s-.03-.02,0,0Zm.99,1.69s-.06-.02-.08-.04c0,.04,0,.06.08.04Zm-1.92-3.64h0Z"></path>
                    <path class="cls-7" d="m104.48,80.89s0,.07.03.08c0-.03,0-.06-.03-.08Zm.15,6.17v.02s0,0,0,0c0,0,0-.03,0-.03Z"></path>
                    <path class="cls-7" d="m104.64,87.08v.03s.01-.02,0-.03Z"></path>
                    <path class="cls-7" d="m104.67,87.15s-.01-.04-.02-.05c0,.01-.01.03.02.05Zm.15-.59l-.04-.02s.02.01.04.02Z"></path>
                    <path class="cls-7" d="m104.85,86.41s-.12.07-.1.13h.04c-.06-.03.14-.08.07-.13h0Zm.69-.57l-.06.13c.05-.02.12-.04.13.03.17-.16-.12.02-.07-.16h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m105.66,85.41c.02.08.07,0,.1.01-.04-.05-.05-.07-.1-.01Zm-.19-3.16l.12-.02c-.03-.05-.04,0-.12.02Zm-.74-.42l-.06.07h.11s-.05-.07-.05-.07h0Zm.7-.58l.02.02-.07-.08.05.06h0Zm-1.92-4.86l-.13.07s.19-.03.13-.07Zm-.96-2.03c.06-.05.08-.12,0-.14,0,.05-.03.12,0,.14Zm-2.23-6.34l.06.02-.07-.07v.04s0,0,0,0Zm-15-23.81s.04-.12-.03-.12l-.07.14.1-.02h0Zm-.34-.35c-.08.06-.18.18-.16.32.09-.13.1-.07.2-.23.06,0,.09.07.07.12.03-.03.08.05.13-.04-.05-.13-.15-.16-.27-.08-.02-.04.01-.07.02-.1Zm-5.86.46h.04s-.03,0-.04,0Zm-3.52,1.01s.03-.03.03-.04c-.02.02-.04.03-.03.04Zm-.65.03s.03,0,.04,0c-.02,0-.03-.01-.04,0Z"></path>
                    <path class="cls-7" d="m79.12,44.31l-.11-.02s.06.02.11.02Zm5.03-.19s.04-.02.05-.03c-.02,0-.03,0-.05.01v.02s0,0,0,0Zm-3.51-.4h.03s0-.05,0-.07l-.04.07h0Zm1.25-.28s-.02.13-.02.19c0-.06.03-.08.05-.1,0-.03-.01-.06-.03-.09Zm2.02.14l.04-.02s-.03,0-.04.02Zm-4.14.37s-.02-.03-.03-.04c0,.02.01.03.03.04Zm-32.8,11.21s0-.01,0-.02c0,.01,0,.02,0,.02Zm-1.56-.19h.02s-.02-.08-.02-.08v.08h0Zm28.4-9.45s.01-.01,0,0Zm-10,3.21c.15.08-.14.2.07.27-.03-.04.1-.24-.07-.27Zm20.31-4.63s-.03,0-.05,0c.02,0,.04,0,.05,0Z"></path>
                    <path class="cls-7" d="m63.88,49h0s.02,0,.02,0h-.02s0,0,0,0Zm7.44-2.62s.03.03.04.05c0-.01-.02-.03-.04-.05Zm1.93-.41h-.05s.04,0,.05,0Zm-2.85.88s-.04-.02-.07.01c.02,0,.04-.02.07-.01Zm-1.01.31s.02.01.03.02l.03-.02s-.06,0-.06,0Zm-19.35,6.97s-.06-.06-.08-.1c.04.08-.1.16.08.1Zm34.12-10.1s-.02.05-.04.05h.04s0-.04,0-.05Zm-13.49,3.8l-.17.03c.06,0,.11-.01.17-.03Zm-13.36,4.02l-.03.03s.03,0,.03-.03Zm12.72-3.82s-.08-.05-.12-.06c0,.01,0,.02,0,.04l.13.02h0Z"></path>
                    <path class="cls-7" d="m49.95,54.05h0s0,0,0,0Z"></path>
                    <path class="cls-7" d="m52.45,53.18h0s-.07.03-.07.03l.07-.03h0Zm.3-.1s-.09.02-.13.04c-.02-.04-.03-.09,0-.09,0,.03.07.04.13.06,0,0,0,0,0,0Zm-.9-.66s.07-.01.08,0c-.03.01-.05.03-.08.04,0,0,0-.03,0-.05h0Z"></path>
                    <path class="cls-7" d="m51.81,52.62s0,.01-.02.01c.01,0,.02.01.04.02v-.04s-.02,0-.02,0Zm27.36-8.3h0s.01,0,.02.01c0,0-.01-.01-.01-.01Zm-22.19,7.71v-.03s-.03.03-.03.03h.03s0,0,0,0Zm23.97-7.78s.01.02.03.03c0,0-.01-.02-.03-.03Zm.72-.12l.11.03s-.08-.03-.11-.03Zm.56-.02s0-.04,0-.06v.06Zm-8.69,2.68s-.01,0-.02.01c-.04.04-.01.02.02-.01Zm2.52-1.1s-.04.06-.07.08c.05,0,.09-.01.07-.08Zm-5.38,2.15h0,0Z"></path>
                    <path class="cls-7" d="m75.87,45.81s.09,0,.12-.04c-.04,0-.09,0-.12.04Zm8.76-1.62h.03s0,0,0-.01h-.03s0,.01,0,.01Z"></path>
                    <path class="cls-7" d="m84.67,44.18h.03s-.03-.01-.03,0Z"></path>
                    <path class="cls-7" d="m84.77,44.14l-.07.02s.05.01.07-.02Zm-.86-.08v.05s0-.02,0-.05Z"></path>
                    <path class="cls-7" d="m83.69,44.06c.05.01.13.1.2.08v-.04c-.03.07-.15-.12-.2-.04Zm-.97-.57l.2.03s-.09-.11,0-.13c-.26-.14.06.11-.21.1h0Zm-.62-.02c.1-.04-.01-.07,0-.1-.06.05-.08.07,0,.1Zm-4.25,1.15l-.03-.12c-.07.04.01.04.03.12Zm-.61.83l.1.05v-.12s-.1.07-.1.07h0Zm-.72-.66l.03-.03-.12.08.09-.05h0Zm-6.98,2.21l.07.13s0-.2-.07-.13Zm-2.97,1.08c-.05-.06-.15-.08-.18,0,.07-.01.16.02.18,0Zm-9.12,2.58l.05-.07-.1.07h.06s0,0,0,0Z"></path>
                    <path id="E" class="cls-6" d="m76.61,89.77c7.51-2.51,11.38-11.13,8.65-19.25s-11.03-12.66-18.54-10.15-11.38,11.13-8.65,19.25,11.03,12.66,18.54,10.15h0Z"></path>
                    <path id="F" class="cls-8" d="m76.17,79.92l-1.63-4.84c.91-1.25,1.21-2.98.65-4.65-.89-2.63-3.58-4.11-6.01-3.29s-3.69,3.61-2.8,6.24c.5,1.49,1.58,2.6,2.86,3.15l1.73,5.13c.49,1.44,2.04,2.21,3.48,1.73,1.44-.48,2.21-2.03,1.73-3.47,0,0,0,0,0,0h0,0Z"></path>
                    <path id="F-2" class="cls-3" d="m76.17,79.92l-1.63-4.84c.91-1.25,1.21-2.98.65-4.65-.89-2.63-3.58-4.11-6.01-3.29s-3.69,3.61-2.8,6.24c.5,1.49,1.58,2.6,2.86,3.15l1.73,5.13c.49,1.44,2.04,2.21,3.48,1.73,1.44-.48,2.21-2.03,1.73-3.47,0,0,0,0,0,0h0,0Z"></path>
                </g>
            </svg>

            <h1>Please, enable Javascript!</h1>

            <p>In order to perform essential functions, this site requires Javascript to be enabled on your browser. Please go to your browser settings and enable Javascript for a seamless experience.</p>

            <div class="instructions">
                <h3>How to enable JavaScript:</h3>
                <ol>
                    <li>Open your browser's settings or preferences</li>
                    <li>Look for the "Privacy and Security" or "Content Settings" section</li>
                    <li>Find the JavaScript settings and ensure it's enabled</li>
                    <li>Refresh this page after enabling JavaScript</li>
                </ol>
            </div>

            <p>If you need assistance, please <a href="mailto:<?= CONTACT_MAIL ?>">contact our support team</a>.</p>

            <div class="footer">
                <p>&copy; <?= date('Y') . ' ' . SITE_NAME ?>. All rights reserved.</p>
            </div>

        </div>

    </body>

</html>