<?php

    // Connect To Database

    require('../controls/config/config.php');

    require('../controls/engines/fxns.php');

    maintenanceCheck(); // Check Maintenance Mode

    if (isset($_SESSION['RESTRICTED'])) { // Limit Access

        echo'<script>
                    
            window.location.href = "' . SITE_BASE_URL . '/security/restricted.php";
        
        </script>';

        exit();

    }

    // Target File Path

    $filePath = parse_url($_SERVER['PHP_SELF'], PHP_URL_PATH); // Get Path Only

    $target = pathinfo($filePath, PATHINFO_FILENAME);// Get Filename
    
    // Options For Page <title></title>

    $pageTitles = [

        'login' => 'Login',

        'password-reset' => 'Reset Your Password',

        'reset-password' => 'Setup New Password',

        'index' => 'Enter MFA Code',

        'register' => 'Register',

        
    ];

    if (array_key_exists($target, $pageTitles)) {

        $pageTitle = $pageTitles[$target];

    } else {

        $pageTitle = "Page";

    }

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">

        <link rel="icon" href="<?= SITE_FAVICON ?>">

        <link rel="stylesheet" href="../assets/stylesheets/core.css">

        <link rel="stylesheet" href="../resources/intl-tel-input/intlTelInput.css">

        <script type="text/javascript" src="../assets/scripts/script.js" defer></script>

        <noscript>
            <meta http-equiv="refresh" content="0; url=../noscript">
        </noscript>

        <script>
            (function() {
                const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

                // Check system preference and localStorage immediately
                const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                // Apply theme if dark mode is preferred by the user or if stored in localStorage
                if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                    page.classList.add('darkmode');
                }
            })();
        </script>

        <link rel="stylesheet" type="text/css" href="../resources/nice-select-2/nice-select2.css">

        <script type="text/javascript" src="../resources/nice-select-2/nice-select2.js"></script>

        <title><?= $pageTitle . ' | ' . SITE_NAME; ?></title>

    </head>

    <body>