<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('controls/config/config.php'); // Configuration File

    require('controls/engines/fxns.php'); // Functions File

    maintenanceCheck(); // Check Maintenance Mode

    if (isset($_SESSION['RESTRICTED'])) { // Limit Access

        echo'<script>
                    
            window.location.href = "' . SITE_BASE_URL . '/security/restricted.php";
        
        </script>';

        exit();

    }

    $target = filename(); // Get File Name

?>

<!DOCTYPE html>

<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" href="<?= SITE_FAVICON ?>">
        <title><?= SITE_TITLE ?></title>
        <script>
            (function() {
                const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

                // Check system preference and localStorage immediately
                const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                // Apply theme if dark mode is preferred by the user or if stored in localStorage
                if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                    page.setAttribute('data-theme', 'dark');
                }
            })();
        </script>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <link rel="stylesheet" href="assets/stylesheets/toast-notify.css">
        <style>
            /* :root { */
                /* colours hub */
                /* --primary-dark: rgb(20, 20, 20);
                --primary-medium: rgb(30, 30, 30);
                --primary-light: rgb(25, 25, 25);

                --text-light: #e2e8f0;
                --text-medium: #a0aec0;
                --text-dark: #64748b;

                --accent-primary: rgb(23, 109, 183);
                --accent-secondary: rgb(61, 135, 245);
                --accent-dark: #1e40af;


                --bg-primary: var(--primary-dark);
                --bg-secondary: var(--primary-medium);
                --bg-tertiary: var(--primary-light);
                --text-primary: var(--text-light);
                --text-secondary: var(--text-medium);
                --card-bg: var(--primary-dark);
                --border-color: #2d3748;
            } */


            /* html:not([data-theme="dark"]) {
                --bg-primary: rgb(250, 250, 250);
                --bg-secondary: #ffffff;
                --bg-tertiary: rgb(246, 246, 249);
                --text-primary: rgb(20, 20, 20);
                --text-secondary: rgb(102, 102, 102);
                --card-bg: #ffffff;
                --border-color: #e2e8f0;
            } */

            @import url(https://fonts.googleapis.com/css?family=Montserrat|Playfair+Display|Ubuntu+Mono);

            :root {

                --pg-txt: rgb(20, 20, 20);

                --pg-bg: rgb(250, 250, 250);

                --pg-bgB: rgb(246, 246, 249);

                --pg-bgC: rgb(255, 255, 255);

                --pg-bgD: rgb(240, 240, 240);

                --pg-bgE: transparent;

                --pg-bgF: transparent;

                --pg-bgG: rgb(255, 255, 255);

                --pg-bgH: transparent;

                --pg-bgI: rgba(200, 200, 200, 0.7);

                --pg-invert: rgba(20, 24, 31, 0.12);

                --pg-transp-bg: rgba(255, 255, 255, 0.5);

                --pg-transp-bgB: rgba(20, 20, 20, 0.2);

                --pg-transp-bgC: rgba(20, 20, 20, 0.5);

                --pg-svg: rgb(20, 20, 20);

                --pg-highlight: rgb(229, 233, 241);

                --pg-highlightB: rgb(241, 241, 241);

                --pg-border: 1px solid rgb(230, 230, 230);

                --pg-borderB: 1px solid rgb(240, 242, 245);

                --pg-borderC: 1px solid rgb(229, 233, 241);

                --pg-borderD: 1px solid rgb(230, 230, 230);

                --pg-borderE: 1px solid rgb(229, 233, 241);

                --pg-grey: rgb(229, 233, 241);

                --pg-greyB: rgb(102, 102, 102);

                --pg-greyC: rgb(200, 200, 200);

                --pg-link: rgb(61, 135, 245);

                --pg-i-border: rgb(225, 228, 235);

                --pg-thead: rgb(246, 246, 249);

                --pg-transp-box-shadow: rgba(20, 20, 20, 0.03);

                --pg-transp-box-shadowB: rgba(20, 20, 20, 0.06);

                --pg-sep: rgb(230, 230, 230);

                --pg-success: rgb(54, 179, 126);

                --pg-error: rgb(249, 58, 55);

                --pg-red: rgb(238, 49, 43);

                --pg-purple: rgb(81, 69, 132);

                --pg-lime: rgb(173, 250, 29);

                --JavaBlue: rgb(58, 117, 176);

                --VueBlue: rgb(33, 53, 71);

                --Ink: rgb(63, 81, 181);

                --BaseBlue: rgb(0, 70, 130);

                --MercBlu: rgb(23, 109, 183);

                --OmenXBlue: rgb(0, 150, 214);

                --MichelinBlue: rgb(39, 80, 155);

                --RadE: rgb(185, 1, 3);

                --JavaGreen: rgb(25, 135, 84);

                --VueGreen: rgb(66, 184, 131);

                --Verify: rgb(23, 191, 99);

                --lightteal: rgb(30, 181, 137);

                --orange: rgb(255, 153, 70);

                --yellow: rgb(255, 217, 100);

                --boomYellow: rgb(212, 207, 134);

                --chestnut: rgb(242, 204, 142);

                --JavaGrey: rgb(122, 115, 110);

                --white: rgb(255, 255, 255);

                --black: rgb(0, 0, 0);

                --RadBlack: rgb(20, 20, 20);

                --baseFont: 'Montserrat', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;

                --subFont: 'Playfair Display', Georgia, 'Times New Roman', Times, serif;

                --monoFont: 'Ubuntu Mono', 'Courier New', Courier, monospace;

            }

            /* Darkmode */

            /* @media screen and (prefers-color-scheme: dark) {*/

                [data-theme="dark"] {

                    color-scheme: dark;

                    --pg-txt: rgb(250, 250, 250);

                    --pg-bg: rgb(20, 20, 20);

                    --pg-bgB: rgb(30, 30, 30);

                    --pg-bgC: rgb(25, 25, 25);

                    --pg-bgD: rgb(30, 30, 30);

                    --pg-bgE: rgb(35, 35, 35);

                    --pg-bgF: rgb(25, 25, 25);

                    --pg-bgG: rgb(20, 20, 20);

                    --pg-bgH: rgb(20, 20, 20);

                    --pg-bgI: rgba(7, 7, 7, 0.7);

                    --pg-thead: rgb(46, 46, 49);

                    --pg-transp-bg: rgba(55, 55, 55, 0.5);

                    --pg-transp-bgB: rgba(255, 255, 255, 0.2);

                    --pg-transp-bgC: rgba(255, 255, 255, 0.5);

                    --pg-invert: rgba(220, 224, 231, 0.12);

                    --pg-svg: rgb(250, 250, 250);

                    --pg-highlight: rgb(229, 233, 241, 0.07);

                    --pg-highlightB: rgba(241, 241, 241, 0.1);

                    --pg-border: none;

                    --pg-borderB: 1px solid rgb(102, 102, 102);

                    --pg-borderC: none;

                    --pg-borderD: 1px solid transparent;

                    --pg-borderE: 1px solid rgb(102, 102, 102);

                    --pg-i-border: none;

                    --pg-transp-box-shadow: rgba(250, 250, 250, 0.03);

                    --pg-transp-box-shadowB: rgba(250, 250, 250, 0.06);

                    --pg-sep: rgb(102, 102, 102);

                }
                
           /* }*/

            html {

                font-family: var(--baseFont);

                font-size: 100%;

                scroll-behavior: smooth;
            
            }

            .c-info-toggle {

                cursor: pointer;

            }

            h1, h2, h3 {

                font-family: var(--subFont);

            }

            body {
                background-color: var(--pg-bgB);
                color: var(--pg-txt);
                transition: background-color 0.3s, color 0.3s;
            }

            .hero-gradient {
                /* background: linear-gradient(135deg, var(--pg-bgC) 0%, var(--pg-bgB) 50%, var(--pg-bgC) 100%); */

                background: linear-gradient(150deg, var(--pg-bgC) 0%, var(--pg-transp-bg)50%, var(--pg-bgC) 100%);
            }

            /* html:not([data-theme="dark"]) .hero-gradient {
                background: linear-gradient(135deg, #ffffff 0%, #f1f5f9 50%, #e2e8f0 100%);
            } */

            .feature-card {
                background-color: var(--pg-bg);
                border-color: var(--border-color);
                transition: all 0.3s ease;
            }

            .feature-card:hover {
                transform: translateY(-5px);
                box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.3),
                    0 10px 10px -5px rgba(0, 0, 0, 0.2);
            }

            .modal {
                transition: opacity 0.3s ease, visibility 0.3s ease;
            }

            .modal-content {
                transition: transform 0.3s ease;
                background-color: var(--bg-secondary);
            }

            .modal.active {
                opacity: 1;
                visibility: visible;
            }

            .modal.active .modal-content {
                transform: translateY(0);
            }

            /* Back to top button */
            #backToTop {
                display: none;
            }


            .bg-gray-50 {
                background-color: var(--bg-secondary);
            }

            .bg-white {
                background-color: var(--bg-tertiary);
            }

            .text-gray-600,
            .text-gray-500,
            .text-gray-400 {
                color: var(--text-secondary);
            }

            .text-gray-800 {
                color: var(--text-primary);
            }

            .border-gray-100,
            .border-gray-300 {
                border-color: var(--border-color);
            }

            .bg-blue-100 {
                background-color: rgba(37, 99, 235, 0.2);
            }

            .text-blue-600 {
                color: var(--MercBlu) !important;
            }

            .bg-blue-600 {
                background-color: var(--MercBlu);
            }

            .bg-blue-700 {
                background-color: var(--MercBlu);
            }

            .hover\:bg-blue-700:hover {
                background-color: var(--MercBlu);
            }

            .border-white {
                border-color: var(--text-primary);
            }

            .text-blue-100 {
                color: #dbeafe;
            }

            .text-yellow-400 {
                color: #fbbf24;
            }

            .bg-gray-100 {
                background-color: var(--bg-secondary);
            }

            .bg-gray-900 {
                background-color: var(--card-bg);
            }

            .text-green-300 {
                color: #86efac;
            }

            .bg-indigo-900 {
                background-color: #2563eb;
            }

            input,
            select,
            textarea {
                background-color: var(--bg-secondary);
                color: var(--text-primary);
                border-color: var(--border-color);
                transition: background-color 0.3s, color 0.3s;
            }

            input::placeholder,
            textarea::placeholder {
                color: var(--text-secondary);
            }

            /* Theme toggle button */
            #themeToggle {
                transition: all 0.3s ease;
            }

            /* Light mode adjustments */
            html:not([data-theme="dark"]) .feature-card {
                box-shadow: 0 4px 6px -1px rgba(255, 255, 255, 0.05), 0 2px 4px -1px rgba(0, 0, 0, 0.03);
            }

            html:not([data-theme="dark"]) .feature-card:hover {
                box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            }


            html:not([data-theme="dark"]) header {
                background-color: #ffffff;
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            }

            html:not([data-theme="dark"]) .bg-gray-800 {
                background-color: #f1f5f9;
            }

            html:not([data-theme="dark"]) .bg-indigo-900 {
                background-color: #2563eb;
            }

            html:not([data-theme="dark"]) .bg-indigo-800 {
                background-color: #3b82f6;
            }

                    
            /* html:not([data-theme="dark"]) .bg-blue-600 {
                color: #1e40af;
            } */

            html:not([data-theme="dark"]) .bg-gray-950 {
                background-color: #f8fafc;
            }

            footer {

                color: var(--white);

                background-color: var(--RadBlack);

            }

            html:not([data-theme="dark"]) .modal-content h3 {
                color: #1e293b;
            }

            html:not([data-theme="dark"]) .modal-content label {
                color: #374151;
            }

            /* Trust indicators in light mode */
            html:not([data-theme="dark"]) .text-indigo-400 {
                color: #2563eb;
            }

            html:not([data-theme="dark"]) .text-gray-400 {
                color: #64748b;
            }

            html:not([data-theme="dark"]) .text-blue-650 {
                color: var(--MercBlu);
            }

            html:not([data-theme="dark"]) .logo img {

                display: none !important;

            }

            html:not([data-theme="dark"]) .logo img.light {

                display: block !important;

            }

            [data-theme="dark"] .logo img {

                display: block !important;

            }

            [data-theme="dark"] .logo img.light {

                display: none !important;

            }

            .bg-blue-800 {

                background-color: var(--JavaBlue) !important;

            }

        </style>
    </head>

    <body class="font-sans antialiased">
        <!-- Navigation -->
        <header class=" top-0 z-50 hero-gradient shadow-sm">
            <div class="container mx-auto px-4 py-3 gap-5 md:gap-8 flex justify-between items-center">
                <div class="flex items-center">
                    <a<?= ($target == 'home') ? ' href="#top"' : ' href="home"' ?> class="flex items-center">
                        <!-- logo -->
                        <div class="logo w-[150px] h-[75px] flex items-center justify-center">
                            <img src="<?= SITE_LOGO ?>"
                                alt="<?= SITE_NAME ?>" class="light block hidden w-full h-full object-contain">
                            <img src="<?= SITE_LOGO_DARK ?>"
                                alt="<?= SITE_NAME ?>" class="dark:block hidden w-full h-full object-contain">
                        </div>
                    </a>
                </div>

                <nav class="md:flex hidden flex justify-around items-center gap-8 mx-auto">
                    <a<?= ($target == 'home') ? ' href="#top"' : ' href="home"' ?> class="<?= ($target == 'home') ? 'text-blue-600 font-medium ' : 'text-gray-400 hover:text-blue-600 ' ?>mobile-link">Home</a>
                    <a href="about"
                        class="<?= ($target == 'about') ? 'text-blue-600 font-medium ' : 'text-gray-400 hover:text-blue-600 ' ?>transition mobile-link">About</a>
                    <a href="help-center#faq" class="text-gray-400 hover:text-blue-600 transition mobile-link">FAQs</a>
                    <a href="uetr/search" class="text-gray-400 hover:text-blue-600 transition mobile-link" target="_blank">
                        <i class="fas fa-search"></i>
                        <span>UETR</span>
                    </a>
                    <a class="c-info-toggle text-gray-400 hover:text-blue-600 transition mobile-link">Contact</a>
                </nav>

                <div class="flex items-center space-x-4">

                    <div class="mx-3">

                        <div class="gtranslate_wrapper"></div>

                    </div>

                    <a href="auth/login" class="hidden md:block text-blue-600 font-medium hover:text-blue-800 transition">Log In</a>

                    <button class="md:hidden text-gray-400 menuBtn">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                </div>

                <div id="mobileNav" class="hidden p-4 pt-1 bg-black h-full flex flex-col fixed top-0 right-0 left-0 z-50 shadow-sm">

                    <div class="flex items-center justify-between mb-4">
                        <a<?= ($target == 'home') ? ' href="#top"' : ' href="home"' ?> class="flex items-center">
                            <!-- logo -->
                            <div class="w-[150px] h-[75px] flex items-center justify-center">
                                <img src="<?= SITE_LOGO_DARK ?>"
                                    alt="<?= SITE_NAME ?>" class="w-full h-full object-contain">
                            </div>
                        </a>

                        <button class="md:hidden text-white menuBtn">
                            <i class="fas fa-close text-xl"></i>
                        </button>

                    </div>

                    <nav class="flex flex-col w-full justify-start items-left gap-8">
                        <a<?= ($target == 'home') ? ' href="#top"' : ' href="home"' ?> class="<?= ($target == 'home') ? 'text-blue-600 font-medium ' : 'text-gray-400 hover:text-blue-600 ' ?>mobile-link">Home</a>
                        <a href="about"
                            class="<?= ($target == 'about') ? 'text-blue-600 font-medium ' : 'text-gray-400 hover:text-blue-600 ' ?>transition mobile-link">About</a>
                        <a href="help-center#faq" class="text-gray-400 hover:text-blue-600 transition mobile-link">FAQs</a>
                        <a href="uetr/search" class="text-gray-400 hover:text-blue-600 transition mobile-link" target="_blank">
                            <i class="fas fa-search"></i>
                            <span>UETR</span>
                        </a>
                        <a class="c-info-toggle text-gray-400 hover:text-blue-600 transition mobile-link">Contact</a>
                    </nav>
                </div>
            </div>
        </header>
