<?php

    session_name('USERSESSID');

    session_start(); // Initialize Session

    require('../controls/config/config.php'); // Configuration File

    require('../controls/engines/fxns.php'); // Functions File 

    maintenanceCheck(); // Check Maintenance Mode

    if (isset($_SESSION['RESTRICTED'])) { // Limit Access

        echo'<script>
                    
            window.location.href = "' . SITE_BASE_URL . '/security/restricted.php";
        
        </script>';

        exit();

    }

    httpErrorCheck('../'); // Listen For HTTP Error Codes (Custom Error Pages)

    $access = dashboardAccess(); // Check Access Status

    $user_id = $access['main-user']; // Main User

    $currentUser = $access['current-user']; // Logged In

    $userType = $access['user-type']; // User Type 

    validateUser($conn, $user_id); // Validate User

    $userData = userData($user_id, $conn); // User Data

    if (isset($_SESSION['B-CODE'])) { // Track Billing Code(s) 

        $codeTrack = isset($_SESSION['CODE-TRACK']) ? $_SESSION['CODE-TRACK'] : 0;

        $codeCount = bcodeCount($user_id, $conn);

        if ($codeTrack < $codeCount) {

            $codeData = currentBcode($currentUser, $conn, $codeTrack);

        } else {

            unset($_SESSION['B-CODE']);

            unset($_SESSION['CODE-TRACK']);

            echo '<script>
            
                window.history.go(-1);

            </script>';

            exit;

        }

    }

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <link rel="stylesheet" type="text/css" href="../assets/stylesheets/core.css">

        <noscript>
            <meta http-equiv="refresh" content="0; url=../noscript">
        </noscript>

        <script>
            (function() {
                const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

                // Check system preference and localStorage immediately
                const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
                
                // Apply theme if dark mode is preferred by the user or if stored in localStorage
                if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                page.classList.add('darkmode');
                }
            })();
        </script>

        <script src="../assets/scripts/popup-notify.js"></script>

        <script type="text/javascript" src="../assets/scripts/script.js" defer></script>

        <!-- Face API -->

        <!-- <script src="https://cdn.jsdelivr.net/npm/face-api.js"></script> -->

        <!-- WebCam JS -->

        <!-- <script src="https://cdn.rawgit.com/jhuckaby/webcamjs/1.0.25/webcam.min.js"></script> -->

        <!-- Nice Select -->

        <script src="../resources/nice-select-2/nice-select2.js"></script>

        <link rel="stylesheet" type="text/css" href="../resources/nice-select-2/nice-select2.css">

        <title><?= 'Page'; //pageTitles($target) ?> | Banking System</title>

    </head>

    <body>

        <?php
        
            require('preloader.php');
        
        ?>
        
        <header>

            <div class="aux_header">

                <div class="progress">

                    <div class="track iQ_track"></div>

                </div>
                
                <div class="auxH_con">

                    <div class="auxH_box"<?= isset($_SESSION['TRANSF-ID']) ? ' style="opacity: 0;"' : null ?>>

                        <a<?= isset($_SESSION['TRANSF-ID']) ? ' href="home"' : ' onclick="return(history.back());"' ?> class="back_ctrl">

                            <svg width="17" height="15" viewBox="0 0 17 15" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.79822 2.78332L4.27745 6.26295L14.7838 6.31095C15.1085 6.31216 15.4193 6.44245 15.6479 6.67311C15.8764 6.90377 16.0038 7.21585 16.0019 7.54053C16.0004 7.86502 15.87 8.1756 15.6394 8.40387C15.4087 8.63214 15.0968 8.75937 14.7723 8.75755L4.2683 8.7107L7.74223 12.2258C7.9709 12.456 8.09867 12.7677 8.09738 13.0922C8.0961 13.4167 7.96586 13.7274 7.73537 13.9559C7.2549 14.4313 6.48017 14.4277 6.00412 13.9479L0.290433 8.17818C-0.098626 7.78278 -0.0935099 7.14685 0.301861 6.75776L6.07611 1.04407C6.55619 0.568793 7.33056 0.572374 7.80622 1.05207C8.03481 1.28267 8.1624 1.59465 8.1609 1.91935C8.1594 2.24405 8.02894 2.55484 7.79822 2.78332Z" fill="#808080"></path></svg>
    
                        </a>

                        <div class="logo jaQ">

                            <a href="home"> 

                                <?php

                                    if (isset($_SESSION['TRANSF-ID'])) { ?>

                                        <span class="font-sm">Back to dashboard</span>

                                   <?php } else { ?>

                                        <img class="light" src="<?= SITE_LOGO ?>" alt="">

                                        <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

                                   <?php }

                                ?>

                            </a>
        
                        </div>

                    </div>

                    <?php
                    
                        if (isset($_SESSION['TRANSF-ID'])) {

                            echo '<script>
                            
                                setTimeout(() => {
                                
                                    document.querySelectorAll(".auxH_box").forEach(item => {
                                    
                                        item.style.opacity = 1;

                                    });

                                }, 12000);

                            </script>';

                        }
                    
                    ?>

                    <div class="auxH_box">

                        <div class="gtranslate_wrapper"></div>

                    </div>

                </div>

            </div>

        </header>

        <main class="aux_main">