<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../controls/config/config.php'); // Configuration Setup

    require('../controls/engines/fxns.php'); // Function Definitions

    maintenanceCheck();

    httpErrorCheck('../');

    if (!isset($_SESSION['RESTRICTED'])) { // Limit Access

        echo'<script>
                    
            window.location.href = "../";
        
        </script>';

        exit();

    }

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    
        <link rel="icon" href="<?= SITE_FAVICON ?>">

        <link rel="stylesheet" type="text/css" href="../assets/stylesheets/core.css">

        <script type="text/javascript" src="../assets/scripts/script.js" defer></script>

        <title><?= isset($_SESSION['NO-ACCESS']) ? 'Access Denied' : 'Location Restricted' ?> | <?= SITE_TITLE ?></title>

        <style>

            #visualBox {

                display: flex;

                flex-direction: column;

                align-items: center;

                justify-content: space-between;

                gap: 2em;

                padding: 1em;

            }

            #visualBox, .vzB_header {

                max-width: 2000px;

                margin: 0 auto;

            }

            .vzB_header {

                display: flex;

                justify-content: space-between;

                align-items: center;

                width: 100%;

            }
            
            .vzB_main {

                display: flex;

                flex-direction: column;

                align-items: center;

                justify-content: center;

            }

            .vzB_main img {

                user-select: none;

                pointer-events: none;

            }

            .vzB_main .title {

                margin-bottom: 0.5em;

                font-size: 1.5rem;

                font-weight: 600;

            }

            .marquees {

                position: relative;

                overflow: hidden;

                width: 100%;

                user-select: none;

                pointer-events: none;

                touch-action: none;

            }

            .mrqBox {

                display: flex;

                gap: 2em;

                align-items: center;

                max-width: 100%;

                overflow: hidden;

            }

            #mrQ-f {

                direction: ltr;

            }

            #mrQ-r {

                direction: rtl;

            }

            .mrqBox .title {

                width: 100%;

                border-inline-end: var(--pg-border);

                background-color: var(--pg-bg);

                height: 5em;

                display: flex;

                align-items: center;

                padding: 1em;

                position: relative;

                z-index: 1;

                text-wrap: nowrap;

            }

            .mrQ_con {

                display: flex;

                gap: 2em;

                align-items: center;

                padding: 0 1em;

                animation: marquee calc(26 * 3s) linear infinite;  /* duration: Number of Logos * 3s */ 

            }

            #mrQ-r {

                animation-direction: reverse;

            }

            .mrQ_img {

                width: 100%;

                min-width: 7em;

                height: 5em;

                display: flex;

            }

            .mrQ_img img {

                object-fit: contain;

            }

            html:not(html.darkmode) img.fi_invert.switch {

                filter: invert(1);

            }

            .darkmode img.integrate {

                filter: invert(1);

            }

            @keyframes marquee {
                0% {
                    transform: translateX(0%);
                }
                100% {
                    transform: translateX(calc(-1 * 7em * 20)); /* Min-width Of Logo * Number of Logos */ 
                }
            }


        </style>

    </head>

    <body>

        <header class="landing_header">

            <div class="dash_hbanner">

                <div class="vzB_header">

                    <div class="logo">

                        <a>

                            <img class="light" src="<?= SITE_LOGO ?>" alt="">

                            <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">
                            
                        </a>

                    </div>

                    <div class="gtranslate_wrapper"></div>

                </div>

            </div>

            
        </header>

        <div id="visualBox">

            <div class="vzB_main">

                <?php
                
                    // Change Page Content Based On Access Flag

                    if (isset($_SESSION['NO-ACCESS'])) { // Check Access Flag

                        echo '<img src="../assets/media/icons/no-access.webp" alt="" style="width: 10em; margin-bottom: 2em;">
                        
                        <p class="title" style="color: var(--pg-error)">Access Denied!</p>
                
                        <p>Please try again in 24 - 72 hours time!</p>';

                        unset($_SESSION['NO-ACCESS']);

                    } else {

                        echo '<img src="../assets/media/icons/71d86054fc5b45dd84ae1243d207fa93.svg" alt="">
                        
                        <p class="title">Location Restricted!</p>
                
                        <p>Your IP address ('. (isset($_SESSION['IP']) ? $_SESSION['IP'] : '-') . " " . '<sup><img src="' . (isset($_SESSION['FLAG']) ? $_SESSION['FLAG'] : '-') .'" alt="" width="25px"></sup><small>' . ' ' . (isset($_SESSION['CITY']) ? $_SESSION['CITY'] : '-') . ', ' . (isset($_SESSION['COUNTRY']) ? $_SESSION['COUNTRY'] : '-') . '</small>) may have been restricted</p>';

                    }
                
                ?>
                
            </div>

            <div class="vzB_footer">

                <p class="form_info" style="font-size: 0.8rem; color: rgb(3, 100, 185); margin-top: 1.2em; text-shadow: 0px 0px 1px var(--black);">Please kindly enter your banking account email address and click on authorize to gain access.</p>

                <form method="post" id="authorizeForm">

                    <div class="form_item">

                        <label for="email">Email</label>

                        <input name="email" type="email" placeholder="Enter your email address" required class="form_field" style="width: auto;">

                        <button name="auth_access" id="authorizer" class="form_btn" type="submit" style="width: auto;">Authorize</button>

                    </div>

                </form> 

            </div>

            <div class="marquees">

                <div class="mrqBox">

                    <div class="title">

                        <p>Trusted By</p>

                    </div>

                    <div class="mrQ">

                        <div class="mrQ_con" id="mrQ-f">

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/AMD_footer_logo.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/space-x.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/Nvidia.svg" alt="">

                            </div>
                            
                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/tesla.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/mm-logo.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/snapdragon_footer_logo.png" alt="">

                            </div>

                            
                            

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/wc.svg" alt="">

                            </div>
                            
                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/66f2458ede86da3c12403757_revolut logo.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/6479996c8bf5dcb4a67fd582_trezor 1.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/virgin.svg" alt="">

                            </div>
                            
                            
                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/kraken-logo-BDS-5b36ef70e12e0a05266fabe73dedaa63.webp" alt="">

                            </div>
                            
                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/samsung.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/62d51550b24bb2904d1a6ce6_FUQdx_tVEAAL6Z3-p-1080.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-axieinfinity.webp" alt="">

                            </div>
                            
                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/Boeing.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/643e958038f236bc2e8756cc_binance logo.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-apple-uai-258x169.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/64799917cb9736d26d9fa89e_full-ledger-logo 1.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-mercedes-benz-uai-258x169.png" alt="">

                            </div>
                            
                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/ethereum_foundation.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/microsoft_logo_ee5c8d9fb6248c938fd0.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-sap-uai-258x169.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/paxful.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/alibaba.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/664288277c5ef5ec5ee3e744_OKX_Logo 1.png" alt="">

                            </div>
                            
                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/Luminar.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/new-electrum-textlogo-svgrepo-com.svg" alt="">

                            </div>

                            
                            
                        </div>

                    </div>

                </div>

                <div class="mrqBox">

                    <div class="mrQ">

                        

                        <div class="mrQ_con" id="mrQ-r">

                            <div class="mrQ_img">

                                <img class="fi_invert" src="../assets/media/marquee/48f81055b9722997ebea7d4c410d931b60484f49-120x32.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert" src="../assets/media/marquee/optimism.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-opensea.webp" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/siemens.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/blockchain.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/gazprom.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-maker.webp" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/intel.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert" src="../assets/media/marquee/solana_foundation.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/HP_footer_logo.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-aave.webp" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/changelly.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-compound.webp" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/eird.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/exodus.5e5e8337.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/f1.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-rarible.webp" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-amazon-uai-258x169.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/dapp-uniswap.webp" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-ibm-uai-258x169.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-visa-uai-258x169.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert" src="../assets/media/marquee/a6793b86dbe86ab6e071f174adb1d7b2392be57d-120x32.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img src="../assets/media/marquee/tangem.67d684ae.svg" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="fi_invert switch" src="../assets/media/marquee/company-logo-image-nike-uai-258x169.png" alt="">

                            </div>

                            <div class="mrQ_img">

                                <img class="integrate" src="../assets/media/marquee/ford-loader.svg" alt="">

                            </div>
                           
                        </div>

                    </div>
                    
                    <!-- <div class="title">

                        <p>Trusted By</p>

                    </div> -->

                </div>

            </div>

        </div>

        <!-- Toast -->

        <div id="toast"></div>

        <script src="../assets/scripts/toast-notify.js"></script>

        <script src="../assets/scripts/processor-bridge.js"></script>
 
        <!-- Google Translate -->
        
        <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
        <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>


    </body>

</html>