<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Fetch Card Data

        $cardFound = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname` FROM `virtual_cards` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` WHERE `A`.`card_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            $cardFound = true; // Update Flag

            // Iterate Through Record Data

            while ($row = mysqli_fetch_assoc($result)) {

                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                $balance = $row['balance'];

                $currency = $row['currency'];

                $symbol = $currSymbol[$currency];
                
                $provider = $row['provider'];

                $number = $row['card_number'];

                $cvv = $row['cvv'];

                $fund = $row['fund_by'];

                $status = $row['status'];

                $color = $row['color'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$cardFound) {

            echo '<script>
        
                swal({
                
                    title: "Attention!",

                    text: "Error! No data found.",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);

                });

            </script>';

            exit;

        }
    

    } else {

        echo '<script>

            swal({
                
                title: "Attention!",

                text: "Error! No data found.",

                icon: "error"

            }).then(() => {
            
                window.history.go(-1);

            });

        </script>';

        exit;

    }

?>

<div class="nk-content nk-content-fluid">
<div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Update Virtual Card Balance.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="buysell wide-xs m-auto">
                <div class="buysell-title text-center">
                    <h2 class="title">Update Virtual Card Balance</h2>
                </div><!-- .buysell-title -->
                <div class="buysell-block">

                    <form id="cardBalForm" class="buysell-form" method="post">
                        <div class="buysell-field form-group">
                            <div class="form-label-group">
                                <label class="form-label">Virtual Card:</label>
                            </div>
                            <input type="hidden" value="<?= isset($id) ? $id : '' ?>" name="card" id="user">
                            <div class="dropdown buysell-cc-dropdown">
                                <a href="#" class="buysell-cc-choosen dropdown-indicator">
                                    <div class="coin-item coin-btc">
                                        <div class="coin-icon">
                                            <em class="icon ni ni-cc-alt text-info"></em>
                                        </div>
                                        <div class="coin-info">
                                            <span class="coin-name">
                                                <?= $name ?>
                                            </span>
                                            <span class="coin-text"><?= isset($number) && isset($provider) ? $number . ' (' . $provider . ')' : '' ?>
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </div><!-- .dropdown -->
                        </div><!-- .buysell-field -->
                        
                        <div class="buysell-field form-group">
                            <div class="form-label-group">
                                <label class="form-label">Balance (<?= isset($currency) ? $currency : '' ?>)</label>
                            </div>
                            <div class="buysell-field form-group">
                                <div class="form-label-group">
                                </div>
                                <div class="form-control-group">
                                    <input type="number" step="0.01" min="0" value="<?= isset($balance) ? $balance : '' ?>" class="form-control form-control-lg form-control-number" id="status" name="balance">
                                    
                                    <!-- <div class="form-dropdown">
                                        <div class="text">Up<span></span></div>
                                    </div> -->
                                </div>
                            </div>
                        </div>
                        <div class="buysell-field form-action">
                            <button type="submit" class="btn btn-lg btn-block btn-primary" id="cardBalBtn">Proceed</a>
                        </div><!-- .buysell-field -->
                    </form><!-- .buysell-form -->
                </div><!-- .buysell-block -->
            </div><!-- .buysell -->
        </div>
    </div>
</div>

<?php

    require('utility/partials/footer.php');

?>