<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $cardData = cardData($id, $conn);

        if (!$cardData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "Virtual card not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid Data Signature",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">

    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit <i>Virtual Card</i></span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="code-status" class="btn btn-danger"><span>Billing Codes</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-cc-alt2-fill"></em> Edit Virtual Card</h5>
        </div>
        <form id="cardPropForm" method="post">
            <div class="card-body">
                <b>Virtual Card Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <input type="hidden" name="card" value="<?= isset($id) ? $id : '' ?>">
                            <label class="form-label" for="card-provider">Provider</label>
                            <input type="text" class="form-control" id="card-provider" name="card-provider" value="<?= isset($cardData['provider']) ? $cardData['provider'] : null ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="card-expires">Valid Till (End of the Month)</label>
                            <input type="date" class="form-control" id="code-abbr" name="card-expires" value="<?= (isset($cardData['expires'])) ? $cardData['expires'] : null ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="card-fund">Fund Card</label>
                            <select class="form-control" id="card-fund" name="card-fund"
                                required>
                            
                                <option value="BOTH" <?= (isset($cardData) && $cardData == 'BOTH') ? ' selected' : null ?>>All Sources</option>

                                <option value="BALANCE" <?= (isset($cardData) && $cardData == 'BALANCE') ? ' selected' : null ?>>From Account Balance</option>

                                <option value="PAY" <?= (isset($cardData) && $cardData == 'PAY') ? ' selected' : null ?>>From Deposit</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card-currency">Currency/Account</label>
                            <input class="form-control" name="card-currency" value="<?= isset($cardData['currency']) ? $cardData['currency'] : null ?>" readonly>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card-balance">Balance</label>
                            <input class="form-control" type="number" name="card-balance" min="0" step="0.01" value="<?= isset($cardData['balance']) ? $cardData['balance'] : null ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="card-color">Color</label>
                            <input type="color" class="form-control" id="card-color" name="card-color" value="<?= isset($cardData['color']) ? $cardData['color'] : null ?>">
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="editCard" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>