<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `messages` WHERE `ticket_id` = ? ORDER BY `id`"); // Prepare Statement (Get Ticket Conversations)

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo '<script>
        
                swal({
                
                    title: "Attention!",

                    text: "Error! No data found.",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);

                });

            </script>';

            exit;

        }
    
    } else {

        echo '<script>

            swal({

                title: "Attention!",

                text: "Error! No data found.",

                icon: "error"

            }).then(() => {

                window.history.go(-1);

            });

        </script>';

        exit;

    }

?>

<div class="nk-content">

    <div class="card card-bordered card-preview">

        <div class="card-header text-white" style="background-color: #033d75; color: white;">
            <h5 class="modal-title">
                <?= $id ?>
            </h5>
        </div>

        <div class="card-body bg-light">
            <p class="card-bordered rounded-sm p-1 bg-white">
                <?php
                
                ?>
            </p>
            <hr style="height:3px; background-color: #033d75; border-radius:3px;">
            <strong class="text-center">Conversation</strong>
            <div id="chatSection" style="overflow: auto; max-height: 600px;">

                <?php
                
                    // Display Conversation(s)

                    foreach ($data as $row):

                        $message = $row['message_text'];

                        $date = date('D, M d, Y h:i a', strtotime($row['created_at']));

                        $sender = $row['sender'];

                        $class = "alert-light mr-auto";

                        if ($sender == 'Agent' || $sender == null) {

                            $class = "bg-dark text-light ml-auto";

                        } ?>

                        <div class="card p-3 w-auto my-1 <?= $class ?>" style="max-width: 450px;">
                            <p><?= $message ?></p>

                            <p class="text-right"><small><?= $date . ' [UTC]' ?></small></p>

                        </div>

                    <?php endforeach;
                
                ?>

            </div>
        </div>
        
        <form method="post" id="chatForm" style="position: sticky; bottom: 0;">
            <div class="nk-chat-editor" style="border-color:black;">
                <div class="nk-chat-editor-upload  ml-n1">
                    <!-- <a href="#" class="btn btn-round btn-primary btn-icon"><em class="icon ni ni-plus-circle-fill"></em></a> -->
                </div>
                <div class="chatResult"></div>
                <div class="nk-chat-editor-form">
                    <div class="form-control-wrap">
                        <input type="hidden" name="ticket-id" value="<?= isset($id) ? $id : '' ?>">
                        <textarea name="reply" class="form-control form-control-simple no-resize" rows="1" placeholder="Type your message..." required></textarea>
                    </div>
                </div>
                <ul class="nk-chat-editor-tools g-2">
                    <li>
                        <!-- <div class="sendResult"></div> -->
                        <button type="submit" class="btn btn-round btn-primary btn-icon" id="sendMsg"><em class="icon ni ni-send-alt"></em></button>
                    </li>
                </ul>
            </div>
        </form>

    </div>    

</div>

<?php

    require('utility/partials/footer.php');

?>