<?php

    require('utility/partials/header.php')

?>

<div class="nk-content ">
    <div class="container wide-xl">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-content-wrap">
                    <div class="nk-block-head nk-block-head-sm">
                        <div class="nk-block-between">
                            <div class="nk-block-head-content">
                                <h3 class="nk-block-title page-title">Overview</h3>
                                <div class="nk-block-des text-soft">
                                    <p>Welcome, <?= $adminData['firstname'] ?>.</p>
                                </div>
                            </div>
                            <div class="nk-block-head-content">
                                <div class="toggle-wrap nk-block-tools-toggle"><a href="#"
                                        class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="pageMenu"><em
                                            class="icon ni ni-more-v"></em></a>
                                    <div class="toggle-expand-content" data-content="pageMenu">
                                        <ul class="nk-block-tools g-3">
                                            <li>
                                                <div class="drodown"><a href="login-activity"
                                                        class="btn btn-white btn-dim btn-outline-light"
                                                        ><em
                                                            class="d-none d-sm-inline icon ni ni-activity-alt"></em><span>Login Activity</span><em
                                                            class="dd-indc icon ni ni-chevron-right"></em></a>
                                                </div>
                                            </li>
                                            <li class="nk-block-tools-opt"><a href="settings" class="btn btn-primary"><em
                                                        class="icon ni ni-setting reports"></em><span>Settings</span></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="nk-block">
                        <div class="row g-gs">
                            <div class="col-sm-3">
                                <div class="card card-bordered">
                                    <div class="card-inner">
                                        <div class="card-title-group align-start mb-2">
                                            <div class="card-title">
                                                <h6 class="title">Total Users</h6>
                                            </div>
                                            <div class="card-tools"><em class="card-hint icon ni ni-users-fill"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    aria-label="Total Users"
                                                    data-bs-original-title="Total Users"></em></div>
                                        </div>
                                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                            <div class="nk-sale-data"><span class="amount"><?= shortenNumber(totalUsers($conn), 2) ?></span></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="card card-bordered">
                                    <div class="card-inner">
                                        <div class="card-title-group align-start mb-2">
                                            <div class="card-title">
                                                <h6 class="title">Total Accounts</h6>
                                            </div>
                                            <div class="card-tools"><em class="card-hint icon ni ni-sign-dollar"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    aria-label="Total Accounts"
                                                    data-bs-original-title="Total Accounts"></em></div>
                                        </div>
                                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                            <div class="nk-sale-data"><span class="amount"><?= shortenNumber(totalAccounts($conn), 2) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="card card-bordered">
                                    <div class="card-inner">
                                        <div class="card-title-group align-start mb-2">
                                            <div class="card-title">
                                                <h6 class="title">Unverified Payments</h6>
                                            </div>
                                            <div class="card-tools"><em class="card-hint icon ni ni-coins"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    aria-label="Unverified Payments"
                                                    data-bs-original-title="Unverified Payments"></em></div>
                                        </div>
                                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                            <div class="nk-sale-data"><span class="amount"><?= shortenNumber(paymentCount($conn), 2) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="card card-bordered">
                                    <div class="card-inner">
                                        <div class="card-title-group align-start mb-2">
                                            <div class="card-title">
                                                <h6 class="title">Invoice Payments</h6>
                                            </div>
                                            <div class="card-tools"><em class="card-hint icon ni ni-reports"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    aria-label="Invoice Payments"
                                                    data-bs-original-title="Invoice Payments"></em></div>
                                        </div>
                                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                            <div class="nk-sale-data"><span class="amount"><?= shortenNumber(paidInvoicesCount($conn), 2) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="card card-bordered">
                                    <div class="card-inner">
                                        <div class="card-title-group align-start mb-2">
                                            <div class="card-title">
                                                <h6 class="title">Unverified Deposits</h6>
                                            </div>
                                            <div class="card-tools"><em class="card-hint icon ni ni-wallet-in"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    aria-label="Unverified Deposits"
                                                    data-bs-original-title="Unverified Deposits"></em></div>
                                        </div>
                                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                            <div class="nk-sale-data"><span class="amount"><?= shortenNumber(depositsCount($conn), 2) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="card card-bordered">
                                    <div class="card-inner">
                                        <div class="card-title-group align-start mb-2">
                                            <div class="card-title">
                                                <h6 class="title">Total Transactions</h6>
                                            </div>
                                            <div class="card-tools"><em class="card-hint icon ni ni-tranx"
                                                    data-bs-toggle="tooltip" data-bs-placement="left"
                                                    aria-label="Total Transactions"
                                                    data-bs-original-title="Total Transactions"></em></div>
                                        </div>
                                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                            <div class="nk-sale-data"><span class="amount"><?= shortenNumber(transactionsCount($conn), 2) ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                           
                            <div class="col-12">
                                <div class="card card-bordered card-full">
                                    <div class="card-inner">
                                        <div class="card-title-group">
                                            <div class="card-title">
                                                <h6 class="title"><span class="me-2">Recent Transactions</span></h6>
                                            </div>
                                            <div class="card-tools">
                                                <ul class="card-tools-nav">
                                                    <li><a href="transactions" class="link d-none d-sm-inline">See All</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-inner p-0 border-top">
                                        <div class="nk-tb-list nk-tb-orders">
                                            <div class="nk-tb-item nk-tb-head">
                                                <div class="nk-tb-col"><span>Reference</span></div>
                                                <div class="nk-tb-col tb-col-sm"><span>Customer</span></div>
                                                <div class="nk-tb-col tb-col-md"><span>Date</span></div>
                                                <div class="nk-tb-col tb-col-lg"><span>User Type</span></div>
                                                <div class="nk-tb-col"><span>Amount</span></div>
                                                <div class="nk-tb-col"><span class="d-none d-sm-inline">Status</span>
                                                </div>
                                            </div>

                                            <?php
                                            
                                                // Get All Transactions

                                                $foundTransc = false; // Flag 

                                                $transactions = mysqli_prepare($conn, "SELECT `A`.*, COALESCE(`B`.`fname`, `C`.`fname`) AS `fname`, COALESCE(`B`.`mname`, `C`.`mname`) AS `mname`, COALESCE(`B`.`lname`, `C`.`lname`) AS `lname`, CASE WHEN `B`.`user_id` IS NOT NULL THEN 'USER' WHEN `C`.`tp_id` IS NOT NULL THEN 'THIRD PARTY' ELSE 'UNKNOWN' END AS `user_type` FROM `transactions` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` LEFT JOIN `third_party` AS `C` ON `A`.`user_id` = `C`.`tp_id` ORDER BY `A`.`date` DESC LIMIT 5"); // Prepare Statement

                                                mysqli_stmt_execute($transactions); // Execute Statement

                                                $resultTrans = mysqli_stmt_get_result($transactions); // Get Statement Result

                                                if (mysqli_num_rows($resultTrans) > 0) { // Compare Result Mass

                                                    $foundTransc = true; // Update Flag

                                                    $data = mysqli_fetch_all($resultTrans, MYSQLI_ASSOC);

                                                }

                                                mysqli_free_result($resultTrans); // Free Result

                                                mysqli_stmt_close($transactions); // Close Statement

                                                $i = 0;

                                                if ($foundTransc) {

                                                    foreach ($data as $row):

                                                        $i++;

                                                        $userClass = $row['user_type'];

                                                        $amount = $row['amount'];

                                                        $status = $row['status'];

                                                        $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                                        $desc = $row['descr'];

                                                        $currency = $row['currency'];

                                                        $symbol = $currSymbol[$currency];

                                                        $date = $row['date'];

                                                        $type = $row['type'];

                                                        $scope = $row['action'];

                                                        $account = $row['acc_num'];

                                                        $id = $row['trans_id'];

                                                        $user = $row['user_id'];

                                                        if ($type == "DEBIT") {

                                                            $icon = "wallet-out";
                                                            $color = "text-danger";
                                                            $sign = "-";

                                                        } else {
                                                            $icon = "wallet-in";
                                                            $color = "text-success";
                                                            $sign = "+";
                                                        }
                                                            if ($status == 'COMPLETED') {

                                                                $status = '<span class="text-success">' . $status . '</span>';

                                                            } else if ($status == 'PROCESSING') {

                                                                $status = '<span class="text-warning">PENDING</span>';

                                                            } else {
                                                                
                                                                $status = '<span class="text-danger">' . $status . '</span>';
                                                            
                                                            }

                                                    ?>

                                                    <div class="nk-tb-item">
                                                        <div class="nk-tb-col">
                                                            <span class="tb-lead"><?= $id ?></span>
                                                            <span class="tb-sub"><?= 'Account: ' . $account ?></span>
                                                        </div>
                                                        <div class="nk-tb-col tb-col-sm">
                                                            <span class="tb-lead"><?= $name ?></span>
                                                            <span class="tb-sub"><?=  join(': ', [$userClass, $user]) ?></span>
                                                        </div>
                                                        <div class="nk-tb-col tb-col-md"><span class="tb-sub"><?= date('d/M/Y', strtotime($date)) ?></span>
                                                        </div>
                                                        <div class="nk-tb-col tb-col-lg"><span
                                                                class="tb-sub text-primary"><?= $userClass ?></span></div>
                                                        <div class="nk-tb-col"><span class="tb-sub tb-amount"><?= $symbol . number_format($amount, 2) . $currency ?></span></div>
                                                        <div class="nk-tb-col"><?= $status ?></span>
                                                        </div>
                                                    </div>

                                                    <?php endforeach;

                                                } else { ?>

                                                    <div class="nk-tb-item w-100">
                                                        <div class="nk-tb-col text-center w-100">
                                                            <p class="w-100">No Recent Transactions!</p>
                                                        </div>
                                                    </div>

                                                <?php }    

                                            ?>

                                        </div>
                                    </div>
                                    <div class="card-inner-sm border-top text-center d-sm-none"><a href="#"
                                            class="btn btn-link btn-block">See History</a></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="card card-bordered card-full">
                                    <div class="card-inner border-bottom">
                                        <div class="card-title-group">
                                            <div class="card-title">
                                                <h6 class="title">Recent Deposits</h6>
                                            </div>
                                            <div class="card-tools">
                                                <ul class="card-tools-nav">
                                                    <li><a href="deposits"><span>See All</span></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="nk-activity is-scrollable h-325px">
                                        <?php
                                        
                                            $found = false; // Flag
                                        
                                            $stmt = mysqli_prepare($conn, "SELECT `A`.*, COALESCE(`B`.`fname`, `C`.`fname`) AS `fname`, COALESCE(`B`.`mname`, `C`.`mname`) AS `mname`, COALESCE(`B`.`lname`, `C`.`lname`) AS `lname`, CASE WHEN `B`.`user_id` IS NOT NULL THEN 'USER' WHEN `C`.`tp_id` IS NOT NULL THEN 'THIRD PARTY' ELSE 'UNKNOWN' END AS `user_type` FROM `deposits` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` LEFT JOIN `third_party` AS `C` ON `A`.`user_id` = `C`.`tp_id` ORDER BY `A`.`dep_time` DESC LIMIT 5");

                                            mysqli_stmt_execute($stmt);

                                            $result = mysqli_stmt_get_result($stmt);

                                            if (mysqli_num_rows($result) > 0) {

                                                $found = true; // Update Flag

                                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                            }

                                            mysqli_free_result($result);

                                            mysqli_stmt_close($stmt);

                                            if ($found) {

                                                foreach ($data as $row):

                                                    $userClass = $row['user_type'];

                                                    $datetime = $row['dep_time'];

                                                    $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                                    $method = $row['dep_channel'];

                                                    $amount = $row['amount'];

                                                    $currency = $row['currency'];

                                                    $account = $row['account'];

                                                    $accId = $row['acc_id'];

                                                    $related = $row['related_transc'];

                                                    $cryptoCoin = $row['dep_asset'];

                                                    $resourceId = $row['identifier'];

                                                    $destination = $row['channel_attr'];

                                                    $owner = $row['vendor'];

                                                    $proof = SITE_BASE_URL . '/' . htmlspecialchars(str_replace('../',  '', $row['dep_proof']));

                                                    $status = $row['dep_status'];

                                                    $depId = $row['dep_id'];

                                                    $user = $row['user_id'];?>

                                                    <li class="nk-activity-item"><a href="deposit-details?id=<?= $depId ?>">
                                                        <div class="nk-activity-data">
                                                            <div class="label"><?= $name .  ' (' . $userClass . ') made a deposit of ' . number_format($amount, 2) . ' ' . $currency ?>.</div><span
                                                                class="time"><?= readableDateDiff($datetime, null, false) ?></span>
                                                        </div></a>
                                                    </li>

                                                <?php endforeach;

                                            } else { ?>

                                                <li class="nk-activity-item">
                                                    <div class="nk-activity-data">
                                                        <div class="label">No recent deposits</div>
                                                    </div>
                                                </li>

                                          <?php  }
                                        
                                        ?>
    
                                    </ul>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="card card-bordered h-100">
                                    <div class="card-inner border-bottom">
                                        <div class="card-title-group">
                                            <div class="card-title">
                                                <h6 class="title">Support Tickets</h6>
                                            </div>
                                            <div class="card-tools"><a href="support-tickets" class="link">All Tickets</a></div>
                                        </div>
                                    </div>
                                    <ul class="nk-support">

                                        <?php

                                            $tickets = false; // Flag
                                        
                                            $stmt = mysqli_prepare($conn, "SELECT 
  A.*, 
  B.created_at AS message_time, 
  B.message_text AS last_message, 
  B.sender AS party, 
  COALESCE(C.email, D.email) AS email, 
  COALESCE(C.fname, D.fname) AS fname, 
  COALESCE(C.mname, D.mname) AS mname, 
  COALESCE(C.lname, D.lname) AS lname, 
  CASE 
    WHEN C.user_id IS NOT NULL THEN 'USER' 
    WHEN D.tp_id IS NOT NULL THEN 'THIRD PARTY' 
    ELSE 'UNKNOWN' 
  END AS user_type 
FROM support_tickets AS A 
LEFT JOIN (
  SELECT ticket_id, created_at, message_text, sender
  FROM (
    SELECT
      ticket_id,
      created_at,
      message_text,
      sender,
      ROW_NUMBER() OVER (PARTITION BY ticket_id ORDER BY created_at DESC) AS rn
    FROM messages
  ) t
  WHERE rn = 1
) AS B ON A.ticket_id = B.ticket_id 
LEFT JOIN users AS C ON A.user_id = C.user_id 
LEFT JOIN third_party AS D ON A.user_id = D.tp_id 
ORDER BY B.created_at DESC 
LIMIT 5");

                                            mysqli_stmt_execute($stmt);

                                            $result = mysqli_stmt_get_result($stmt);

                                            if (mysqli_num_rows($result) > 0) {

                                                $tickets = true; // Update Flag

                                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                            }

                                            mysqli_free_result($result);

                                            mysqli_stmt_close($stmt);

                                            // Check Flag

                                            if ($tickets) {

                                                foreach ($data as $row):

                                                    $id = $row['ticket_id'];

                                                    $name = join(' ', [$row['fname'], $row['lname']]);

                                                    $msg = $row['title'];

                                                    if (strlen($msg) > 30) {

                                                        $msg = substr($msg, 0, 30) . '...';

                                                    }

                                                    $date = $row['created_at'];

                                                    $status = $row['status']; ?>

                                                    <a href="chat-conversation?id=<?= $id ?>"><li class="nk-support-item">
                                                        
                                                        <div class="user-avatar bg-purple-dim"><span>DM</span></div>
                                                        <div class="nk-support-content">
                                                            <div class="title"><span><?= $name ?></span><span
                                                                    class="badge"><?= $status ?></span>
                                                            </div>
                                                            <p><?= $msg ?></p><span class="time"><?= $date ?></span>
                                                        </div>
                                                        
                                                    </li></a>

                                                <?php endforeach;

                                            } else { ?>

                                                <li class="nk-support-item">
                                                    <div class="user-avatar"><i class=""></i>
                                                    </div>
                                                    <div class="nk-support-content">
                                                        <div class="title"><span>No Support Tickets Found</span>
                                                        </div>
                                                        <p>You'll see recent tickets here!</p>
                                                    </div>
                                                </li>

                                            <?php }
                                        
                                        ?>
                                        
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

    require('utility/partials/footer.php')

?>