<?php 

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Unverified Deposits.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="fund-user" class="btn btn-success"><span>Fund an account</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
                 
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">#</span></th>

                        <th class="nk-tb-col"><span class="sub-text">Ref Number</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Initiator</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Amount</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Account Info</span></th>

                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Related Transaction</span></th>

                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col nk-tb-col-tools"><span class="sub-text"></span></th>

                    </tr>
                </thead>
                <tbody>

                    <?php
                        
                        // Get Payments

                        $paymentFound = false; // Payment Detection Flag

                        $payments = mysqli_prepare($conn, "SELECT `A`.*, COALESCE(`B`.`fname`, `C`.`fname`) AS `fname`, COALESCE(`B`.`mname`, `C`.`mname`) AS `mname`, COALESCE(`B`.`lname`, `C`.`lname`) AS `lname`, CASE WHEN `B`.`user_id` IS NOT NULL THEN 'USER' WHEN `C`.`tp_id` IS NOT NULL THEN 'THIRD PARTY' ELSE 'UNKNOWN' END AS `user_type` FROM `deposits` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` LEFT JOIN `third_party` AS `C` ON `A`.`user_id` = `C`.`tp_id` ORDER BY `A`.`dep_time` DESC"); // Prepare Statement

                        mysqli_stmt_execute($payments); // Execute Statement

                        $result = mysqli_stmt_get_result($payments); // Get Statement Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                            $paymentFound = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($payments); // Close Statement

                        // Check Flag

                        if ($paymentFound) {

                            // Iterate Through Data

                            $i = 0;

                            foreach ($data as $row):

                                $i++;

                                $userClass = $row['user_type'];

                                $datetime = $row['dep_time'];

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $method = $row['dep_channel'];

                                $amount = $row['amount'];

                                $currency = $row['currency'];

                                $account = $row['account'];

                                $accId = $row['acc_id'];

                                $related = $row['related_transc'];

                                $cryptoCoin = $row['dep_asset'];

                                $resourceId = $row['identifier'];

                                $destination = $row['channel_attr'];

                                $owner = $row['vendor'];

                                $proof = SITE_BASE_URL . '/' . htmlspecialchars(str_replace('../',  '', $row['dep_proof']));

                                $status = $row['dep_status'];

                                $depId = $row['dep_id'];

                                $user = $row['user_id'];

                            ?>
                            
                            <tr class="nk-tb-item">
                                
                                <td class="nk-tb-col tb-col-mb">
                                    <span class="tb-amount">
                                        <?= $i ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $depId ?><span class="dot dot-success d-md-none ml-1"></span>
                                            </span>
                                            <span>
                                                <?= date('l d M, Y [h:i a]', strtotime($datetime)) ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-lg" data-order="35040.34">
                                    <span class="tb-amount">
                                        <?= $name . ' (' . $userClass . ')' ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?=  $currSymbol[$currency] .  number_format($amount, 2) . $currency ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-md">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $account . $currency ?>
                                            </span>
                                            <span>
                                                <?= $accId ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>

                                <td class="nk-tb-col tb-col-lg">
                                    <span>
                                        <?= $related ?>
                                    </span>
                                </td>

                                <td class="nk-tb-col tb-col-md">
                                    <?= $status ?>
                                </td>
                                <td class="nk-tb-col nk-tb-col-tools text-right">
                                    <form method="post" class="deposit_form">
                                        <input type="hidden" name="dep-id" value="<?= $depId ?>">
                                        <ul class="nk-tb-actions gx-1">
                                            <li class="nk-tb-action-hidden">
                                                <a data-toggle="modal" data-target="#proofView" data-proof="<?= $proof ?>"
                                                    class="btn btn-trigger btn-icon proof-view" data-toggle="tooltip" data-placement="top"
                                                    title="View Proof">
                                                    <em class="icon ni ni-focus text-warning"></em>
                                                </a>
                                            </li>
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="approve" value="APPROVE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Approve Deposit">
                                                    <em class="icon ni ni-check text-success"></em>
                                                </button>
                                            </li>
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="decline" value="DECLINE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Decline Deposit">
                                                    <em class="icon ni ni-na text-danger"></em>
                                                </button>
                                            </li>
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="delete" value="DELETE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Delete Record">
                                                    <em class="icon ni ni-trash text-danger"></em>
                                                </button>
                                            </li>
                                            <li>
                                                <div class="dropdown">
                                                    <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                        data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <ul class="link-list-opt no-bdr">
                                                            <li><a
                                                                    href="deposit-details?id=<?= $depId ?>"><em
                                                                        class="icon ni ni-eye"></em><span>View Details</span></a>
                                                            </li>


                                                        </ul>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </form>
                                </td>
                            </tr>

                            <?php endforeach;

                        }
                    
                    ?>
                                
                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->

    <!-- Proof Display Modal -->

    <div class="modal fade" tabindex="-1" id="proofView">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <a href="#" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </a>
                <div class="modal-header text-white" style="background-color:#033d75; color: white;">
                    <h5 class="modal-title">Deposit Proof</h5>
                </div>
                <div class="modal-body" id="proofDock">
                    <img src="<?= SITE_LOGO ?>" width="100%" load="lazy">
                </div>
                <div class="modal-footer">
                    <button class="btn btn-danger btn-sm" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

</div>

<?php 

    require('utility/partials/footer.php');

?>