<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $codeData = bcodeData($id, $conn); // Fetch Code Data

        if (!$codeData) {

            echo '<script>
        
                alert("An an error occurred!");

                window.history.go(-1);

            </script>';

            exit;

        }
    

    } else {

        echo '<script>

            alert("An error occurred!");

            window.history.go(-1);

        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit Billing Code</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-lock-fill"></em> Edit  <?= $codeData['PIN-name'] ? $codeData['PIN-name'] : '' ?></h5>
        </div>
        <form id="editCodeForm" method="post">
            <div class="card-body">
                <b>Billing Code Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-pin">Code</label>
                            <input type="text" class="form-control" id="code-pin" name="code-pin"
                                placeholder="****" minlength="6" value="<?= isset($codeData['PIN']) ? $codeData['PIN'] : '' ?>" required>
                                <input type="hidden" class="form-control" id="code-id" name="code-id"
                                value="<?= isset($id) ? $id : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-name">Code Name</label>
                            <input type="text" class="form-control" id="code-name" name="code-name"
                                placeholder="e.g Transfer Authorization Code" value="<?= isset($codeData['PIN-name']) ? $codeData['PIN-name'] : '' ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-abbr">Code Abbreviation</label>
                            <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                                placeholder="e.g TAC" required value="<?= isset($codeData['PIN-abbr']) ? $codeData['PIN-abbr'] : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-pay">Payment Method</label>
                            <select type="text" class="form-control" id="code-pay" name="code-pay">

                                <option value="AUTOMATIC"<?= isset($codeData['PIN-payment']) && $codeData['PIN-payment'] == 'AUTOMATIC' ? ' selected' : '' ?>>Automatic</option>

                                <option value="MANUAL"<?= isset($codeData['PIN-payment']) && $codeData['PIN-payment'] == 'MANUAL' ? ' selected' : '' ?>>Manual</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-type">Code Type</label>
                            <select type="text" class="form-control" id="code-type" name="code-type">

                                <option value="PERCENTAGE"<?= isset($codeData['PIN-type']) && $codeData['PIN-type'] === 'PERCENTAGE' ? ' selected' : '' ?>>Percentage</option>

                                <option value="FIXED AMOUNT"<?= isset($codeData['PIN-type']) && $codeData['PIN-type'] === 'FIXED AMOUNT' ? ' selected' : '' ?>>Fixed Amount</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-percent">Code Percentage (%)</label>
                            <input type="number" class="form-control" id="code-percent" name="code-percent" min="0.01" step="0.01"
                                placeholder="(Min 0.01%) Required for Percentage Code Type" value="<?= isset($codeData['PIN-percent']) ? $codeData['PIN-percent'] : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-amount">Code Amount (USD)</label>
                            <input type="number" class="form-control" id="code-amount" name="code-amount" min="0.01" step="0.01"
                                placeholder="Required for Fixed amount Code Type" value="<?= isset($codeData['PIN-amount']) ? $codeData['PIN-amount'] : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="code-directive">Code Directive</label>
                            <input type="text" class="form-control" id="code-directive" name="code-directive"
                                placeholder="e.g Enter Transfer Code (TAC)" value="<?= isset($codeData['PIN-directive']) ? $codeData['PIN-directive'] : '' ?>">
                        </div>
                    </div>
                    
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="form-label" for="code-error">Error Code</label>
                            <input type="text" class="form-control" id="code-error" name="code-error"
                                placeholder="Error Code" value="<?= isset($codeData['PIN-error']) ? $codeData['PIN-error'] : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="code-desc">Short Description</label>
                            <textarea class="form-control" id="code-desc" name="code-desc" placeholder="A paragraph describing the code" required><?= isset($codeData['PIN-descr']) ? $codeData['PIN-descr'] : '' ?></textarea>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="code-msg">Code Message</label>
                            <textarea class="form-control" id="code-msg" name="code-msg" placeholder="Full code description. Separate paragraphs with ,," required><?= isset($codeData['PIN-msg']) ? $codeData['PIN-msg'] : '' ?></textarea>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-status">Code Status</label>
                            <select class="form-control" id="code-status" name="code-status">

                                <option value="PAID"<?= isset($codeData['PIN-status']) && $codeData['PIN-status'] === 'PAID' ? ' selected' : '' ?>>PAID</option>

                                <option value="UNPAID"<?= isset($codeData['PIN-status']) && $codeData['PIN-status'] === 'UNPAID' ? ' selected' : '' ?>>UNPAID</option>

                            </select>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary" id="editCodeBtn">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>