<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Get Subscription Payout Schedule

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `repayments_schedule` WHERE `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s) 

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $due = $row['due'];

                $amount = $row['amount'];

                $status = $row['status'];
 
            }


        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "Payout schedule not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit Payout</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>


    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-sign-dollar"></em> Edit Payout Data</h5>
        </div>
        <form id="edit-rpym-form" method="post">
            <div class="card-body">
                <b>Payout Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="amount">Amount</label>
                            <input type="number" class="form-control" name="amount" step="0.01" min="0.01" value="<?= $amount ?>" required>
                            <input type="hidden" class="form-control" name="rpym-id" value="<?= $id ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="due">Payout Date</label>
                            <input type="date" class="form-control" name="due" value="<?= $due ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="status">Status</label>
                            <select class="form-control" name="status">

                                <option value="PENDING"<?= $status == 'PENDING' ? ' selected' : null ?>>PENDING</option>

                                <option value="PAID"<?= $status == 'PAID' ? ' selected' : null ?>>PAID</option>

                                <option value="OVERDUE"<?= $status == 'OVERDUE' ? ' selected' : null ?>>OVERDUE</option>

                            </select>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="edit-rpym" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>