<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accounts = userAccounts($id, $conn); // Fetch User Accounts

        if (!$accounts) {

            echo '<script>
        
                swal({
                
                    title: "Error!",

                    text: "Couldn\'t find any account!",

                    icon: "error"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }
    

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid URL Parameter",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

    // Form Processor 

    if (isset($_REQUEST['generate-trans'])) {

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $from = sanitizeDateTime($_REQUEST['start']);

        $to = sanitizeDateTime($_REQUEST['ends']);

        $vol = filter_var($_REQUEST['transc'], FILTER_SANITIZE_NUMBER_INT);

        $accounts = []; // Holds Account Information 
        
        $userAccounts = userAccounts($id, $conn); // Get User Accounts

        if (!$userAccounts) {

            echo '<script>
        
                swal({
                
                    title: "Error!",

                    text: "Couldn\'t find any account!",

                    icon: "error"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

        foreach ($userAccounts as $account):

            $currency = strtoupper($account['currency']); // ensure uppercase for consistency

            $accounts[$currency] = [
                'acc_id' => $account['acc_id'],      // note: underscore for keys to match your previous usage
                'acc_num' => $account['acc_num']  // consistent naming acc_num instead of acc-number
            ];

        endforeach;

        function fetchRandomUsers($count) { // Generate Random User Name
            $url = "https://randomuser.me/api/?results={$count}&nat=us,gb,ca,au";

            $response = file_get_contents($url);
            if (!$response) {
                return [];
            }

            $data = json_decode($response, true);
            if (!isset($data['results'])) {
                return [];
            }

            $names = [];
            foreach ($data['results'] as $user) {
                $first = $user['name']['first'];
                $last = $user['name']['last'];
                $names[] = "{$first} {$last}";
            }
            return $names;
        }

        function generateRandomTransactionDataBatch($conn,
            $userId, 
            $numTransactions, 
            $startDate, 
            $endDate, 
            $currenciesWithAccounts, 
            $recipientNames = []
        ) { // Random Transactions
            $transactions = [];

            if (count($currenciesWithAccounts) < 1) {
                throw new Exception("At least one currency must be provided.");
            }

            $statuses = ['PENDING','INCOMPLETE','COMPLETED','DISPUTED'];

            $currencyCodes = array_keys($currenciesWithAccounts);

            $descriptions = [
                'DEPOSIT' => ['Direct Deposit ({currency}) via Bank Transfer'],
                'ROI' => ['ROI Payment ({currency}) via Bank Transfer'],
                'LOAN' => ['Loan Disbursement ({currency})'],
                'TAG TRANSFER' => ['Tagged Account Transfer ({currency})'],
                'MISCELLANOUS' => ['Miscellaneous Adjustment ({currency})'],
                'WITHDRAWAL' => ['Withdrawal ({currency}) via Bank Transfer'],
                'SERVICE FEE' => ['Service Fee ({currency})'],
                'CROSS-BORDER TRANSFER' => ['International Transfer ({currency}) via Bank Transfer'],
                'LOCAL TRANSFER' => ['Local Bank Transfer ({currency})'],
                'SWAP' => ['Currency Swap from {from_currency} to {to_currency}']
            ];

            $bankingCodeTypes = [
                'SWIFT CODE', 'ROUTING NUMBER', 'IBAN', 'ABA NUMBER',
                'SORT CODE', 'CLABE', 'IFSC', 'BSB', 'RTN', 'NSC'
            ];

            $fixedTypeActions = [
                'CREDIT' => ['DEPOSIT', 'ROI'],
                'DEBIT' => ['WITHDRAWAL', 'SERVICE FEE', 'CROSS-BORDER TRANSFER', 'LOCAL TRANSFER']
            ];
            $eitherTypeActions = ['LOAN', 'TAG TRANSFER', 'MISCELLANOUS'];

            $startTimestamp = is_string($startDate) ? strtotime($startDate) : $startDate;
            $endTimestamp = is_string($endDate) ? strtotime($endDate) : $endDate;

            $allowSwap = count($currencyCodes) >= 2;
            $actions = array_merge(
                $fixedTypeActions['CREDIT'],
                $fixedTypeActions['DEBIT'],
                $eitherTypeActions,
                $allowSwap ? ['SWAP'] : []
            );

            for ($i = 0; $i < $numTransactions; $i++) {
                $status = $statuses[array_rand($statuses)];
                $action = $actions[array_rand($actions)];

                if (in_array($action, $fixedTypeActions['CREDIT'])) {
                    $type = 'CREDIT';
                } elseif (in_array($action, $fixedTypeActions['DEBIT'])) {
                    $type = 'DEBIT';
                } elseif ($action === 'SWAP') {
                    $fromCurrency = $currencyCodes[array_rand($currencyCodes)];
                    do {
                        $toCurrency = $currencyCodes[array_rand($currencyCodes)];
                    } while ($toCurrency === $fromCurrency);

                    $amount = rand(1000, 500000) / 100;

                    $date = date('Y-m-d H:i:s', rand($startTimestamp, $endTimestamp));

                    $desc = str_replace(['{from_currency}', '{to_currency}'], [$fromCurrency, $toCurrency], $descriptions['SWAP'][0]);

                    $commonData = [
                        'user_id' => $userId,
                        'date' => $date,
                        'action' => 'SWAP',
                        'descr' => $desc,
                        'acc_id' => $currenciesWithAccounts[$fromCurrency]['acc_id'],
                        'acc_num' => $currenciesWithAccounts[$fromCurrency]['acc_num'],
                        'acc_bal' => rand(100000, 10000000) / 100,
                        'amount' => $amount,
                        'recpt_acc' => 'RECPT' . rand(1000, 9999),
                        'recpt_name' => $recipientNames ? $recipientNames[array_rand($recipientNames)] : null,
                        'recpt_bank' => 'Bank of Example',
                        'banking_codetype' => null,
                        'banking_code' => null,
                        'status' => $status,
                    ];

                    $transactions[] = array_merge($commonData, [
                        'trans_id' => generateUniqueID($conn, 'transactions', 'TRN'),
                        'type' => 'DEBIT',
                        'currency' => $fromCurrency
                    ]);

                    $commonData['acc_id'] = $currenciesWithAccounts[$toCurrency]['acc_id'];
                    $commonData['acc_num'] = $currenciesWithAccounts[$toCurrency]['acc_num'];

                    $transactions[] = array_merge($commonData, [
                        'trans_id' => generateUniqueID($conn, 'transactions', 'TRN'),
                        'type' => 'CREDIT',
                        'currency' => $toCurrency
                    ]);

                    continue;
                } else {
                    $type = (rand(0, 1) === 0) ? 'CREDIT' : 'DEBIT';
                }

                $currency = $currencyCodes[array_rand($currencyCodes)];
                $amount = rand(1000, 500000) / 100;
                $date = date('Y-m-d H:i:s', rand($startTimestamp, $endTimestamp));

                $bankingCodeType = null;
                $bankingCode = null;
                if ($action === 'CROSS-BORDER TRANSFER') {
                    $bankingCodeType = $bankingCodeTypes[array_rand($bankingCodeTypes)];
                    $bankingCode = strtoupper(substr($bankingCodeType, 0, 4)) . rand(1000, 9999);
                }

                $descTemplate = $descriptions[$action][0];
                $desc = str_replace('{currency}', $currency, $descTemplate);

                $transID = generateUniqueID($conn, 'transactions', 'TRN');

                $transactions[] = [
                    'trans_id' => $transID,
                    'user_id' => $userId,
                    'date' => $date,
                    'type' => $type,
                    'action' => $action,
                    'descr' => $desc,
                    'currency' => $currency,
                    'acc_id' => $currenciesWithAccounts[$currency]['acc_id'],
                    'acc_num' => $currenciesWithAccounts[$currency]['acc_num'],
                    'acc_bal' => rand(100000, 10000000) / 100,
                    'amount' => $amount,
                    'recpt_acc' => 'RECPT' . rand(1000, 9999),
                    'recpt_name' => $recipientNames ? $recipientNames[array_rand($recipientNames)] : null,
                    'recpt_bank' => 'Bank of Example',
                    'banking_codetype' => $bankingCodeType,
                    'banking_code' => $bankingCode,
                    'status' => $status,
                    'uetr' => ($action === 'CROSS-BORDER TRANSFER') ? uetrConvert($transID) : null
                ];
            }

            return $transactions;
        }

        // Fetch recipient names (you can adjust count as needed)
        $recipientNames = fetchRandomUsers($vol);

        // Generate transactions
        $transactions = generateRandomTransactionDataBatch(
            $conn,
            $user, 
            $vol, 
            $from, 
            $to, 
            $accounts, 
            $recipientNames
        );

        $count = 0;

        foreach ($transactions as $tx) {

            $query = "INSERT INTO transactions (
                `trans_id`, `user_id`, `date`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`,
                `recpt_acc`, `recpt_name`, `recpt_bank`, `banking_codetype`, `banking_code`, `status`, `uetr`
            ) VALUES (
                '" . $conn->real_escape_string($tx['trans_id']) . "',
                '" . $conn->real_escape_string($tx['user_id']) . "',
                '" . $conn->real_escape_string($tx['date']) . "',
                '" . $conn->real_escape_string($tx['type']) . "',
                '" . $conn->real_escape_string($tx['action']) . "',
                '" . $conn->real_escape_string($tx['descr']) . "',
                '" . $conn->real_escape_string($tx['currency']) . "',
                '" . $conn->real_escape_string($tx['acc_id']) . "',
                '" . $conn->real_escape_string($tx['acc_num']) . "',
                " . floatval($tx['acc_bal']) . ",
                " . floatval($tx['amount']) . ",
                " . (isset($tx['recpt_acc']) ? "'" . $conn->real_escape_string($tx['recpt_acc']) . "'" : "NULL") . ",
                " . (isset($tx['recpt_name']) ? "'" . $conn->real_escape_string($tx['recpt_name']) . "'" : "NULL") . ",
                " . (isset($tx['recpt_bank']) ? "'" . $conn->real_escape_string($tx['recpt_bank']) . "'" : "NULL") . ",
                " . (isset($tx['banking_codetype']) ? "'" . $conn->real_escape_string($tx['banking_codetype']) . "'" : "NULL") . ",
                " . (isset($tx['banking_code']) ? "'" . $conn->real_escape_string($tx['banking_code']) . "'" : "NULL") . ",
                '" . $conn->real_escape_string($tx['status']) . "',
                " . (isset($tx['uetr']) ? "'" . $conn->real_escape_string($tx['uetr']) . "'" : "NULL") . "
            )";

            if (mysqli_query($conn, $query)) {

                $count++;

            }

        }

        if ($count > 0) {

            echo '<script>
        
                swal({
                
                    title: "Transactions Generated!",

                    text: "' . $count . '/' . $vol . ' transactions created!",

                    icon: "success"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        } else {

            echo '<script>
        
                swal({
                
                    title: "Error!",

                    text: "Couldn\'t generate any transactions!",

                    icon: "error"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

    }

?>

<div class="nk-content">

    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Generate transactions.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="user-transactions?id=<?= $id ?>" class="btn btn-warning"><span>View Transactions</span> <em
                                        class="icon ni ni-tranx"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-setting"></em> Generate Transactions</h5>
        </div>
        <form id="transc-generator" method="post">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc">No. of Transactions</label>
                            <input type="number" min="1" class="form-control" name="transc" required>
                            <input type="hidden" class="form-control" name="user-id" value="<?= $id ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="start">From</label>
                            <input type="datetime-local" class="form-control" name="start" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="ends">To</label>
                            <input type="datetime-local" class="form-control" name="ends" required>
                        </div>
                    </div>

                </div>
                
            </div>
            <div class="card-footer">
                <button id="generateTrans" name="generate-trans" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

    require('utility/partials/footer.php');

?>