<?php

    require('utility/partials/header.php');
    
   // Look for Timing Factors

   $factors = false; // Flag

   $stmt = mysqli_prepare($conn, "SELECT * FROM `timing_factors` ORDER BY `hours`"); // Prepare Statement

    mysqli_stmt_execute($stmt); // Execute Statement

    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

    if (mysqli_num_rows($result) > 0) {

        $factors = mysqli_fetch_all($result, MYSQLI_ASSOC); // Update Flag

    }

    mysqli_free_result($result); // Free Result

    mysqli_stmt_close($stmt); // Close Statement

    if (!$factors) {

        echo '<script>
        
            swal({

                icon: "warning",

                title: "Important!",

                text: "Please set up timing factors!"
            
            }).then(() => {
            
                window.location.href = "timing";
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Investment Plans</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="timing" class="btn btn-secondary"><span>Timing Factors</span> <em
                                        class="icon ni ni-clock"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Available Investment Plans</h4>
                <div class="nk-block-des">
                    <p>Below is the list of Investment Plans</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Plan ID</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Name</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Type / Risk</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Duration</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">ROI</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Price</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $planFound = false; // Flag

                            // Fetch All Plans
                        
                            $stmt = mysqli_prepare($conn, "SELECT * FROM `investments` ORDER BY `id` DESC"); // Prepare Statement

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $planFound = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($planFound) {

                                $i = 0; // Counter

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $planId = $row['inv_id'];

                                    $image = $row['image'];

                                    $name = $row['name'];

                                    $category = $row['category'];

                                    $min = $row['min_amount'];

                                    $max = $row['max_amount'];

                                    $duration = $row['duration'] . ' days';

                                    $rate = $row['interest_rate'] . '%';

                                    $return = $row['return_type'];

                                    $frequency = $row['frequency'];

                                    $risk = $row['risk_factor'];

                                ?>    

                                    <tr class="nk-tb-item">
                                        
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $planId ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $name ?>
                                                    </span>
                                                    <span>
                                                        <?= $duration ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead">
                                                <?= $category ?>
                                            </span>
                                            <span><?= $risk ?></span>
                                        </td>
                                    
                                        <td class="nk-tb-col tb-col-lg" data-order="">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $duration ?>
                                                </span>
                                                <span>
                                                    <?= $frequency ?>
                                                </span>
                                            </div>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg">
                                            <span>
                                                <?= $return ?>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= ($min != null) ? '$' . number_format($min, 2) . ' - ' : null ?><?= '$' . number_format($max, 2) . ' (USD)' ?></span>
                                        </td>
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form method="post" class="investment-mgmt-form">
                                                <input type="hidden" name="plan-id" value="<?= $planId ?>">
                                                <input type="hidden" name="old-image" value="<?= $image ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete Plan">
                                                            <em class="icon ni ni-trash text-danger"></em>
                                                        </button>
                                                    </li>


                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <!-- <li class="divider"></li> -->
                                                                    <li><a href="edit-investment?id=<?= $planId ?>"><em
                                                                                class="icon ni ni-edit"></em><span>Edit Plan</span></a></li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>    
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-invest"></em> Add Investment Plan</h5>
        </div>
        <form id="planForm" method="post" enctype="multipart/form-data" autocomplete="off">
            <div class="card-body">
                <b>Plan Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-name">Plan Name</label>
                            <input type="text" class="form-control" id="plan-name" name="plan-name"
                                placeholder="Plan Name (E.g BTC/ETH)" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-category">Plan Category</label>
                            <select class="form-control" id="plan-category" name="plan-category">

                                <option value="0">Select Plan Category</option>

                                <option value="CRYPTO">CRYPTO</option>

                                <option value="STOCKS">STOCKS</option>

                                <option value="FOREX">FX</option>

                                <option value="COMMODITY">COMMODITY</option>

                                <option value="REALTY">REAL ESTATE</option>

                                <option value="OPTIONS">OPTIONS</option>

                                <option value="BONDS">BONDS</option>

                                <option value="OTHERS">OTHERS</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-return">ROI Type</label>
                            <select class="form-control" id="plan-return" name="plan-return">

                                <option value="0">Specify Return Type</option>

                                <option value="FIXED">FIXED</option>

                                <option value="VARIABLE">VARIABLE</option>

                                <option value="COMPOUND">COMPOUND</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-min">Minimum Price (USD)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-min" name="plan-min">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-max">Maximum  Price (USD)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-max" name="plan-max" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-duration">Duration (DAYS)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-duration" name="plan-duration" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-min">Interest Rate (%)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-rate" name="plan-rate" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-frequency">Payout Frequency</label>
                            <select class="form-control" id="plan-frequency" name="plan-frequency">

                                <option value="0">Select Payout Frequency</option>

                                <?php
                                                                
                                    foreach($factors as $factor):

                                        echo '<option value="' . $factor['factor'] . '">' . $factor['factor'] . '</option>';

                                    endforeach;
                                
                                ?>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-risk">Risk</label>
                            <select class="form-control" id="plan-risk" name="plan-risk">

                                <option value="0">Specify Risk</option>

                                <option value="LOW">LOW</option>

                                <option value="MEDIUM">MEDIUM</option>

                                <option value="HIGH">HIGH</option>

                                <option value="VOLATILE">VOLATILE</option>

                                <option value="EXTREME">EXTREME</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-image">Plan Image (Optional)</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="plan-image" accept="image/*">
                                <label class="custom-file-label" for="plan-image">Upload Plan image</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="plan-desc">Short Description (Optional)</label>
                            <textarea class="form-control" id="plan-desc" name="plan-desc" placeholder="A paragraph describing the plan" ></textarea>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button onclick="return confirm('Have you confirmed the data?')" type="submit" id="addPlan" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>