<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">KYC Management.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="fund-user" class="btn btn-success"><span>Fund an account</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
                        <!-- <th class="nk-tb-col nk-tb-col-check">
                            <div class="custom-control custom-control-sm custom-checkbox notext">
                                <input type="checkbox" class="custom-control-input" id="uid">
                                <label class="custom-control-label" for="uid"></label>
                            </div>
                        </th> -->
                        <th class="nk-tb-col"><span class="sub-text">User</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Document Type</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Issued/Expires</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Face ID / Country</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>
                    </tr>
                </thead>
                <tbody>

                    <?php

                        $recordFound = false; // Records Flag

                        // Get KYC Records

                        $kycRecords = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname`, `B`.`email` FROM `kyc_data` AS `A` JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` ORDER BY `A`.`id` DESC"); // Prepare Statement

                        mysqli_stmt_execute($kycRecords); // Execute Statement

                        $result = mysqli_stmt_get_result($kycRecords); // Get Statement Result

                        if (mysqli_num_rows($result) > 0) { // Get Result's Mass

                            $recordFound = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Collect Result Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($kycRecords); // Close Statement

                        // Check Flag

                        if ($recordFound) {

                            $i = 0; // Counter

                            // Iterate Through Data

                            foreach ($data as $row):

                                $i++; 

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $email = $row['email'];

                                $faceCheck = $row['face'];

                                $proof = SITE_BASE_URL . '/' . htmlspecialchars(str_replace('../',  '',$row['id_proof']));

                                $proofBack = $row['id_proofBack'] != null ? SITE_BASE_URL . '/' . htmlspecialchars(str_replace('../',  '', $row['id_proofBack'])) : null;

                                $type = $row['id_type'];

                                $number = $row['id_num'];

                                $issued = $row['id_issued'];

                                $expires = $row['id_expires'];

                                $country = $row['issuing_country'];

                                $status = $row['status'];

                                $user = $row['user_id'];

                                if ($status == 'PROCESSING') {

                                    $status = "<span class='text-warning'>PENDING</span>";

                                    $stt = "warning";	

                                } else if ($status == 'VERIFIED') {
                                
                                    $stt = "success";	
                                
                                    $status = "<span class='text-success'>$status</span>";	

                                } else {
                                    
                                    $status = "<span class='text-danger'>$status</span>";
                                    
                                    $stt = "danger";
                                }

                            ?>

                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col">
                                        <div class="user-card">
                                            <div class="user-avatar bg-dim-primary d-none d-sm-flex">
                                                <span>
                                                    <?= substr(strtoupper($name), 0, 2) ?>
                                                </span>
                                            </div>
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $name ?>
                                                </span>
                                                <span>
                                                    <?= $email ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= strtoupper($type) ?>
                                        </span>
                                        <span>
                                            <?= $number ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-lead">
                                            <?= date('l d M, Y', strtotime($issued)) ?>
                                        </span>
                                        <span>
                                            <?= date('l d M, Y', strtotime($expires)) ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <span class="tb-amount">
                                            <?= $faceCheck != null ? '<span class="text-success"><em class="icon ni ni-shield-check-fill"></em>ACTIVE</span>' : '<span class="text-danger"><em class="icon ni ni-shield-alert"></em>DISABLED</span>' ?>
                                        </span>
                                        <span>
                                            <?= $country ?>
                                        </span>
                                    </td>
                                  
                                    <td class="nk-tb-col tb-col-md">
                                        <?= $status ?>
                                    </td>
                                    
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <form method="post" class="kyc_form">
                                            <input type="hidden" name="user-id" value="<?= $user ?>">
                                            <ul class="nk-tb-actions gx-1">
                                                <li class="nk-tb-action-hidden">
                                                    <button type="submit" name="approve"
                                                       value="APPROVE"
                                                        class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                        title="Approve KYC">
                                                        <em class="icon ni ni-check text-success"></em>
                                                    </button>
                                                </li>
                                                <li class="nk-tb-action-hidden">
                                                    <button type="submit" name="decline"
                                                        value="DECLINE"
                                                        class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                        title="Reject KYC">
                                                        <em class="icon ni ni-na text-danger"></em>
                                                    </button>
                                                </li>
                                                <li>
                                                    <div class="dropdown">
                                                        <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                            data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                        <div class="dropdown-menu dropdown-menu-right">
                                                            <ul class="link-list-opt no-bdr">
                                                                <li><a href="user-kyc?id=<?= $user ?>"><em
                                                                            class="icon ni ni-eye"></em><span>View
                                                                            Details</span></a>
                                                                </li>

                                                            </ul>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </form>
                                    </td>
                                </tr>

                            <?php endforeach;

                        }

                    ?>

                </tbody>

            </table>
        </div>
    </div>

</div>

<?php

    require('utility/partials/footer.php');

?>