<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `loans` WHERE `loan_id` = ?"); // Prepare Statement (Get Loan Data)

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $amount = $row['amount'];

                $payback = $row['repay'];

                $paid = $row['paid'];

                $interest = $row['interest'] . '%';

                $term = $row['term'] . ' day(s)';

                $purpose = $row['type'];

                $frequency = $row['frequency'];

                $currency = $row['currency'];

                $began = date('l d M, Y',  strtotime($row['start']));

                $ends = date('l d M, Y',  strtotime($row['due']));

                $status = $row['status'];

                $symbol = $currSymbol[$currency];

                $progress = 0;

                if ($payback > 0) {

                    // $progress = round($paid / (100 * $repay), 2);

                    $progress = round($paid * 100) / $payback;

                }

                $progress = round($progress, 2);

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo '<script>
        
                swal({
                
                    title: "Attention!",

                    text: "Error! No data found.",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);

                });

            </script>';

            exit;

        }
    
    } else {

        echo '<script>

            swal({
                
                title: "Attention!",

                text: "Error! No data found.",

                icon: "error"

            }).then(() => {
            
                window.history.go(-1);

            });

        </script>';

        exit;

    }

?>

<!-- content @s -->
<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between g-3">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Loan / <strong class="text-primary small">
                                <?= $id ?>
                            </strong></h3>
                        <div class="nk-block-des text-soft">
                            <ul class="list-inline">
                                <li>ID: <span class="text-base">
                                        <?= $id ?>
                                    </span></li>

                                <li>Collected: <span class="text-base">
                                    <?= $began ?>
                                </span></li>
   

                            </ul>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <a onclick="window.history.go(-1)"
                            class="btn btn-outline-light bg-white d-none d-sm-inline-flex"><em
                                class="icon ni ni-arrow-left"></em><span>Back</span></a>
                        <a onclick="window.history.go(-1)"
                            class="btn btn-icon btn-outline-light bg-white d-inline-flex d-sm-none"><em
                                class="icon ni ni-arrow-left"></em></a>
                    </div>
                </div>
            </div><!-- .nk-block-head -->
            <div class="nk-block">
                <div class="row gy-5">
                    <div class="col-lg-5">
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h5 class="nk-block-title title">Loan Overview</h5>
                                <p>Paid: <?= $progress . '%' ?></p>
                            </div>
                        </div><!-- .nk-block-head -->
                        <div class="card card-bordered">
                            <ul class="data-list is-compact">
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Status</div>

                                        <?php
                                        
                                            if ($status == 'PAID') {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-success">PAID</span>
                                                </div>';

                                            } else if ($status == 'ALIVE') {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-warning">ALIVE</span>
                                                </div>';

                                            } else if ($status == 'OVERDUE') {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-danger">OVERDUE</span>
                                                </div>';

                                            } else {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-danger">UNVERIFIED</span>
                                                </div>';

                                            }
                                        
                                        ?>

                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Currency</div>

                                        <div class="data-value"><?= $currCodeNames[$currency] . ' (' . $currency . ')' ?></div>

                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Amount</div>

                                        <div class="data-value"><?= $symbol . number_format($amount, 2) ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Interest</div>

                                        <div class="data-value"><?= $interest ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Purpose</div>

                                        <div class="data-value"><?= $purpose ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Pay back</div>

                                        <div class="data-value"><?= $symbol .  number_format($payback, 2) ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Term</div>

                                        <div class="data-value"><?= $term ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Paid</div>

                                        <div class="data-value"><?= $symbol . number_format($paid, 2) ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Repayment frequency</div>

                                        <div class="data-value"><?= $frequency ?></div>

                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Expires</div>

                                        <div class="data-value"><?= $ends ?></div>

                                    </div>
                                </li>

                            </ul>
                        </div><!-- .card -->
                    </div><!-- .col -->
                    <div class="col-lg-7">
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h5 class="nk-block-title title">Repayment History</h5>
                                <p>Track Repayments</p>
                            </div>
                        </div>
                        <div class="card card-bordered">
                            <ul class="data-list is-compact">
                                <?php
                                
                                    // Fetch Loan Repayment Schedule

                                    // Fetch Paid And Pending

                                    $records = false; // Flag

                                    $stmt2 = mysqli_prepare($conn, "SELECT SUM(CASE WHEN `status` = ? THEN `amount` ELSE 0 END) AS `paid`, SUM(CASE WHEN `status` != ? AND `due` < ? THEN `amount` ELSE 0 END) AS `owed`, SUM(CASE WHEN `status` = ? AND `due` = ? THEN `amount` ELSE 0 END) AS `current` FROM `repayments_schedule` WHERE `loan_id` = ?"); // Prepare Statement

                                    $date = date('Y-m-d', time());

                                    $status = 'PAID';

                                    $status2 = 'PENDING';

                                    mysqli_stmt_bind_param($stmt2, "ssssss", $status, $status, $date, $status2, $date, $id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt2); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt2);

                                    if (mysqli_num_rows($result) > 0) {

                                        $records = true; // Update Flag

                                        $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt2); // Close Statement

                                    // Fetch Future Payments

                                    $future = false; // Flag

                                    $stmt3 = mysqli_prepare($conn, "SELECT * FROM `repayments_schedule` WHERE `due` > ? AND `loan_id` = ?"); // Prepare Statement
                                    
                                    mysqli_stmt_bind_param($stmt3, "ss", $date, $id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt3); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt3); // Fetch Result

                                    if (mysqli_num_rows($result) > 0) { // Compare Result

                                        $future = true;

                                        $dataB = mysqli_fetch_all($result, MYSQLI_ASSOC); // Store Result

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt3); // Close Statement

                                    if ($records || $future) {

                                        $timeline = null;

                                        if ($records) {

                                            foreach ($data as $row):

                                                $paid = $row['paid'];

                                                $owed = $row['owed'];

                                                $current = $row['current'] ?? 0;

                                            endforeach;

                                            $paid = number_format($paid, 2);

                                            $owed = number_format($owed, 2);

                                            $current = number_format($current, 2);
                                            
                                            $timeline .= <<<HTML
                                            
                                                <li class="data-item">
                                                    <div class="data-col">
                                                        <div class="data-label">Paid</div>
                                                        <div class="data-value">
                                                            $symbol$paid
                                                        </div>
                                                    </div>
                                                </li>

                                                <li class="data-item">
                                                    <div class="data-col">
                                                        <div class="data-label">Owed</div>
                                                        <div class="data-value">
                                                            $symbol$owed
                                                        </div>
                                                    </div>
                                                </li>

                                                <li class="data-item">
                                                    <div class="data-col">
                                                        <div class="data-label">Due Today</div>
                                                        <div class="data-value">
                                                            $symbol$current
                                                        </div>
                                                    </div>
                                                </li>


                                            HTML;

                                        }

                                        if ($future) {

                                            $timeline .= <<<HTML
                                            
                                                <li class="data-item">
                                                    <div class="data-col">
                                                        <div class="data-label">Pending Payments</div>
                                                        <div class="data-value">
                                                           Due Date
                                                        </div>
                                                    </div>
                                                </li>

                                            HTML;

                                            foreach ($dataB as $row):

                                                $amount = number_format($row['amount'], 2);

                                                $due = date('M d, Y', strtotime($row['due']));

                                                $timeline .= <<<HTML

                                                    <li class="data-item">
                                                        <div class="data-col">
                                                            <div class="data-label">$symbol$amount</div>
                                                            <div class="data-value">
                                                                $due
                                                            </div>
                                                        </div>
                                                    </li>

                                                HTML;

                                            endforeach;

                                        }

                                        echo $timeline;

                                    } else { ?>

                                        <li class="data-item">
                                            <div class="data-col">
                                                <div class="data-label">(0)</div>
                                                <div class="data-value">
                                                    No Record Found
                                                </div>
                                            </div>
                                        </li>

                                    <?php }
                                                            
                                ?>
                               
                            </ul>
                        </div>
                      
                    </div><!-- .col -->
                </div><!-- .row -->
            </div><!-- .nk-block -->
        </div>
    </div>
</div>
<!-- content @e -->


<?php

    require('utility/partials/footer.php');

?>