<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Loan Management.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="fund-user" class="btn btn-success"><span>Fund an account</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">

                        <th class="nk-tb-col">#</th>

                        <th class="nk-tb-col"><span class="sub-text">Loan Id</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Account Holder</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Amount / Rate</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Duration / Paid</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Type (Purpose) / Due</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                        $recordFound = false; // Flag
                    
                        // Fetch Loan Applications

                        $loanRecords =  mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname`, `B`.`email` FROM `loans` AS `A` JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` ORDER BY `A`.`id` DESC"); // Prepare Statement

                        mysqli_stmt_execute($loanRecords); // Execute Statement

                        $result = mysqli_stmt_get_result($loanRecords); // Get Statement Result

                        if (mysqli_num_rows($result) > 0) { // Get Result's Mass

                            $recordFound = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Collect Result Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($loanRecords); // Close Statement

                        // Check Flag

                        if ($recordFound) {

                            $i = 0; // Counter

                            // Iterate Through Data

                            foreach ($data as $row):

                                $i++;

                                $id = $row['loan_id'];

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $type = $row['type'];

                                $date = $row['start'];

                                $ends = $row['due'];

                                $amount = $row['amount'];

                                $currency = $row['currency'];

                                $rate = $row['interest'];

                                $duration = $row['term'];

                                $payFreq = $row['frequency'];

                                $status = $row['status'];

                                $symbol = $currSymbol[$currency];

                            ?>

                            <tr class="nk-tb-item">
                                <!-- <td class="nk-tb-col nk-tb-col-check">
                                                <div class="custom-control custom-control-sm custom-checkbox notext">
                                                    <input type="checkbox" class="custom-control-input" id="<?php echo$id ?>">
                                                    <label class="custom-control-label" for="<?php echo$id ?>"></label>
                                                </div>
                                            </td> -->
                                <td class="nk-tb-col">
                                    <?= $i ?>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $id ?>
                                            </span>
                                            <span>
                                                <?= date('l jS, F, Y', strtotime($date)) ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                    <span class="tb-amount">
                                        <?= $name ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                    <span class="tb-amount">
                                        <?= $symbol . $amount . ' (' . $currency . ')' ?>
                                    </span>
                                    <span class="currency">
                                        <?= $rate . '%' ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col tb-col-md">
                                    <span class="tb-lead">
                                        <?= $duration . ' days (' . $payFreq . ')' ?>
                                    </span>
                                    <span>
                                        <?= '0%' ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col tb-col-lg" data-order="">

                                    <span class="tb-lead"><?= $type ?></span>

                                    <span><?= date('l jS, F, Y', strtotime($ends)) ?></span>

                                </td>

                                <td class="nk-tb-col tb-col-md">
                                    <?= $status ?>
                                </td>
                                <td class="nk-tb-col nk-tb-col-tools">
                                    <form method="post" class="loanMgmt_form">

                                        <input type="hidden" name="loan-id" value="<?= $id ?>">

                                        <ul class="nk-tb-actions gx-1">

                                            <!-- <li class="nk-tb-action-hidden">

                                                <button type="submit" name="approve" value="APPROVE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Approve Loan Request">
                                                    <em class="icon ni ni-check-circle-fill text-success"></em>
                                                </button>

                                            </li>

                                            <li class="nk-tb-action-hidden">

                                                <button type="submit" name="decline" value="DECLINE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Decline Loan Request">
                                                    <em class="icon ni ni-na text-danger"></em>
                                                </button>

                                            </li> -->

                                            <li class="nk-tb-action-hidden">

                                                <button type="submit" name="delete" value="DELETE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Delete Loan Record">
                                                    <em class="icon ni ni-delete text-danger"></em>
                                                </button>

                                            </li>

                                            <li>

                                                <div class="dropdown">

                                                    <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <ul class="link-list-opt no-bdr">
                                                            <li>
                                                                <a href="loan-details?id=<?= $id ?>"><em class="icon ni ni-eye"></em><span>View Details</span></a>

                                                            </li>

                                                            <!-- <li>
                                                                <a href="loan-schedule?id=<?= $id ?>"><em class="icon ni ni-list"></em><span>Track Repayments</span></a>

                                                            </li> -->

                                                        </ul>

                                                    </div>
                                                    
                                                </div>    

                                            </li>

                                        </ul>

                                    </form>
                                </td>
                            </tr>

                        <?php endforeach;

                            }

                        ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<?php

    require('utility/partials/footer.php');

?>