<?php

    session_name('ADMINSESSID');
    
    session_start(); // Establish Sessions

    require('../controls/config/config.php'); // Configuration File

    require('../controls/engines/fxns.php'); // Functions File

?>
<!DOCTYPE html>

<html lang="en" class="js">

    <head>
        <meta charset="utf-8">
        <meta name="author" content="Softnio">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="<?= SITE_DESCR ?>">
        <link rel="shortcut icon" href="<?= SITE_FAVICON ?>" type="image/x-icon">
        <noscript>
            <meta http-equiv="refresh" content="0; url=../noscript"/>
        </noscript>
        <!-- Fav Icon  -->
        <link rel="shortcut icon" href="<?= SITE_FAVICON ?>">
        <!-- Page Title  -->
        <title>Login | Welcome <?= SITE_NAME ?> Admin </title>
        <!-- StyleSheets  -->
        <link rel="stylesheet" href="assets/css/dashlite.css?ver=2.4.0">
        <link rel="stylesheet" href="../resources/swal/sweet-alert.css">
        <link id="skin-default" rel="stylesheet" href="assets/css/theme.css?ver=2.4.0">
    </head>

    <body class="nk-body npc-crypto bg-white pg-auth">
        <!-- app body @s -->
        <div class="nk-app-root">
            <div class="nk-split nk-split-page nk-split-md">
                <div class="nk-split-content nk-block-area nk-block-area-column nk-auth-container bg-white">
                    <div class="absolute-top-right d-lg-none p-3 p-sm-5">
                        <a href="#" class="toggle btn-white btn btn-icon btn-light" data-target="athPromo"><em
                                class="icon ni ni-info"></em></a>
                    </div>
                    <div class="nk-block nk-block-middle nk-auth-body">
                        <div class="brand-logo pb-5">
                            <a href="../" class="logo-link">
                                <img class="logo-light logo-img logo-img-lg" src="<?= SITE_LOGO ?>"
                                    srcset="<?= SITE_LOGO_DARK ?>" alt="logo">
                                <img class="logo-dark logo-img logo-img-lg" src="<?= SITE_LOGO_DARK ?>"
                                    srcset="<?= SITE_LOGO ?>" alt="logo-dark">
                            </a>
                        </div>
                        <br>
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h5 class="nk-block-title">Sign-In</h5>
                                <div class="nk-block-des alert alert-pro alert-primary">
                                    <p class="alert-text">Access the
                                        <?= SITE_NAME ?> online banking panel using your Email address and password.
                                    </p>
                                </div>
                            </div>
                        </div><!-- .nk-block-head -->

                        <?php

                            if (isset($_REQUEST['loginForm'])) {

                                // Sanitize Fields
                                
                                $email = filter_var($_REQUEST['email'], FILTER_SANITIZE_SPECIAL_CHARS); // FILTER_SANITIZE_EMAIL

                                $password = md5($_REQUEST['password']); // filterString($_REQUEST['password'])

                                $errorMsg = 0;

                                if (empty($email) || empty($password)) {

                                    echo "<div class='alert alert-danger alert-dismissible'>All fields are required!</div>";
                                    $errorMsg = 1;

                                }

                                // if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                                
                                //     $errorMsg = 1;
                                //     echo "<div class='alert alert-danger alert-dismissible'>Valid email is required!</div>";
                                
                                // }

                                
                                if($errorMsg == 0){

                                    $pass = md5($password); // Encrypt Password

                                    // $conn->set_charset('charset');

                                    // $query = $conn->query("SELECT * FROM users WHERE email = '$email' AND `password` = '$pass' AND id = 1");

                                    $validCredentials = false; // Login Flag

                                    // Determine Access Status

                                    $access = mysqli_prepare($conn, "SELECT * FROM `admin` WHERE (`username` = CAST(? AS BINARY) OR `email` = CAST(? AS BINARY)) AND `password` = ?"); // Prepare Statement

                                    mysqli_stmt_bind_param($access, "sss", $email, $email, $password); // Bind Parameter(s) 

                                    mysqli_stmt_execute($access); // Execute Statement

                                    $accessResult = mysqli_stmt_get_result($access); // Get Result

                                    if (mysqli_num_rows($accessResult) === 1) {

                                        $validCredentials = true; // Update Flag

                                    }

                                    mysqli_free_result($accessResult); // Free Result

                                    mysqli_stmt_close($access); // Close Statement

                                    // Check Flag

                                    if ($validCredentials) {

                                        $_SESSION['ADMIN-ID'] = randomString(64);

                                        $_SESSION['LOG-ADMIN'] = 1;

                                        $token = $_SESSION['ADMIN-ID'];

                                        echo '<script>
                                        
                                            window.location.href = "dashboard";

                                        </script>';

                                    } else {

                                        echo "<div class='alert alert-danger alert-dismissible'>Invalid Email address or passwordd</div>";

                                    }

                                    // if (mysqli_num_rows($query) < 1) {
                                    
                                    //     echo "<div class='alert alert-danger alert-dismissible'>Invalid Email address or passwordd</div>"; 
                                    
                                    // }else{
                                    //     //echo "<div class='alert alert-success alert-dismissible'>You have successfully login!</div>";
                                    //     $_SESSION['ADMIN-ID'] = randomString(64);
                                    //     $_SESSION['LOG-ADMIN'] = 1;
                                    //     $token = $_SESSION['ADMIN-ID'];
                                    //     $ip = $_SERVER["REMOTE_ADDR"];
                                    //     $dated = date("d M y, H:i a");
                                    //     $browser = $_SERVER["HTTP_USER_AGENT"];
                                    //     $queryyy = $conn->query("INSERT INTO login(ip, browser, dated, token, userid) VALUES ('$ip', '$browser', '$dated', '$token', 1)");
                                    //     ?>
                                            
                                    <!-- //         <meta http-equiv="refresh" content="0; url=account_manager?accessToken=<?php //echo $_SESSION['ADMIN-ID']; ?>"> -->

                                       <?php

                                    // }
                                }
                            }

                        ?>
                        <form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="post">
                            <div class="form-group">
                                <div class="form-label-group">
                                    <label class="form-label" for="default-01">Email address / Username</label>
                                    <a class="link link-primary link-sm" tabindex="-1" href="#">Need Help?</a>
                                </div>
                                <input type="text" class="form-control form-control-lg" autocomplete="off" id="default-01"
                                    placeholder="Enter your Email address" name="email">
                            </div><!-- foem-group -->
                            <div class="form-group">
                                <div class="form-label-group">
                                    <label class="form-label" for="password">Password</label>
                                    <a class="link link-primary link-sm" tabindex="-1" href="#">Forgot Code?</a>
                                </div>
                                <div class="form-control-wrap">
                                    <a tabindex="-1" href="#" class="form-icon form-icon-right passcode-switch"
                                        data-target="password">
                                        <em class="passcode-icon icon-show icon ni ni-eye"></em>
                                        <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                                    </a>
                                    <input type="password" class="form-control form-control-lg" id="password"
                                        placeholder="Enter your password" name="password">
                                </div>
                            </div><!-- .foem-group -->
                            <div class="form-group">
                                <button class="btn btn-lg btn-primary btn-block" type="submit"
                                    name="loginForm">Continue</button>
                            </div>
                        </form><!-- form -->

                    </div><!-- .nk-block -->
                    <div class="nk-block nk-auth-footer">
                        <div class="mt-3">
                            <p>&copy;
                                <?= date('Y') . ' ' . SITE_NAME ?>. All Rights Reserved.
                            </p>
                        </div>
                    </div><!-- .nk-block -->
                </div><!-- .nk-split-content -->

                <div class="nk-split-content nk-split-stretch bg-lighter d-flex toggle-break-lg toggle-slide toggle-slide-right"
                    data-content="athPromo" data-toggle-screen="lg" data-toggle-overlay="true">
                    <div class="slider-wrap w-100 w-max-550px p-3 p-sm-5 m-auto">
                        <div class="slider-init" data-slick='{"dots":true, "arrows":false}'>
                            <div class="slider-item">
                                <div class="nk-feature nk-feature-center">
                                    <div class="nk-feature-img">
                                        <img class="round" src="../images/banking.svg" srcset="../images/banking.svg 2x"
                                            alt="">
                                    </div>
                                    <div class="nk-feature-content py-4 p-sm-5">
                                        <h4>Welcome <?= SITE_NAME ?> Administrator.</h4>
                                        <p>Please, enter your credentials to gain access</p>
                                    </div>
                                </div>
                            </div><!-- .slider-item -->
                        </div><!-- .slider-init -->
                        <div class="slider-dots"></div>
                        <div class="slider-arrows"></div>
                    </div><!-- .slider-wrap -->
                </div><!-- .nk-split-content -->

            </div><!-- .nk-split -->

        </div><!-- app body @e -->

        <!-- JavaScript -->
        <script src="assets/js/bundle.js?ver=2.4.0"></script>
        <script src="assets/js/scripts.js?ver=2.4.0"></script>
        <script src="../resources/swal/sweetalert.min.js"></script>

    </body>

</html>