<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Get Resource Data

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `pay_resources` WHERE `id` = ?"); // Prepare Statement 

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            $found = true;

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Hold Resource Data

            foreach ($data as $row):

                $type = $row['type'];

                $name = $row['resource_name'];

                $address = $row['resource_attr'];

                $symbol = $row['resource_symbol'];

                $network = $row['network_type'];

                $qrCode = $row['resource_qrcode'];

                $owner = $row['vendor_name'];

                $bank = $row['bank_name'];

                $swift = $row['swift'];

                $iban = $row['iban'];

                $routing = $row['routing'];

                $sorting = $row['sorting'];

                $country = $row['country_code'];
                
            endforeach;

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo '<script>
        
                swal({

                    title: "Error!",
                
                    text: "Resource not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;    

        }

    } else {

        echo '<script>
        
            swal({

                title: "Error!",
            
                text: "Invalid credentials",

                icon: "error"

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit Payment Resource</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="settings"
                                    class="btn btn-info">
                                    <span>General Settings</span> <em class="icon ni ni-setting"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="nk-block nk-block-lg">
        <!-- <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="title nk-block-title">Add New Payment Channel</h4>
                <div class="nk-block-des">
                    <p></p>
                </div>
            </div>
        </div> -->
        <div class="row g-gs">
            <div class="col-lg-6">
                <div class="card card-bordered h-100">
                    <div class="card-inner">
                        <!-- <div class="card-head">
                            <h5 class="card-title">Create New Payment Channel</h5>
                        </div> -->
                        <form method="post" id="<?= isset($type) && $type == 'BANK' ? 'editBank-form' : 'editResource-form' ?>" autocomplete="off" enctype="multipart/form-data">
                            <div class="form-group"><label class="form-label" for="pay-type">Type</label>
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" name="pay-type" value="<?= isset($type) ? $type : null ?>" readonly>
                                    <input type="hidden" name="old-qr" value="<?= isset($qrCode) ? $qrCode : null ?>">
                                    <input type="hidden" name="r-id" value="<?= isset($id) ? $id : null ?>">
                                </div>
                            </div>

                            <?php
                            
                                if ($type == 'BANK') { ?>

                                    <div class="form-group"><label class="form-label" for="acc-name">Account Name</label><input
                                    type="text" class="form-control" name="acc-name" value="<?= isset($name) ? $name : null ?>" required></div>
                            
                                    <div class="form-group"><label class="form-label" for="acc-num">Account Number</label><input
                                    type="number" class="form-control" name="acc-num" value="<?= isset($address) ? $address : null ?>" required></div>

                                    <div class="form-group"><label class="form-label" for="acc-bank">Bank Name</label><input
                                            type="text" class="form-control" name="acc-bank" value="<?= isset($bank) ? $bank : null ?>" required></div>

                                    <div class="form-group"><label class="form-label" for="acc-country">Bank Country</label><select class="form-control" name="acc-country" required>

                                        <option value="<?= isset($country) ? $country : null ?>"><?= isset($country) ? $country : null ?></option>

                                        <option value="AF" title="Afghanistan">Afghanistan</option>
                                        <option value="AX" title="Åland Islands">Åland Islands</option>
                                        <option value="AL" title="Albania">Albania</option>
                                        <option value="DZ" title="Algeria">Algeria</option>
                                        <option value="AS" title="American Samoa">American Samoa</option>
                                        <option value="AD" title="Andorra">Andorra</option>
                                        <option value="AO" title="Angola">Angola</option>
                                        <option value="AI" title="Anguilla">Anguilla</option>
                                        <option value="AQ" title="Antarctica">Antarctica</option>
                                        <option value="AG" title="Antigua and Barbuda">Antigua and Barbuda</option>
                                        <option value="AR" title="Argentina">Argentina</option>
                                        <option value="AM" title="Armenia">Armenia</option>
                                        <option value="AW" title="Aruba">Aruba</option>
                                        <option value="AU" title="Australia">Australia</option>
                                        <option value="AT" title="Austria">Austria</option>
                                        <option value="AZ" title="Azerbaijan">Azerbaijan</option>
                                        <option value="BS" title="Bahamas">Bahamas</option>
                                        <option value="BH" title="Bahrain">Bahrain</option>
                                        <option value="BD" title="Bangladesh">Bangladesh</option>
                                        <option value="BB" title="Barbados">Barbados</option>
                                        <option value="BY" title="Belarus">Belarus</option>
                                        <option value="BE" title="Belgium">Belgium</option>
                                        <option value="BZ" title="Belize">Belize</option>
                                        <option value="BJ" title="Benin">Benin</option>
                                        <option value="BM" title="Bermuda">Bermuda</option>
                                        <option value="BT" title="Bhutan">Bhutan</option>
                                        <option value="BO" title="Bolivia">Bolivia, Plurinational State of</option>
                                        <option value="BQ" title="Bonaire, Sint Eustatius and Saba">Bonaire, Sint Eustatius and Saba</option>
                                        <option value="BA" title="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                        <option value="BW" title="Botswana">Botswana</option>
                                        <option value="BV" title="Bouvet Island">Bouvet Island</option>
                                        <option value="BR" title="Brazil">Brazil</option>
                                        <option value="IO" title="British Indian Ocean Territory">British Indian Ocean Territory</option>
                                        <option value="BN" title="Brunei Darussalam">Brunei Darussalam</option>
                                        <option value="BG" title="Bulgaria">Bulgaria</option>
                                        <option value="BF" title="Burkina Faso">Burkina Faso</option>
                                        <option value="BI" title="Burundi">Burundi</option>
                                        <option value="KH" title="Cambodia">Cambodia</option>
                                        <option value="CM" title="Cameroon">Cameroon</option>
                                        <option value="CA" title="Canada">Canada</option>
                                        <option value="CV" title="Cape Verde">Cape Verde</option>
                                        <option value="KY" title="Cayman Islands">Cayman Islands</option>
                                        <option value="CF" title="Central African Republic">Central African Republic</option>
                                        <option value="TD" title="Chad">Chad</option>
                                        <option value="CL" title="Chile">Chile</option>
                                        <option value="CN" title="China">China</option>
                                        <option value="CX" title="Christmas Island">Christmas Island</option>
                                        <option value="CC" title="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
                                        <option value="CO" title="Colombia">Colombia</option>
                                        <option value="KM" title="Comoros">Comoros</option>
                                        <option value="CG" title="Congo">Congo</option>
                                        <option value="CD" title="Congo, the Democratic Republic of the">Congo, the Democratic Republic of the</option>
                                        <option value="CK" title="Cook Islands">Cook Islands</option>
                                        <option value="CR" title="Costa Rica">Costa Rica</option>
                                        <option value="CI" title="Côte d'Ivoire">Côte d'Ivoire</option>
                                        <option value="HR" title="Croatia">Croatia</option>
                                        <option value="CU" title="Cuba">Cuba</option>
                                        <option value="CW" title="Curaçao">Curaçao</option>
                                        <option value="CY" title="Cyprus">Cyprus</option>
                                        <option value="CZ" title="Czech Republic">Czech Republic</option>
                                        <option value="DK" title="Denmark">Denmark</option>
                                        <option value="DJ" title="Djibouti">Djibouti</option>
                                        <option value="DM" title="Dominica">Dominica</option>
                                        <option value="DO" title="Dominican Republic">Dominican Republic</option>
                                        <option value="EC" title="Ecuador">Ecuador</option>
                                        <option value="EG" title="Egypt">Egypt</option>
                                        <option value="SV" title="El Salvador">El Salvador</option>
                                        <option value="GQ" title="Equatorial Guinea">Equatorial Guinea</option>
                                        <option value="ER" title="Eritrea">Eritrea</option>
                                        <option value="EE" title="Estonia">Estonia</option>
                                        <option value="ET" title="Ethiopia">Ethiopia</option>
                                        <option value="FK" title="Falkland Islands (Malvinas)">Falkland Islands (Malvinas)</option>
                                        <option value="FO" title="Faroe Islands">Faroe Islands</option>
                                        <option value="FJ" title="Fiji">Fiji</option>
                                        <option value="FI" title="Finland">Finland</option>
                                        <option value="FR" title="France">France</option>
                                        <option value="GF" title="French Guiana">French Guiana</option>
                                        <option value="PF" title="French Polynesia">French Polynesia</option>
                                        <option value="TF" title="French Southern Territories">French Southern Territories</option>
                                        <option value="GA" title="Gabon">Gabon</option>
                                        <option value="GM" title="Gambia">Gambia</option>
                                        <option value="GE" title="Georgia">Georgia</option>
                                        <option value="DE" title="Germany">Germany</option>
                                        <option value="GH" title="Ghana">Ghana</option>
                                        <option value="GI" title="Gibraltar">Gibraltar</option>
                                        <option value="GR" title="Greece">Greece</option>
                                        <option value="GL" title="Greenland">Greenland</option>
                                        <option value="GD" title="Grenada">Grenada</option>
                                        <option value="GP" title="Guadeloupe">Guadeloupe</option>
                                        <option value="GU" title="Guam">Guam</option>
                                        <option value="GT" title="Guatemala">Guatemala</option>
                                        <option value="GG" title="Guernsey">Guernsey</option>
                                        <option value="GN" title="Guinea">Guinea</option>
                                        <option value="GW" title="Guinea-Bissau">Guinea-Bissau</option>
                                        <option value="GY" title="Guyana">Guyana</option>
                                        <option value="HT" title="Haiti">Haiti</option>
                                        <option value="HM" title="Heard Island and McDonald Islands">Heard Island and McDonald Islands</option>
                                        <option value="VA" title="Holy See (Vatican City State)">Holy See (Vatican City State)</option>
                                        <option value="HN" title="Honduras">Honduras</option>
                                        <option value="HK" title="Hong Kong">Hong Kong</option>
                                        <option value="HU" title="Hungary">Hungary</option>
                                        <option value="IS" title="Iceland">Iceland</option>
                                        <option value="IN" title="India">India</option>
                                        <option value="ID" title="Indonesia">Indonesia</option>
                                        <option value="IR" title="Iran, Islamic Republic of">Iran, Islamic Republic of</option>
                                        <option value="IQ" title="Iraq">Iraq</option>
                                        <option value="IE" title="Ireland">Ireland</option>
                                        <option value="IM" title="Isle of Man">Isle of Man</option>
                                        <option value="IL" title="Israel">Israel</option>
                                        <option value="IT" title="Italy">Italy</option>
                                        <option value="JM" title="Jamaica">Jamaica</option>
                                        <option value="JP" title="Japan">Japan</option>
                                        <option value="JE" title="Jersey">Jersey</option>
                                        <option value="JO" title="Jordan">Jordan</option>
                                        <option value="KZ" title="Kazakhstan">Kazakhstan</option>
                                        <option value="KE" title="Kenya">Kenya</option>
                                        <option value="KI" title="Kiribati">Kiribati</option>
                                        <option value="KP" title="Korea, Democratic People's Republic of">Korea, Democratic People's Republic of</option>
                                        <option value="KR" title="Korea, Republic of">Korea, Republic of</option>
                                        <option value="KW" title="Kuwait">Kuwait</option>
                                        <option value="KG" title="Kyrgyzstan">Kyrgyzstan</option>
                                        <option value="LA" title="Lao People's Democratic Republic">Lao People's Democratic Republic</option>
                                        <option value="LV" title="Latvia">Latvia</option>
                                        <option value="LB" title="Lebanon">Lebanon</option>
                                        <option value="LS" title="Lesotho">Lesotho</option>
                                        <option value="LR" title="Liberia">Liberia</option>
                                        <option value="LY" title="Libya">Libya</option>
                                        <option value="LI" title="Liechtenstein">Liechtenstein</option>
                                        <option value="LT" title="Lithuania">Lithuania</option>
                                        <option value="LU" title="Luxembourg">Luxembourg</option>
                                        <option value="MO" title="Macao">Macao</option>
                                        <option value="MG" title="Madagascar">Madagascar</option>
                                        <option value="MW" title="Malawi">Malawi</option>
                                        <option value="MY" title="Malaysia">Malaysia</option>
                                        <option value="MV" title="Maldives">Maldives</option>
                                        <option value="ML" title="Mali">Mali</option>
                                        <option value="MT" title="Malta">Malta</option>
                                        <option value="MH" title="Marshall Islands">Marshall Islands</option>
                                        <option value="MQ" title="Martinique">Martinique</option>
                                        <option value="MR" title="Mauritania">Mauritania</option>
                                        <option value="MU" title="Mauritius">Mauritius</option>
                                        <option value="YT" title="Mayotte">Mayotte</option>
                                        <option value="MX" title="Mexico">Mexico</option>
                                        <option value="FM" title="Micronesia, Federated States of">Micronesia, Federated States of</option>
                                        <option value="MD" title="Moldova, Republic of">Moldova, Republic of</option>
                                        <option value="MC" title="Monaco">Monaco</option>
                                        <option value="MN" title="Mongolia">Mongolia</option>
                                        <option value="ME" title="Montenegro">Montenegro</option>
                                        <option value="MS" title="Montserrat">Montserrat</option>
                                        <option value="MA" title="Morocco">Morocco</option>
                                        <option value="MZ" title="Mozambique">Mozambique</option>
                                        <option value="MM" title="Myanmar">Myanmar</option>
                                        <option value="NA" title="Namibia">Namibia</option>
                                        <option value="NR" title="Nauru">Nauru</option>
                                        <option value="NP" title="Nepal">Nepal</option>
                                        <option value="NL" title="Netherlands">Netherlands</option>
                                        <option value="NC" title="New Caledonia">New Caledonia</option>
                                        <option value="NZ" title="New Zealand">New Zealand</option>
                                        <option value="NI" title="Nicaragua">Nicaragua</option>
                                        <option value="NE" title="Niger">Niger</option>
                                        <option value="NG" title="Nigeria">Nigeria</option>
                                        <option value="NU" title="Niue">Niue</option>
                                        <option value="NF" title="Norfolk Island">Norfolk Island</option>
                                        <option value="MP" title="Northern Mariana Islands">Northern Mariana Islands</option>
                                        <option value="NO" title="Norway">Norway</option>
                                        <option value="OM" title="Oman">Oman</option>
                                        <option value="PK" title="Pakistan">Pakistan</option>
                                        <option value="PW" title="Palau">Palau</option>
                                        <option value="PS" title="Palestine, State of">Palestine, State of</option>
                                        <option value="PA" title="Panama">Panama</option>
                                        <option value="PG" title="Papua New Guinea">Papua New Guinea</option>
                                        <option value="PY" title="Paraguay">Paraguay</option>
                                        <option value="PE" title="Peru">Peru</option>
                                        <option value="PH" title="Philippines">Philippines</option>
                                        <option value="PN" title="Pitcairn">Pitcairn</option>
                                        <option value="PL" title="Poland">Poland</option>
                                        <option value="PT" title="Portugal">Portugal</option>
                                        <option value="PR" title="Puerto Rico">Puerto Rico</option>
                                        <option value="QA" title="Qatar">Qatar</option>
                                        <option value="RE" title="Réunion">Réunion</option>
                                        <option value="RO" title="Romania">Romania</option>
                                        <option value="RU" title="Russian Federation">Russian Federation</option>
                                        <option value="RW" title="Rwanda">Rwanda</option>
                                        <option value="BL" title="Saint Barthélemy">Saint Barthélemy</option>
                                        <option value="SH" title="Saint Helena, Ascension and Tristan da Cunha">Saint Helena, Ascension and Tristan da Cunha</option>
                                        <option value="KN" title="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                        <option value="LC" title="Saint Lucia">Saint Lucia</option>
                                        <option value="MF" title="Saint Martin (French part)">Saint Martin (French part)</option>
                                        <option value="PM" title="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
                                        <option value="VC" title="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
                                        <option value="WS" title="Samoa">Samoa</option>
                                        <option value="SM" title="San Marino">San Marino</option>
                                        <option value="ST" title="Sao Tome and Principe">Sao Tome and Principe</option>
                                        <option value="SA" title="Saudi Arabia">Saudi Arabia</option>
                                        <option value="SN" title="Senegal">Senegal</option>
                                        <option value="RS" title="Serbia">Serbia</option>
                                        <option value="SC" title="Seychelles">Seychelles</option>
                                        <option value="SL" title="Sierra Leone">Sierra Leone</option>
                                        <option value="SG" title="Singapore">Singapore</option>
                                        <option value="SX" title="Sint Maarten (Dutch part)">Sint Maarten (Dutch part)</option>
                                        <option value="SK" title="Slovakia">Slovakia</option>
                                        <option value="SI" title="Slovenia">Slovenia</option>
                                        <option value="SB" title="Solomon Islands">Solomon Islands</option>
                                        <option value="SO" title="Somalia">Somalia</option>
                                        <option value="ZA" title="South Africa">South Africa</option>
                                        <option value="GS" title="South Georgia and the South Sandwich Islands">South Georgia and the South Sandwich Islands</option>
                                        <option value="SS" title="South Sudan">South Sudan</option>
                                        <option value="ES" title="Spain">Spain</option>
                                        <option value="LK" title="Sri Lanka">Sri Lanka</option>
                                        <option value="SD" title="Sudan">Sudan</option>
                                        <option value="SR" title="Suriname">Suriname</option>
                                        <option value="SJ" title="Svalbard and Jan Mayen">Svalbard and Jan Mayen</option>
                                        <option value="SZ" title="Swaziland">Swaziland</option>
                                        <option value="SE" title="Sweden">Sweden</option>
                                        <option value="CH" title="Switzerland">Switzerland</option>
                                        <option value="SY" title="Syrian Arab Republic">Syrian Arab Republic</option>
                                        <option value="TW" title="Taiwan, Province of China">Taiwan, Province of China</option>
                                        <option value="TJ" title="Tajikistan">Tajikistan</option>
                                        <option value="TZ" title="Tanzania, United Republic of">Tanzania, United Republic of</option>
                                        <option value="TH" title="Thailand">Thailand</option>
                                        <option value="TL" title="Timor-Leste">Timor-Leste</option>
                                        <option value="TG" title="Togo">Togo</option>
                                        <option value="TK" title="Tokelau">Tokelau</option>
                                        <option value="TO" title="Tonga">Tonga</option>
                                        <option value="TT" title="Trinidad and Tobago">Trinidad and Tobago</option>
                                        <option value="TN" title="Tunisia">Tunisia</option>
                                        <option value="TR" title="Turkey">Turkey</option>
                                        <option value="TM" title="Turkmenistan">Turkmenistan</option>
                                        <option value="TC" title="Turks and Caicos Islands">Turks and Caicos Islands</option>
                                        <option value="TV" title="Tuvalu">Tuvalu</option>
                                        <option value="UG" title="Uganda">Uganda</option>
                                        <option value="UA" title="Ukraine">Ukraine</option>
                                        <option value="AE" title="United Arab Emirates">United Arab Emirates</option>
                                        <option value="GB" title="United Kingdom">United Kingdom</option>
                                        <option value="US" title="United States of America">United States of America</option>
                                        <option value="UM" title="United States Minor Outlying Islands">United States Minor Outlying Islands</option>
                                        <option value="UY" title="Uruguay">Uruguay</option>
                                        <option value="UZ" title="Uzbekistan">Uzbekistan</option>
                                        <option value="VU" title="Vanuatu">Vanuatu</option>
                                        <option value="VE" title="Venezuela, Bolivarian Republic of">Venezuela, Bolivarian Republic of</option>
                                        <option value="VN" title="Viet Nam">Viet Nam</option>
                                        <option value="WF" title="Wallis and Futuna">Wallis and Futuna</option>
                                        <option value="EH" title="Western Sahara">Western Sahara</option>
                                        <option value="YE" title="Yemen">Yemen</<option>
                                        <option value="ZM" title="Zambia">Zambia</option>
                                        <option value="ZW" title="Zimbabwe">Zimbabwe</option>

                                    </select></div>

                                    <div class="row my-2">

                                        <div class="col-md-6">
                                            <div class="form-group">
                                            <label class="form-label" for="acc-iban">IBAN</label><input
                                            type="text" class="form-control" name="acc-iban" value="<?= isset($iban) ? $iban : null ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label" for="acc-routing">Routing Number</label><input
                                                type="text" class="form-control" name="acc-routing" value="<?= isset($routing) ? $routing : null ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                            <label class="form-label" for="acc-sort">Sorting Code</label><input
                                            type="text" class="form-control" name="acc-sort" value="<?= isset($sorting) ? $sorting : null ?>">
                                            </div>
                                        </div>

                                    </div>

                                <?php } else { ?>

                                    <div class="form-group"><label class="form-label" for="pay-name">Name</label>
                                        <div class="form-control-wrap"><input type="text" class="form-control"
                                                name="pay-name" value="<?= isset($name) ? $name : null ?>" placeholder="Account Name / Token Name / Cryptocurrency e.g Bitcoin" required></div>
                                    </div>

                                    <?php if ($type == 'CRYPTO') { ?>

                                        <div>

                                            <b>For Crypto Only</b>

                                            <hr>

                                        </div>

                                        <div class="row">

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="name-abbr">Crypto Symbol (Short Name)</label>
                                                    <input type="text" class="form-control" name="name-abbr" value="<?= isset($symbol) ? $symbol : null ?>" placeholder="E.g BTC">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="network-type">Network Type</label>
                                                    <input type="text" class="form-control" name="network-type" value="<?= isset($network) ? $network : null ?>" placeholder="E.g ERC 20">
                                                </div>
                                            </div>

                                        </div>
                                        <div>

                                            <hr>

                                        </div>

                                    <?php } ?>

                                    <div class="form-group"><label class="form-label" for="pay-credential">Credentials (Skip For Wechat Pay)</label>
                                        <div class="form-control-wrap"><input type="text" class="form-control"
                                                name="pay-credential" value="<?= isset($address) ? $address : null ?>" placeholder="Wallet Address, PayPal ID..."></div>
                                    </div>

                                    <div class="form-group">

                                        <label class="form-label" for="pay-qr">QR Code (Required for CRYPTO & WECHAT PAY)</label>

                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="pay-qr" accept="image/*">
                                            <label class="custom-file-label" for="pay-qr">Choose file</label>
                                        </div>

                                    </div>

                                    <div class="form-group"><label class="form-label" for="pay-vendor">Vendor (Third-Party)</label>
                                        <div class="form-control-wrap"><input type="text" class="form-control"
                                                name="pay-vendor" value="<?= isset($owner) ? $owner : null ?>" placeholder="Resource Owner"></div>
                                    </div>

                                <?php }
                            
                            ?>

                            <div class="form-group"><button type="submit" class="btn btn-lg btn-primary" id="editResource"><em class="icon ni ni-edit"></em> Edit Resource</button></div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- <div class="col-lg-6">
                <div class="card card-bordered h-100">
                    <div class="card-inner">
                        <div class="card-head">
                            <h5 class="card-title">Add Bank Account Payment</h5>
                        </div>
                        <form method="post" id="bank-resource-form">
                            <div class="form-group"><label class="form-label" for="acc-name">Account Name</label><input
                                    type="text" class="form-control" name="acc-name" required></div>
                            
                            <div class="form-group"><label class="form-label" for="acc-num">Account Number</label><input
                            type="number" class="form-control" name="acc-num" required></div>

                            <div class="form-group"><label class="form-label" for="acc-bank">Bank Name</label><input
                                    type="text" class="form-control" name="acc-bank" required></div>

                            <div class="form-group"><label class="form-label" for="acc-country">Account Name</label><select class="form-control" name="acc-country" required>

                                <option value="0">Select Country</option>

                                <option value="AF" title="Afghanistan">Afghanistan</option>
                                <option value="AX" title="Åland Islands">Åland Islands</option>
                                <option value="AL" title="Albania">Albania</option>
                                <option value="DZ" title="Algeria">Algeria</option>
                                <option value="AS" title="American Samoa">American Samoa</option>
                                <option value="AD" title="Andorra">Andorra</option>
                                <option value="AO" title="Angola">Angola</option>
                                <option value="AI" title="Anguilla">Anguilla</option>
                                <option value="AQ" title="Antarctica">Antarctica</option>
                                <option value="AG" title="Antigua and Barbuda">Antigua and Barbuda</option>
                                <option value="AR" title="Argentina">Argentina</option>
                                <option value="AM" title="Armenia">Armenia</option>
                                <option value="AW" title="Aruba">Aruba</option>
                                <option value="AU" title="Australia">Australia</option>
                                <option value="AT" title="Austria">Austria</option>
                                <option value="AZ" title="Azerbaijan">Azerbaijan</option>
                                <option value="BS" title="Bahamas">Bahamas</option>
                                <option value="BH" title="Bahrain">Bahrain</option>
                                <option value="BD" title="Bangladesh">Bangladesh</option>
                                <option value="BB" title="Barbados">Barbados</option>
                                <option value="BY" title="Belarus">Belarus</option>
                                <option value="BE" title="Belgium">Belgium</option>
                                <option value="BZ" title="Belize">Belize</option>
                                <option value="BJ" title="Benin">Benin</option>
                                <option value="BM" title="Bermuda">Bermuda</option>
                                <option value="BT" title="Bhutan">Bhutan</option>
                                <option value="BO" title="Bolivia">Bolivia, Plurinational State of</option>
                                <option value="BQ" title="Bonaire, Sint Eustatius and Saba">Bonaire, Sint Eustatius and Saba</option>
                                <option value="BA" title="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                <option value="BW" title="Botswana">Botswana</option>
                                <option value="BV" title="Bouvet Island">Bouvet Island</option>
                                <option value="BR" title="Brazil">Brazil</option>
                                <option value="IO" title="British Indian Ocean Territory">British Indian Ocean Territory</option>
                                <option value="BN" title="Brunei Darussalam">Brunei Darussalam</option>
                                <option value="BG" title="Bulgaria">Bulgaria</option>
                                <option value="BF" title="Burkina Faso">Burkina Faso</option>
                                <option value="BI" title="Burundi">Burundi</option>
                                <option value="KH" title="Cambodia">Cambodia</option>
                                <option value="CM" title="Cameroon">Cameroon</option>
                                <option value="CA" title="Canada">Canada</option>
                                <option value="CV" title="Cape Verde">Cape Verde</option>
                                <option value="KY" title="Cayman Islands">Cayman Islands</option>
                                <option value="CF" title="Central African Republic">Central African Republic</option>
                                <option value="TD" title="Chad">Chad</option>
                                <option value="CL" title="Chile">Chile</option>
                                <option value="CN" title="China">China</option>
                                <option value="CX" title="Christmas Island">Christmas Island</option>
                                <option value="CC" title="Cocos (Keeling) Islands">Cocos (Keeling) Islands</option>
                                <option value="CO" title="Colombia">Colombia</option>
                                <option value="KM" title="Comoros">Comoros</option>
                                <option value="CG" title="Congo">Congo</option>
                                <option value="CD" title="Congo, the Democratic Republic of the">Congo, the Democratic Republic of the</option>
                                <option value="CK" title="Cook Islands">Cook Islands</option>
                                <option value="CR" title="Costa Rica">Costa Rica</option>
                                <option value="CI" title="Côte d'Ivoire">Côte d'Ivoire</option>
                                <option value="HR" title="Croatia">Croatia</option>
                                <option value="CU" title="Cuba">Cuba</option>
                                <option value="CW" title="Curaçao">Curaçao</option>
                                <option value="CY" title="Cyprus">Cyprus</option>
                                <option value="CZ" title="Czech Republic">Czech Republic</option>
                                <option value="DK" title="Denmark">Denmark</option>
                                <option value="DJ" title="Djibouti">Djibouti</option>
                                <option value="DM" title="Dominica">Dominica</option>
                                <option value="DO" title="Dominican Republic">Dominican Republic</option>
                                <option value="EC" title="Ecuador">Ecuador</option>
                                <option value="EG" title="Egypt">Egypt</option>
                                <option value="SV" title="El Salvador">El Salvador</option>
                                <option value="GQ" title="Equatorial Guinea">Equatorial Guinea</option>
                                <option value="ER" title="Eritrea">Eritrea</option>
                                <option value="EE" title="Estonia">Estonia</option>
                                <option value="ET" title="Ethiopia">Ethiopia</option>
                                <option value="FK" title="Falkland Islands (Malvinas)">Falkland Islands (Malvinas)</option>
                                <option value="FO" title="Faroe Islands">Faroe Islands</option>
                                <option value="FJ" title="Fiji">Fiji</option>
                                <option value="FI" title="Finland">Finland</option>
                                <option value="FR" title="France">France</option>
                                <option value="GF" title="French Guiana">French Guiana</option>
                                <option value="PF" title="French Polynesia">French Polynesia</option>
                                <option value="TF" title="French Southern Territories">French Southern Territories</option>
                                <option value="GA" title="Gabon">Gabon</option>
                                <option value="GM" title="Gambia">Gambia</option>
                                <option value="GE" title="Georgia">Georgia</option>
                                <option value="DE" title="Germany">Germany</option>
                                <option value="GH" title="Ghana">Ghana</option>
                                <option value="GI" title="Gibraltar">Gibraltar</option>
                                <option value="GR" title="Greece">Greece</option>
                                <option value="GL" title="Greenland">Greenland</option>
                                <option value="GD" title="Grenada">Grenada</option>
                                <option value="GP" title="Guadeloupe">Guadeloupe</option>
                                <option value="GU" title="Guam">Guam</option>
                                <option value="GT" title="Guatemala">Guatemala</option>
                                <option value="GG" title="Guernsey">Guernsey</option>
                                <option value="GN" title="Guinea">Guinea</option>
                                <option value="GW" title="Guinea-Bissau">Guinea-Bissau</option>
                                <option value="GY" title="Guyana">Guyana</option>
                                <option value="HT" title="Haiti">Haiti</option>
                                <option value="HM" title="Heard Island and McDonald Islands">Heard Island and McDonald Islands</option>
                                <option value="VA" title="Holy See (Vatican City State)">Holy See (Vatican City State)</option>
                                <option value="HN" title="Honduras">Honduras</option>
                                <option value="HK" title="Hong Kong">Hong Kong</option>
                                <option value="HU" title="Hungary">Hungary</option>
                                <option value="IS" title="Iceland">Iceland</option>
                                <option value="IN" title="India">India</option>
                                <option value="ID" title="Indonesia">Indonesia</option>
                                <option value="IR" title="Iran, Islamic Republic of">Iran, Islamic Republic of</option>
                                <option value="IQ" title="Iraq">Iraq</option>
                                <option value="IE" title="Ireland">Ireland</option>
                                <option value="IM" title="Isle of Man">Isle of Man</option>
                                <option value="IL" title="Israel">Israel</option>
                                <option value="IT" title="Italy">Italy</option>
                                <option value="JM" title="Jamaica">Jamaica</option>
                                <option value="JP" title="Japan">Japan</option>
                                <option value="JE" title="Jersey">Jersey</option>
                                <option value="JO" title="Jordan">Jordan</option>
                                <option value="KZ" title="Kazakhstan">Kazakhstan</option>
                                <option value="KE" title="Kenya">Kenya</option>
                                <option value="KI" title="Kiribati">Kiribati</option>
                                <option value="KP" title="Korea, Democratic People's Republic of">Korea, Democratic People's Republic of</option>
                                <option value="KR" title="Korea, Republic of">Korea, Republic of</option>
                                <option value="KW" title="Kuwait">Kuwait</option>
                                <option value="KG" title="Kyrgyzstan">Kyrgyzstan</option>
                                <option value="LA" title="Lao People's Democratic Republic">Lao People's Democratic Republic</option>
                                <option value="LV" title="Latvia">Latvia</option>
                                <option value="LB" title="Lebanon">Lebanon</option>
                                <option value="LS" title="Lesotho">Lesotho</option>
                                <option value="LR" title="Liberia">Liberia</option>
                                <option value="LY" title="Libya">Libya</option>
                                <option value="LI" title="Liechtenstein">Liechtenstein</option>
                                <option value="LT" title="Lithuania">Lithuania</option>
                                <option value="LU" title="Luxembourg">Luxembourg</option>
                                <option value="MO" title="Macao">Macao</option>
                                <option value="MG" title="Madagascar">Madagascar</option>
                                <option value="MW" title="Malawi">Malawi</option>
                                <option value="MY" title="Malaysia">Malaysia</option>
                                <option value="MV" title="Maldives">Maldives</option>
                                <option value="ML" title="Mali">Mali</option>
                                <option value="MT" title="Malta">Malta</option>
                                <option value="MH" title="Marshall Islands">Marshall Islands</option>
                                <option value="MQ" title="Martinique">Martinique</option>
                                <option value="MR" title="Mauritania">Mauritania</option>
                                <option value="MU" title="Mauritius">Mauritius</option>
                                <option value="YT" title="Mayotte">Mayotte</option>
                                <option value="MX" title="Mexico">Mexico</option>
                                <option value="FM" title="Micronesia, Federated States of">Micronesia, Federated States of</option>
                                <option value="MD" title="Moldova, Republic of">Moldova, Republic of</option>
                                <option value="MC" title="Monaco">Monaco</option>
                                <option value="MN" title="Mongolia">Mongolia</option>
                                <option value="ME" title="Montenegro">Montenegro</option>
                                <option value="MS" title="Montserrat">Montserrat</option>
                                <option value="MA" title="Morocco">Morocco</option>
                                <option value="MZ" title="Mozambique">Mozambique</option>
                                <option value="MM" title="Myanmar">Myanmar</option>
                                <option value="NA" title="Namibia">Namibia</option>
                                <option value="NR" title="Nauru">Nauru</option>
                                <option value="NP" title="Nepal">Nepal</option>
                                <option value="NL" title="Netherlands">Netherlands</option>
                                <option value="NC" title="New Caledonia">New Caledonia</option>
                                <option value="NZ" title="New Zealand">New Zealand</option>
                                <option value="NI" title="Nicaragua">Nicaragua</option>
                                <option value="NE" title="Niger">Niger</option>
                                <option value="NG" title="Nigeria">Nigeria</option>
                                <option value="NU" title="Niue">Niue</option>
                                <option value="NF" title="Norfolk Island">Norfolk Island</option>
                                <option value="MP" title="Northern Mariana Islands">Northern Mariana Islands</option>
                                <option value="NO" title="Norway">Norway</option>
                                <option value="OM" title="Oman">Oman</option>
                                <option value="PK" title="Pakistan">Pakistan</option>
                                <option value="PW" title="Palau">Palau</option>
                                <option value="PS" title="Palestine, State of">Palestine, State of</option>
                                <option value="PA" title="Panama">Panama</option>
                                <option value="PG" title="Papua New Guinea">Papua New Guinea</option>
                                <option value="PY" title="Paraguay">Paraguay</option>
                                <option value="PE" title="Peru">Peru</option>
                                <option value="PH" title="Philippines">Philippines</option>
                                <option value="PN" title="Pitcairn">Pitcairn</option>
                                <option value="PL" title="Poland">Poland</option>
                                <option value="PT" title="Portugal">Portugal</option>
                                <option value="PR" title="Puerto Rico">Puerto Rico</option>
                                <option value="QA" title="Qatar">Qatar</option>
                                <option value="RE" title="Réunion">Réunion</option>
                                <option value="RO" title="Romania">Romania</option>
                                <option value="RU" title="Russian Federation">Russian Federation</option>
                                <option value="RW" title="Rwanda">Rwanda</option>
                                <option value="BL" title="Saint Barthélemy">Saint Barthélemy</option>
                                <option value="SH" title="Saint Helena, Ascension and Tristan da Cunha">Saint Helena, Ascension and Tristan da Cunha</option>
                                <option value="KN" title="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                <option value="LC" title="Saint Lucia">Saint Lucia</option>
                                <option value="MF" title="Saint Martin (French part)">Saint Martin (French part)</option>
                                <option value="PM" title="Saint Pierre and Miquelon">Saint Pierre and Miquelon</option>
                                <option value="VC" title="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
                                <option value="WS" title="Samoa">Samoa</option>
                                <option value="SM" title="San Marino">San Marino</option>
                                <option value="ST" title="Sao Tome and Principe">Sao Tome and Principe</option>
                                <option value="SA" title="Saudi Arabia">Saudi Arabia</option>
                                <option value="SN" title="Senegal">Senegal</option>
                                <option value="RS" title="Serbia">Serbia</option>
                                <option value="SC" title="Seychelles">Seychelles</option>
                                <option value="SL" title="Sierra Leone">Sierra Leone</option>
                                <option value="SG" title="Singapore">Singapore</option>
                                <option value="SX" title="Sint Maarten (Dutch part)">Sint Maarten (Dutch part)</option>
                                <option value="SK" title="Slovakia">Slovakia</option>
                                <option value="SI" title="Slovenia">Slovenia</option>
                                <option value="SB" title="Solomon Islands">Solomon Islands</option>
                                <option value="SO" title="Somalia">Somalia</option>
                                <option value="ZA" title="South Africa">South Africa</option>
                                <option value="GS" title="South Georgia and the South Sandwich Islands">South Georgia and the South Sandwich Islands</option>
                                <option value="SS" title="South Sudan">South Sudan</option>
                                <option value="ES" title="Spain">Spain</option>
                                <option value="LK" title="Sri Lanka">Sri Lanka</option>
                                <option value="SD" title="Sudan">Sudan</option>
                                <option value="SR" title="Suriname">Suriname</option>
                                <option value="SJ" title="Svalbard and Jan Mayen">Svalbard and Jan Mayen</option>
                                <option value="SZ" title="Swaziland">Swaziland</option>
                                <option value="SE" title="Sweden">Sweden</option>
                                <option value="CH" title="Switzerland">Switzerland</option>
                                <option value="SY" title="Syrian Arab Republic">Syrian Arab Republic</option>
                                <option value="TW" title="Taiwan, Province of China">Taiwan, Province of China</option>
                                <option value="TJ" title="Tajikistan">Tajikistan</option>
                                <option value="TZ" title="Tanzania, United Republic of">Tanzania, United Republic of</option>
                                <option value="TH" title="Thailand">Thailand</option>
                                <option value="TL" title="Timor-Leste">Timor-Leste</option>
                                <option value="TG" title="Togo">Togo</option>
                                <option value="TK" title="Tokelau">Tokelau</option>
                                <option value="TO" title="Tonga">Tonga</option>
                                <option value="TT" title="Trinidad and Tobago">Trinidad and Tobago</option>
                                <option value="TN" title="Tunisia">Tunisia</option>
                                <option value="TR" title="Turkey">Turkey</option>
                                <option value="TM" title="Turkmenistan">Turkmenistan</option>
                                <option value="TC" title="Turks and Caicos Islands">Turks and Caicos Islands</option>
                                <option value="TV" title="Tuvalu">Tuvalu</option>
                                <option value="UG" title="Uganda">Uganda</option>
                                <option value="UA" title="Ukraine">Ukraine</option>
                                <option value="AE" title="United Arab Emirates">United Arab Emirates</option>
                                <option value="GB" title="United Kingdom">United Kingdom</option>
                                <option value="US" title="United States of America">United States of America</option>
                                <option value="UM" title="United States Minor Outlying Islands">United States Minor Outlying Islands</option>
                                <option value="UY" title="Uruguay">Uruguay</option>
                                <option value="UZ" title="Uzbekistan">Uzbekistan</option>
                                <option value="VU" title="Vanuatu">Vanuatu</option>
                                <option value="VE" title="Venezuela, Bolivarian Republic of">Venezuela, Bolivarian Republic of</option>
                                <option value="VN" title="Viet Nam">Viet Nam</option>
                                <option value="WF" title="Wallis and Futuna">Wallis and Futuna</option>
                                <option value="EH" title="Western Sahara">Western Sahara</option>
                                <option value="YE" title="Yemen">Yemen</<option>
                                <option value="ZM" title="Zambia">Zambia</option>
                                <option value="ZW" title="Zimbabwe">Zimbabwe</option>

                            </select></div>

                            <div class="row my-2">

                                <div class="col-md-6">
                                    <div class="form-group">
                                    <label class="form-label" for="acc-iban">IBAN</label><input
                                    type="text" class="form-control" name="acc-iban">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label" for="acc-routing">Routing Number</label><input
                                        type="text" class="form-control" name="acc-routing">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                    <label class="form-label" for="acc-sort">Sorting Code</label><input
                                    type="text" class="form-control" name="acc-sort">
                                    </div>
                                </div>

                            </div>

                            <div class="form-group"><button type="submit" class="btn btn-lg btn-primary" id="bankResource"><em class="icon ni ni-plus"></em> Add Bank Account</button></div>

                        </form>
                    </div>
                </div>
            </div> -->
        </div>
    </div>

</div><!-- .components-preview -->

<?php

    require('utility/partials/footer.php');

?>