<?php 

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Account Requests.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="deposits" class="btn btn-success"><span>Deposits</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
               

                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">#</span></th>

                        <th class="nk-tb-col"><span class="sub-text">User</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Details</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Type</span></th>

                        <th class="nk-tb-col nk-tb-col-tools"><span class="sub-text"></span></th>

                    </tr>
                </thead>
                <tbody>

                    <?php
                        
                        // Get Payments

                        $found = false; // Flag

                        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname`, CASE WHEN `B`.`user_id` IS NOT NULL THEN NULL ELSE 'NOT FOUND' END AS `user_type` FROM `requests` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` ORDER BY `A`.`id`"); // Prepare Statement

                        mysqli_stmt_execute($stmt); // Execute Statement

                        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                            $found = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($stmt); // Close Statement

                        // Check Flag

                        if ($found) {

                            // Iterate Through Data

                            $i = 0;

                            foreach ($data as $row):

                                $i++;

                                $id = $row['id'];

                                $userClass = $row['user_type'];

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $currency = $row['identifier'];

                                $type = $row['details'];

                                $user = $row['user_id'];

                            ?>
                            
                            <tr class="nk-tb-item">
                                <td class="nk-tb-col tb-col-mb">
                                    <span class="tb-amount">
                                        <?= $i ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $name ?>
                                            </span>
                                            <span>
                                                <?= $userClass ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-lg" data-order="35040.34">
                                    <span class="tb-amount">
                                        <?= $type . ' ' . $currency . ' Account' ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $currency . ' Account' ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>

                                <td class="nk-tb-col nk-tb-col-tools text-right">
                                    <form method="post" class="request-mgmt-form">
                                        <input type="hidden" name="request-id" value="<?= $id ?>">
                                        <ul class="nk-tb-actions gx-1">
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="approve" value="APPROVE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Approve Request">
                                                    <em class="icon ni ni-check text-success"></em>
                                                </button>
                                            </li>
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="decline" value="DECLINE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Decline Request">
                                                    <em class="icon ni ni-na text-danger"></em>
                                                </button>
                                            </li>
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="decline" value="DELETE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Delete Request">
                                                    <em class="icon ni ni-trash text-danger"></em>
                                                </button>
                                            </li>
                                        </ul>
                                    </form>
                                </td>
                            </tr>

                            <?php endforeach;

                        }
                    
                    ?>
                                
                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->

</div>

<?php 

    require('utility/partials/footer.php');

?>