<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Security Settings.</h4>
                        <div class="nk-block-des">
                            <p>
                               Maintenance mode: <?= (M_MODE == 'ON') ? '<span class="text-success">ACTIVATED</span>' : '<span class="text-danger">DEACTIVATED</span>' ?> 
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><button id="toggle-mMode" class="btn btn-warning text-white" data-toggle="modal" data-target="#m-mode-modal"><span>Maintenance Mode</span> <em
                                        class="icon ni ni-lock"></em></button></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="title nk-block-title">Security Settings</h4>
                <div class="nk-block-des">
                    <p>Set Black List.</p>
                </div>
            </div>
        </div>
        <div class="card card-bordered">
            <div class="card-inner">
                <div class="card-head">
                    <h5 class="card-title">Filter Poentital / Suspected Security Threats</h5>
                </div>
                <form class="gy-3" id="blackListForm" method="post">
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="threat-1">Threat Case 1</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= THREAT_1 ?>"
                                        name="threat-1">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="threat-2">Threat Case 2</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= THREAT_2 ?>"
                                        name="threat-2">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="threat-3">Threat Case 3</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= THREAT_3 ?>"
                                        name="threat-3">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="threat-4">Threat Case 4</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= THREAT_4 ?>"
                                        name="threat-4">
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>
                    
                    <div class="row g-3">
                        <div class="col-lg-7 offset-lg-5">
                            <div class="form-group mt-2">
                                <button type="submit" class="btn btn-lg btn-primary" id="updateBlacklist" onclick="return confirm('Have you confirmed the information?')">Update</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- card -->

        <div class="card card-bordered">
            <div class="card-inner">
                <div class="card-head">
                    <h5 class="card-title">Reset Security Key</h5>
                </div>
                <form class="gy-3" id="securityKeyForm" method="post" autocomplete="off">
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="current-key">Current Security Key</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" name="current-key" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="new-key">New Security Key</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" minlength="8"
                                        name="new-key" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="confirm-key">Confirm Security Key</label>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control"
                                        name="confirm-key" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>
                    
                    <div class="row g-3">
                        <div class="col-lg-7 offset-lg-5">
                            <div class="form-group mt-2">
                                <button type="submit" class="btn btn-lg btn-primary" id="resetKey" onclick="return confirm('Have you confirmed the information?')">Update</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- card -->

    </div><!-- .nk-block -->

    <!-- MODAL: Maintenance Mode PIN -->

    <div class="modal fade" tabindex="-1" role="dialog" id="m-mode-modal">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <a class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                <div class="modal-body modal-body-lg">
                    <h5 class="title"><?= (M_MODE == 'ON') ? 'Deactivate ' : 'Activate ' ?>Maintenance Mode</h5>

                    <form method="post" id="m-mode-form" autocomplete="off">

                        <div class="row gy-4">

                            <div class="col-12">

                                <div class="form-group">

                                    <label for="m-pin">Enter Security Key</label>

                                    <input type="text" name="m-pin" class="form-control form-control-lg" required>

                                </div>

                            </div>

                            <div class="col-12">

                                <ul class="justify-center align-center flex-wrap flex-sm-nowrap gx-4 gy-2">

                                    <li>
                                        
                                        <button type="submit" id="m-mode-toggle" class="btn btn-lg btn-primary">Validate</button>

                                    </li>

                                    <li>
                                        
                                        <button class="btn btn-lg btn-danger" data-dismiss="modal">Close</button>

                                    </li>

                                </ul>

                            </div>

                        </div>

                    </form>
                    
                </div><!-- .modal-body -->
            </div><!-- .modal-content -->
        </div><!-- .modal-dialog -->
    </div><!-- .modal -->

</div>

<?php

    require('utility/partials/footer.php');

?>