<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">SMTP Settings.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a id="test-mail" class="btn btn-warning text-white"><span>Test Email</span> <em class="icon ni ni-mail"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>


    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="title nk-block-title">Email configuration</h4>
                <div class="nk-block-des">
                </div>
            </div>
        </div>
        <div class="card card-bordered">
            <div class="card-inner">
                <div class="card-head">
                    <h5 class="card-title">Email Setting</h5>
                </div>
                <form class="gy-3" id="mail-settings-form" method="post" enctype="multipart/form-data">
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="site-name">Header Logo</label>
                                <span class="form-note">Specify the logo That will apear at the header of every outgoing
                                    email sent through your website. Should have Dark or preferrably grey colored lettering and transparent
                                    background</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div id="mainLogo">
                                <img src="<?= MAIL_LOGO ?>" width="300" height="80">
                            </div>
                            <p></p>
                            <div class="form-control-wrap" style="max-width: 300px;">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="mail-logo" accept="image/*"
                                        id="customFile">
                                    <label class="custom-file-label" for="customFile">Choose file</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="smtp-host">SMTP host</label>
                                <span class="form-note">Specify your smtp Host. (e.g gmail.com)</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= SMTP_HOST ?>" name="smtp-host" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="smtp-username">Username</label>
                                <span class="form-note">Specify the username of your SMTP. (eg.
                                    admin@example.com).</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= SMTP_USER ?>" name="smtp-username" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="smtp-password">Password</label>
                                <span class="form-note">Specify the password of your SMTP.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control"
                                        value="<?= SMTP_KEY ?>" name="smtp-password" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">SMTP</label>
                                <span class="form-note">SMTP authentication (TLS/SSL).</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <select class="form-control" name="smtp-auth">

                                        <option value="TLS" <?= (SMTP_AUTH == 'TLS') ? ' selected' : null ?>>TLS</option>

                                        <option value="SSL" <?= (SMTP_AUTH == 'SSL') ? ' selected' : null ?>>SSL</option>

                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Port</label>
                                <span class="form-note">Specify your smtp port.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="number" class="form-control" value="<?= SMTP_PORT ?>" name="smtp-port">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Display Name</label>
                                <span class="form-note">Specify the Name that your mail will be displayed with.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" value="<?= MAIL_PARTY ?>" name="mail-name" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Contact Email</label>
                                <span class="form-note">Specify the email address for contact.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="email" class="form-control" value="<?= CONTACT_MAIL ?>" name="mail-contact" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Complaint Email</label>
                                <span class="form-note">Specify the email address for complaints (optional).</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="email" class="form-control" value="<?= COMPLAINT_MAIL ?>" name="mail-complaint">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Support Email</label>
                                <span class="form-note">Specify the email address for support (optional).</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="email" class="form-control" value="<?= SUPPORT_MAIL ?>" name="mail-support">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3">
                        <div class="col-lg-7 offset-lg-5">
                            <div class="form-group mt-2">
                                <button type="submit" class="btn btn-lg btn-primary" id="update-mail-settings">Update</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- card -->
    </div><!-- .nk-block -->

</div>

<?php

    require('utility/partials/footer.php');

?>