<?php 

    require('utility/partials/header.php');

    if (!isset($_REQUEST['id']) || empty($_REQUEST['id'])) {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid URL Parameter",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    } 

    $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

    $thirdParty = thirdPartyData($id, $conn); // Get User Data

    if (!$thirdParty) {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Third party user not found!",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal"><i><?= join(' ', [$thirdParty['firstname'], $thirdParty['middlename'], $thirdParty['lastname']]) ?></i> Transactions.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="user-details?id=<?= $thirdParty['main-user'] ?>" class="btn btn-warning"><span>See Main User</span> <em
                                        class="icon ni ni-user"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
                        <th class="nk-tb-col"><span class="sub-text">#</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Ref Number</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Initiator</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Amount</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Description</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Type</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Scope</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>

                    </tr>
                </thead>
                <tbody>

                    <?php
                    
                        // Get All Transactions

                        $foundTransc = false; // Flag 

                        $transactions = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname` FROM `transactions` AS `A` JOIN `third_party` AS `B` ON `A`.`user_id` = `B`.`tp_id` WHERE `A`.`user_id` = ? ORDER BY `A`.`date` DESC"); // Prepare Statement

                        mysqli_stmt_bind_param($transactions, "s", $id); // Bind Parameter(s) 

                        mysqli_stmt_execute($transactions); // Execute Statement

                        $resultTrans = mysqli_stmt_get_result($transactions); // Get Statement Result

                        if (mysqli_num_rows($resultTrans) > 0) { // Compare Result Mass

                            $foundTransc = true; // Update Flag

                            $data = mysqli_fetch_all($resultTrans, MYSQLI_ASSOC);

                        }

                        mysqli_free_result($resultTrans); // Free Result

                        mysqli_stmt_close($transactions); // Close Statement

                        $i = 0;

                        if ($foundTransc) {

                            foreach ($data as $row):

                                $i++;

                                $amount = $row['amount'];

                                $status = $row['status'];

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $desc = $row['descr'];

                                $currency = $row['currency'];

                                $date = $row['date'];

                                $type = $row['type'];

                                $scope = $row['action'];

                                $account = $row['acc_num'];

                                $transId = $row['trans_id'];

                                if ($type == "DEBIT") {

                                    $icon = "wallet-out";
                                    $color = "text-danger";
                                    $sign = "-";

                                } else {
                                    $icon = "wallet-in";
                                    $color = "text-success";
                                    $sign = "+";
                                }
                                    if ($status == 'COMPLETED') {

                                        $status = '<span class="text-success">' . $status . '</span>';

                                    } else if ($status == 'PROCESSING') {

                                        $status = '<span class="text-warning">PENDING</span>';

                                    } else {
                                        
                                        $status = '<span class="text-danger">' . $status . '</span>';
                                    
                                    }

                            ?>    

                                <tr class="nk-tb-item">
                            
                                    <td class="nk-tb-col tb-col-md">
                                        <span>
                                            <?= $i ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col">
                                        <div class="user-card">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $transId ?><span class="dot dot-success d-md-none ml-1"></span>
                                                </span>
                                                <span>
                                                    <?= date('l jS, F, Y (h:i A)', strtotime($date)) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= $name ?>
                                        </span>
                                        <span>
                                            <?= $account ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount <?= $color ?>">
                                            <i class="ni ni-<?= $icon ?>"></si>
                                            <?= $sign . $currSymbol[$currency] .  number_format($amount, 2) ?><span class="currency">
                                                <?= $currency ?>
                                            </span>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <span>
                                            <?= $desc ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-lg" data-order="Email Verified">
                                        <ul class="list-status <?= $color ?>">
                                            <?= $type ?>
                                        </ul>
                                    </td>
                                    <td class="nk-tb-col tb-col-lg">
                                        <span>
                                            <?= $scope ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <?= $status ?>
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <form method="post" class="transc-mgmt-form">
                                            <input type="hidden" name="transc-id" value="<?= $transId ?>">
                                            <ul class="nk-tb-actions gx-1">
                                                <li class="nk-tb-action-hidden">
                                                    <a href="edit-transaction?id=<?= $transId ?>"
                                                        class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                        title="Edit">
                                                        <em class="icon ni ni-edit"></em>
                                                    </a>
                                                </li>
                                                <li class="nk-tb-action-hidden">
                                                    <button type="submit" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete">
                                                        <em class="icon ni ni-trash text-danger"></em>
                                                    </button>
                                                </li>
                                                
                                            </ul>
                                        </form>    
                                    </td>
                                </tr>

                            <?php endforeach;

                        }    
                        
                    ?>
                                
                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->

</div>



<?php

    require('utility/partials/footer.php');

?>