<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Timining Factors</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="investments" class="btn btn-secondary"><span>Investment Plan</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Subscription Timining Factors</h4>
                <div class="nk-block-des">
                    <p>Below is the list of Timining Factors</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Factor</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Duration</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right"></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // Code Flag

                            // Fetch All User's Code
                        
                            $stmt = mysqli_prepare($conn, "SELECT * FROM `timing_factors` ORDER BY `days`"); // Prepare Statement

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; // Counter

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $id = $row['id'];

                                    $name = $row['factor'];

                                    $days = $row['days'] . ' day(s)';

                                    $hours = $row['hours'] . ' hour(s)';

                                ?>    

                                    <tr class="nk-tb-item">
                                     
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $name ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $days ?>
                                                    </span>
                                                    <span>
                                                        <?= $hours ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form method="post" class="timing-mgmt-form">
                                                <input type="hidden" name="factor-id" value="<?= $id ?>">
                                                <ul class="nk-tb-actions gx-1">

                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <!-- <li class="divider"></li> -->
                                                                    <li><button class="btn w-100" type="submit"><em
                                                                                class="icon ni ni-trash text-danger"></em><span>Delete</span></button>
                                                                    </li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-clock"></em> Add Timing Factor</h5>
        </div>
        <form id="timeForm" method="post" autocomplete="off">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-name">Factor</label>
                            <input type="text" class="form-control" id="factor-name" name="factor-name"
                                placeholder="(E.g HOURLY)" required>
                        </div>
                    </div>
                    
                    <div class="col-md-4">

                        <div class="form-group">

                            <label class="form-label" for="duration-type">Timing Type</label>

                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input" value="HOURS" name="duration-type" id="kyc-enable" required>
                                        <label class="custom-control-label" for="kyc-enable">HOURS</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"value="DAYS" name="duration-type" id="kyc-disable">
                                        <label class="custom-control-label" for="kyc-disable">DAYS</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>

                        </div>
                        
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="factor-duration">Duration (DAYS or HOURS)</label>
                            <input type="number" class="form-control" id="factor-duration" name="factor-duration" required>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button onclick="return confirm('Have you confirmed the data?')" type="submit" id="addTime" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>