<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">User Notifications</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><button class="btn btn-secondary" data-toggle="modal" data-target="#new-notification"><span>New Notification</span> <em
                                        class="icon ni ni-bell"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Notifications</h4>
                <div class="nk-block-des">
                    <p>Below is the list of Notifications</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Date</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Title</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Message</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // Flag

                            // Fetch Notifications
                        
                            $stmt = mysqli_prepare($conn, "SELECT * FROM `notifications` WHERE `user_id` = ? ORDER BY `date_created` DESC"); // Prepare Statement

                            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; 

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $notfId = $row['notf_id'];

                                    $date = $row['date_created'];

                                    $title = $row['title'];

                                    $msg = $row['message_text'];

                                    $status = $row['status'];

                                ?>    

                                    <tr class="nk-tb-item">
                                        
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= date('l d M, Y', strtotime($date)) ?></span>
                                            <span><?= $notfId ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $title ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= strlen($msg) > 30 ? substr($msg, 0, 30) . '...' : $msg ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><em class="icon<?= ($status == 'READ') ? ' text-success ni ni-check-circle' : ' text-danger ni ni-alert-circle' ?>"></em> <?= $status ?></span>
                                        </td>
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form method="post" class="notfMgmt">
                                                <input type="hidden" name="notf-id" value="<?= $notfId ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" value="DELETE" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete">
                                                            <em class="icon ni ni-delete text-danger"></em>
                                                        </button>
                                                    </li>


                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li><a href="edit-notification?id=<?= $notfId ?>">
                                                                        <em class="icon ni ni-edit"></em><span>Edit Notification</span></a>
                                                                    </li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <!-- MODAL: New Notification -->

    <div class="modal fade" tabindex="-1" role="dialog" id="new-notification">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <a class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                <div class="modal-body modal-body-lg">
                    <h5 class="title">Notify <?= join(' ', [$userData['firstname'], $userData['lastname']]) ?></h5>

                    <form method="post" id="create-notf-form">

                        <div class="row gy-4">

                            <div class="col-12">

                                <div class="form-group">

                                    <label for="title">Title</label>

                                    <input type="text" name="title" class="form-control form-control-lg" required>

                                    <input type="hidden" name="user" value="<?= isset($id) ? $id : null ?>">

                                </div>

                            </div>

                            <div class="col-12">

                                <div class="form-group">

                                    <label for="msg">Message</label>

                                    <textarea rows="10" name="msg" class="form-control form-control-lg" required></textarea>

                                </div>

                            </div>

                            <div class="col-12">

                                <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">

                                    <li>
                                        
                                        <button type="submit" id="createNotf" class="btn btn-lg btn-primary">Proceed</button>

                                    </li>

                                    <li>
                                        
                                        <button type="reset" class="btn btn-lg btn-danger" data-dismiss="modal">Close</button>

                                    </li>

                                </ul>

                            </div>

                        </div>

                    </form>
                    
                </div><!-- .modal-body -->
            </div><!-- .modal-content -->
        </div><!-- .modal-dialog -->
    </div><!-- .modal -->

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>