<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['account-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($action == 'RESET') {

            $reset = false; // Flag

            $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = ? WHERE `acc_id` = ?"); // Prepare Statement

            $bal = 0.00;

            mysqli_stmt_bind_param($stmt, "ds", $bal, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement
    
                $reset = true; // Update Flag
            
            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['reset' => $reset]); // Encode JSON Response

        } else if ($action == 'DELETE') {

            // Commence Deletion

            $deleted = false; // Flag

            $stmt = mysqli_prepare($conn, "DELETE FROM `accounts` WHERE `acc_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement
    
                $deleted = true; // Update Flag
            
            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

        } else if ($action == 'PRIMARY') {

            $primary = false; // Flag

            $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `class` = CASE WHEN `acc_id` = ? THEN ? ELSE ? END WHERE `user_id` = ?"); // Prepare Statement

            $param = 'PRIMARY';

            $paramB = 'SECONDARY';

            mysqli_stmt_bind_param($stmt, "ssss", $id, $param, $paramB, $user); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $primary = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['primary' => $primary]); // Encode Statement

        }

    }

?>