<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['request-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Flag

        // Fetch Record Data

        $stmt = mysqli_prepare($conn, "SELECT * FROM `requests` WHERE `id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $currency = strtoupper($row['identifier']);

                $user = $row['user_id'];

                $type = $row['details'];

                $date = $row['date'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found && $action != 'DELETE') {

            echo json_encode(['recordError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $userData = userData($user, $conn); // Fetch User Info

        if (!$userData && $action !== 'DECLINE') {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Determine Action

        if ($action == 'APPROVE' || $action == 'DECLINE') {

            // Get Current Datetime

            $datetime = timeGMT();

            // Carry Out Approval / Decline

            if ($action === 'APPROVE') { // Approval
 
                $approved = false; // Flag

                $account = currencyAccountData($currency, $user, $conn); // Locate Account

                if ($account) {

                    echo json_encode(['accExists' => true, 'currency' => $currency]); // Encode JSON Response

                    exit; // End Run

                }

                // Attach Bank

                $bank = null;
                
                $stmt = mysqli_prepare($conn, "SELECT * FROM `banks` WHERE `country` = CASE WHEN EXISTS (SELECT 1 FROM `banks` WHERE `country` = ?) THEN ? ELSE ? END ORDER BY RAND() LIMIT 1;"); // Prepare Statement

                $country = $currCountryCodes[$currency] ?? '';

                $default = 'DEFAULT';

                mysqli_stmt_bind_param($stmt, "sss", $country, $country, $default); // Bind Parameter(s)

                mysqli_stmt_execute($stmt); // Execute Statement

                $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                if (mysqli_num_rows($result) === 1) {

                    while ($row = mysqli_fetch_assoc($result)) {

                        $bank = $row['bank_id'];

                    }

                }

                mysqli_free_result($result); // Free Result

                mysqli_stmt_close($stmt); // Close Statement

                // Commence Data Drop

                $created = false; // Flag

                $stmt = mysqli_prepare($conn, "INSERT INTO `accounts` (`user_id`, `acc_id`, `acc_num`, `currency`, `type`, `bank_id`) VALUES(?, ?, ?, ?, ?, ?)"); // Prepare Statement

                // Parameter(s)

                $accNum = mt_rand(10000000, 999999999);

                $idAcc = generateUniqueID($conn, 'accounts', $currency);

                mysqli_stmt_bind_param($stmt, "ssisss", $user, $idAcc, $accNum, $currency, $type, $bank); // Bind Parameter(s)

                if (mysqli_stmt_execute($stmt)) { // Execute Statement

                    $approved = true; // Flag

                    mysqli_query($conn, "DELETE FROM `requests` WHERE `id` = '$id'");

                }
                
                mysqli_stmt_close($stmt); // Close Statement

                if ($approved) {

                    // Create Notification & Mail

                    $madeOn = date('l, M d Y', strtotime($date));

                    $notf = 'Your request for a/an ' . $currency . ' ' . $type . ' account made on ' . $madeOn . ' has been approved. You now have a/an ' . $currency . ' ' . $type . ' account. Enjoy!';

                    createNotification($conn, $user, 'New Account Alert', $notf);

                    $subject = 'New Account Alert #' . mt_rand(10000000, 99999999);

                    $account = $currency . ' ' . $type;

                    $mail = newAccountAlert($userData['firstname'], $account, $madeOn); // Email Draft

                    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastnmae']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                }

                echo json_encode(['approved' => $approved]); // Encode JSON Response

                exit; // End Run

            } else { // Decline

                $declined = false; // Flag

                $decline = mysqli_prepare($conn, "DELETE FROM `requests` WHERE `id` = ?"); // Prepare Statement
    
                mysqli_stmt_bind_param($decline, "s", $id); // Bind Parameter(s)

                if (mysqli_stmt_execute($decline)) { // Execute Statement

                    $declined = true; // Update Flag

                    // Draft Message

                    // Send Mail

                } 

                mysqli_stmt_close($decline);

                echo json_encode(['declined' => $declined]); // Encode JSON Response

                exit; // End Run

            }

        } else { // Delete Payment Record

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `requests` WHERE `id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }    

    }

?>