<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $name = filter_var(trim($_REQUEST['bank-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var(trim($_REQUEST['bank-country']), FILTER_SANITIZE_SPECIAL_CHARS);

        $branch = filter_var(trim($_REQUEST['bank-branch']), FILTER_SANITIZE_SPECIAL_CHARS);

        $default = isset($_REQUEST['bank-default']) ? true : null;

        $code = !empty($_REQUEST['bank-code']) ? filter_var(trim($_REQUEST['bank-code']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $codeType = filter_var(trim($_REQUEST['code-type']), FILTER_SANITIZE_SPECIAL_CHARS);

        $logo = $_FILES['bank-logo'];

        $logoPath = null;

        $directory = '../../../vault/bank-data/';

        if ($default) {

            $country = 'DEFAULT';

        }

        if ($country == '0' && !$default) {

            echo json_encode(['cntryError' => true]);

            exit;

        }

        if ($codeType == 0) {

            $codeType = null;

        }

        if ($code == null && $codeType) {

            echo json_encode(['codeError' => true]);

            exit;

        }

        if ($codeType == null && $code) {

            echo json_encode(['typeError' => true]);

            exit;

        }

        $logoPath = fileUpload($logo, $directory, 'bnk-', null, true); // Upload Logo

        if (!$logoPath['status']) {

            echo json_encode(['uploadError' => true, 'message' => $logoPath['message']]);

            exit;

        }
        
        $logoPath = $logoPath['vault'];

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `banks` (`bank_id`, `name`, `country`, `logo`, `branch`, `bank_code`, `bank_codetype`) VALUES(?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        $id = generateUniqueID($conn, 'banks', 'BNK-'); // Generate ID

        mysqli_stmt_bind_param($stmt, "sssssss", $id, $name, $country, $logoPath, $branch, $code, $codeType); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement


        if (!$created) {

            deleteFile($logoPath);

        }

        echo json_encode(['bankAdded' => $created]);

    }

?>