<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        $created = false; // Creation Flag

        // Sanitize Fields

        $number = filter_var(trim($_REQUEST['acc-num']), FILTER_SANITIZE_SPECIAL_CHARS);

        $name = filter_var(trim($_REQUEST['acc-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $bank = filter_var(trim($_REQUEST['acc-bank']), FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var(trim($_REQUEST['acc-country']), FILTER_SANITIZE_SPECIAL_CHARS);

        $iban = !empty($_REQUEST['acc-iban']) ? filter_var(trim($_REQUEST['acc-iban']), FILTER_SANITIZE_SPECIAL_CHARS) : null;
        
        $routing = !empty($_REQUEST['acc-routing']) ? filter_var(trim($_REQUEST['acc-routing']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $swift = !empty($_REQUEST['acc-swift']) ? filter_var(trim($_REQUEST['acc-swift']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $sorting = !empty($_REQUEST['acc-sort']) ? filter_var(trim($_REQUEST['acc-sort']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        // Perform Validation Checks

        if ($country == 0) {

            echo json_encode(['cntryError' => true]);

            exit;

        }

        // Intiate Data Drop

        $type = 'BANK';

        $stmt = mysqli_prepare($conn, "INSERT INTO `pay_resources` (`type`, `resource_name`, `bank_name`, `resource_attr`, `country_code`, `sorting`, `routing`, `swift`, `iban`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssss", $type, $name, $bank, $number, $country, $sorting, $routing, $swift, $iban);

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['created' => $created]);

    }

?>