<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $type = filter_var(trim($_REQUEST['pay-type']), FILTER_SANITIZE_SPECIAL_CHARS);

        $name = filter_var(trim($_REQUEST['pay-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $symbol = !empty($_REQUEST['name-abbr']) ? filter_var(trim($_REQUEST['name-abbr']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $cred = !empty($_REQUEST['pay-credential']) ? filter_var(trim($_REQUEST['pay-credential']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $network = !empty($_REQUEST['network-type']) ? filter_var(trim($_REQUEST['network-type']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $thirdParty = !empty($_REQUEST['pay-vendor']) ? filter_var(trim($_REQUEST['pay-vendor']), FILTER_SANITIZE_SPECIAL_CHARS) : null;
        
        $qrcode = !empty($_FILES['pay-qr']['name']) ? $_FILES['pay-qr'] : null;

        $qrPath = null;

        $directory = '../../../vault/qr-codes/';

        $preference = null;

        // Perform Validation Checks

        if ($type == 0) {

            echo json_encode(['typeError' => true]);

            exit;

        }

        if (empty($cred) && $type != 'WECHAT PAY') {

            echo json_encode(['credError' => true]);

            exit;

        }

        if ($type == 'CRYPTO' && !$symbol) {

            echo json_encode(['symbError' => true]);

            exit;

        }

        if ($qrcode == null && ($type == 'CRYPTO' || $type == 'WECHAT PAY')) {

            echo json_encode(['qrError' => true]);

            exit;

        }

        // Set Defaults

        if ($type == 'CRYPTO') {

            if ($symbol == 'BTC') {

                $preference = 10;

            } else if ($symbol == 'ETH') {

                $preference = 9;

            } else if ($symbol == 'USDT') {

                $preference = 8;

            } else if ($symbol == 'SOL') {

                $preference = 7;

            }

        } else if ($type == 'APPLE PAY') {

            $name = 'Apple Pay';

        } else if ($type == 'GOOGLE PAY') {

            $name = 'Google Pay';

        } else if ($type == 'PAYPAL') {

            $name = 'PayPal';

        } else if ($type == 'VENMO') {

            $name = 'Venmo';

        } else if ($type == 'ZELLE') {

            $name = 'Zelle';

        } else if ($type == 'CASHAPP') {

            $name = 'Cash App';

        } else if ($type == 'WECHAT PAY') {

            $name = 'WeChat Pay';

        } else if ($type == 'REVOLUT') {

            $name = 'Revolut';

        } else if ($type == 'ALI PAY') {

            $name = 'Alipay';

        }

        // Handle QR Code Upload

        if ($qrcode) {

            $qrPath = fileUpload($qrcode, $directory, 'qr', null, true);

            if ($qrPath['status']) {

                $qrPath = $qrPath['vault'];

            } else {

                echo json_encode(['uploadError' => true, 'msg' => $qrPath['message']]);

                exit;

            }

        }

        // Drop Data

        $stmt = mysqli_prepare($conn, "INSERT INTO `pay_resources` (`type`, `resource_name`, `resource_symbol`, `resource_attr`, `resource_qrcode`, `network_type`, `vendor_name`) VALUES(?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssss", $type, $name, $symbol, $cred, $qrPath, $network, $thirdParty); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement
        
        echo json_encode(['created' => $created]); // Encode JSON Response

    }

    

?>