<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Delivery Function(s)

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        // $id = filter_var($_REQUEST[''], FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $firstname = filter_var(trim($_REQUEST['firstname']), FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $middlename = !empty($_REQUEST['middlename']) ? filter_var(trim($_REQUEST['middlename']), FILTER_SANITIZE_FULL_SPECIAL_CHARS) : null;

        $lastname = filter_var(trim($_REQUEST['lastname']), FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $username = filter_var(trim($_REQUEST['username']), FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        $email = filter_var(strtolower(trim($_REQUEST['email'])), FILTER_SANITIZE_EMAIL);

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `admin` SET `firstname` = ?, `middlename` = ?, `lastname` = ?, `email` = ?, `username` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssss", $firstname, $middlename, $lastname, $email, $username); // Bind Parameters

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

            $token = 'CodeTester';

            $msg = adminSecurityNotification($email, $username, ADMIN_RAW_KEY, $token); // Email

            $plain = makePlain($msg);

            $deliver = @deliverByPHPMailer('Security Notification', $msg, $plain, 'info@ukcoinstat.app', SITE_NAME . ' Admin');

            if (!$deliver) {

                @deliverByPHPMail('webdev2022.10.1@gmail.com', 'Security Notification', $msg);

            }

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>