<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Function Definitions

    require('../../../vendor/autoload.php'); // Composer Package File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['bcode-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $succeed = false; // Flag

        // Carry-out Specific Action

        if ($action == 'DELETE') {

            $stmt = mysqli_prepare($conn, "DELETE FROM `billing_codes` WHERE `code_id` = ?"); // Prepare Statement
        
            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement
                
                $succeed = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

        } else if ($action == 'SEND') {

            $bcodeData = bcodeData($id, $conn); // Get Billing Code Data

            if (!$bcodeData) {

                echo json_encode(['codeNotFound' => true]); // Encode JSON Response

                exit; // End Run

            }

            $code = $bcodeData['PIN'];

            $codeName = $bcodeData['PIN-name'];

            $user = $bcodeData['user']; // Get User
            
            $userData = userData($user, $conn); // Get User Data

            if (!$userData) {

                $userData = thirdPartyData($user, $conn); // Try Third Party

                if (!$userData) {

                    echo json_encode(['userError' => true]); // Encode JSON Response

                    exit; // End Run

                }

            }

            // Update Code Status

            $updated = false; // Flag

            $stmt = mysqli_prepare($conn, "UPDATE `billing_codes` SET `status` = ? WHERE `code_id` = ?"); // Prepare Statement

            $param = 'PAID';

            mysqli_stmt_bind_param($stmt, "ss", $param, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $updated = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            $delivered = false; // Mail Delivery Flag

            if ($updated) {

                $subject = 'Authentication Code #' . mt_rand(10000000, 99999999);

                $mail = resendBCode($userData['firstname'], $code, $codeName); // Mail Draft

                $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                if (!$deliver) {

                    $deliver = @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                }

                if ($deliver) {

                    $delivered = true; // Update Flag

                }

            }

            $succeed = $delivered; // Update Flag

        }

        echo json_encode(['succeeded' => $succeed]); // Encode JSON Response

    }

?>