<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $fname = filter_var($_REQUEST['firstname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['middlename']) ? filter_var($_REQUEST['middlename'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['lastname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $email = filter_var(strtolower(trim($_REQUEST['email'])), FILTER_SANITIZE_EMAIL);

        $dob = sanitizeDate($_REQUEST['dob']);

        $password = $_REQUEST['password'];

        $key = md5($password); // Encrypt Password

        $type = filter_var($_REQUEST['acc-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $balance = !empty($_REQUEST['acc-bal']) ? filter_var($_REQUEST['acc-bal'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : 0.00;

        $auth = filter_var($_REQUEST['auth-factor'], FILTER_SANITIZE_SPECIAL_CHARS);

        $notify = isset($_REQUEST['notify']) ? true : false;

        // Check Fields

        if ($type == 0) {

            echo json_encode(['typeEmpty' => true]);

            exit;

        }

        if ($currency == 0) {

            echo json_encode(['currEmpty' => true]);

            exit;

        }

        $inUse = false; // Flag

        // Check Email

        $checkEmail = emailExists($email, $conn);

        if ($checkEmail) {

            echo json_encode(['emailError' => true]);

            exit;

        }

        $userCreated = false; // Flag

        // Generate IDs

        $user = generateUniqueID($conn, 'users', 'USR');

        $acc = generateUniqueID($conn, 'accounts', $currency);

        $accNum = mt_rand(10000000, 999999999);

        // Create User & Account

        $createUser = mysqli_prepare($conn, "INSERT INTO `users` (`user_id`, `fname`, `mname`, `lname`, `email`, `dob`, `pre_hash`, `password`, `factor_2FA`, `reg_by`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        // Param

        $regBy = 'ADMIN';

        mysqli_stmt_bind_param($createUser, "ssssssssss", $user, $fname, $mname, $lname, $email, $dob, $password, $key, $auth, $regBy); // Bind Parameter(s)

        $createAcc = mysqli_prepare($conn, "INSERT INTO `accounts` (`acc_id`, `user_id`, `acc_num`, `currency`, `balance`, `type`, `class`) VALUES(?, ?, ?, ?, ?, ?, ?)"); // Prpepare 
        
        $primary = 'PRIMARY';

        mysqli_stmt_bind_param($createAcc, "ssisdss", $acc, $user, $accNum, $currency, $balance, $type, $primary); // Bind Parameter(s)

        if (mysqli_stmt_execute($createUser) && mysqli_stmt_execute($createAcc)) { // Execute Statements

            $userCreated = true; // Update Flag

        }

        // Close Statements

        mysqli_stmt_close($createUser);

        mysqli_stmt_close($createAcc);

        if ($userCreated && $notify) {

            // Send Email (Optional)

            $subject = 'Welcome Aboard!';

            $mail = partialReg($fname, $email, $password);

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $email, join(' ', [$fname, $lname]));

            if (!$deliver) {

                @deliverByPHPMail($email, $subject, $mail); // Fallback

            }

        }

        echo json_encode(['userAdded' => $userCreated, 'id' => $user]); // Encode JSON Response

    }

?>