<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Function File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user'], FILTER_SANITIZE_SPECIAL_CHARS);

        $provider = filter_var($_REQUEST['card-provider'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var($_REQUEST['card-currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $balance = !empty($_REQUEST['card-balance']) ? filter_var($_REQUEST['card-balance'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : 0;

        $color = isset($_REQUEST['radomize-color']) ? generateRGB() : filter_var($_REQUEST['card-color'], FILTER_SANITIZE_SPECIAL_CHARS);

        $expires = !empty($_REQUEST['card-expires']) ? $_REQUEST['card-expires'] : null;
         
        $fund = filter_var($_REQUEST['card-fund'], FILTER_SANITIZE_SPECIAL_CHARS);

        // $charge = ; // Decide To Include Card Charges

        // $notify = ; // Send Email Probably

        // Due Update: Check For Account, Card Limit, Previous Cards

        $userData = userData($user, $conn); // Get User's Info

        if (!$userData) {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Format Date

        if ($expires) {

            $date = new DateTime($expires);

        } else {

            $duration = 1095; // 3 years (in days)

            $expires = strtotime("+$duration days"); // 3 years from now

            $date = new DateTime();
            $date->setTimestamp($expires);

        }

        // Move to the last day of the month
        $date->modify('last day of this month');

        $expires = $date->format('Y-m-d');

        $cardID = generateUniqueID($conn, 'virtual_cards', 'VRT'); // Generate ID

        $cardNum = generateCardNumber($provider);

        $cvv = generateCVV();

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `virtual_cards` (`user_id`, `card_id`, `currency`, `provider`, `card_number`, `cvv`, `expires`, `fund_by`, `color`, `balance`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (For Card Creation)

        mysqli_stmt_bind_param($stmt, "ssssiisssd", $user, $cardID, $currency, $provider, $cardNum, $cvv, $expires, $fund, $color, $balance); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['created' => $created]); // Encode JSON Response

    }

?>