<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $account = filter_var($_REQUEST['account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $description = !empty($_REQUEST['descr']) ? filter_var($_REQUEST['descr'], FILTER_SANITIZE_SPECIAL_CHARS) : '-';

        $date = !empty($_REQUEST['date']) ? sanitizeDateTime($_REQUEST['date']) : null;

        // $mail = isset($_REQUEST['notify']) ? true : false; For Email Notification

        // Check Amount

        if ($amount < 0) {

            echo json_encode(['amtError' => true]); // Encode JSON Response

            exit;

        }

        $userData = userData($user, $conn); // Get User Data

        $accountData = accountData($account, $user, $conn); // Get Account Data

        if (!$userData || !$accountData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $accNum = $accountData['acc-number'];

        $iniBal = $accountData['balance'];

        $currency = $accountData['currency'];

        $newBal = $iniBal + $amount;

        $transID = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

        // Initiate Data Drop

        $drop = false; // Flag

        $updateAcc = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = ? WHERE `user_id` = ? AND `acc_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($updateAcc, "sss", $newBal, $user, $account); // Bind Parameter(s)

        $createTransc = mysqli_prepare($conn, "INSERT INTO `transactions` (`trans_id`, `user_id`, `date`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`, `status`) VALUES (?, ?, COALESCE(?, CURRENT_TIMESTAMP), ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        // Parameter(s)

        $status = 'COMPLETED';

        $type = 'CREDIT';

        $action = 'MISCELLANOUS';

        mysqli_stmt_bind_param($createTransc, "ssssssssidds", $transID, $user, $date, $type, $action, $description, $currency, $account, $accNum, $newBal, $amount, $status);


        if (mysqli_stmt_execute($updateAcc) && mysqli_stmt_execute($createTransc)) {

            $drop = true; // Update Flag

        }

        // Close Statements

        mysqli_stmt_close($updateAcc);

        mysqli_stmt_close($createTransc);

        echo json_encode(['credited' => $drop]); // Encode JSON Response

    }

?>