<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['dep-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Deposit Flag

        // Fetch Payment Data

        $stmt = mysqli_prepare($conn, "SELECT * FROM `deposits` WHERE `dep_id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $proof = $row['dep_proof'];

                $user = $row['user_id'];

                $amount = $row['amount'];

                $accID = $row['acc_id'];

                $accNum = $row['account'];
                
                $trans = $row['related_transc'];

                $date = $row['dep_time'];

                $currency = $row['currency'];

                $depositDate = date('l, M d Y, (H:i)', strtotime($date));

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement
 
        if (!$found) {

            echo json_encode(['recordError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $thirdParty = false;

        $userData = userData($user, $conn); // Fetch User Info

        if (!$userData) {

            $userData = thirdPartyData($user, $conn); // Fetch User Info (Third Party)

            if ($userData) {

                $thirdParty = true;

            }

        }
 
        if (!$userData && $action !== 'DELETE') {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        if ($action !== 'DELETE') {

            $accOwner = ($thirdParty) ? $userData['main-user'] : $user;

            $accInfo = accountData($accID, $accOwner, $conn); // Locate Account

            if (!$accInfo) {

                echo json_encode(['accError' => true]); // Encode JSON Response

                exit; // End Run

            }

            $balance = $accInfo['balance']; // Get Account Balance

        }

        // $accNum = $accInfo['acc-number']; // Get Account Number (Gets CURRENT Account Number Incase of An Edit)

        // Look For Transaction

        $transcFound = false; // Transaction Flag

        $transaction = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `trans_id` = ? AND `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($transaction, "ss", $trans, $user); // Bind Parameter(s)

        mysqli_stmt_execute($transaction); // Execute Statement

        $result = mysqli_stmt_get_result($transaction); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Compare Result's Mass

            $transcFound = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($transaction); // Close Statement

        // Determine Action

        if ($action == 'APPROVE' || $action == 'DECLINE') {

            // Get Current Datetime

            $datetime = timeGMT();    

            // Carry Out Approval / Decline

            if ($action === 'APPROVE') { // Approval

                $approved = false; // Approval Flag
                
                $newBal = $balance + $amount; // Calculate New Balance

                // Update / Create Transaction & Update Account Balance

                $stmt1 = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = ? WHERE `acc_id` = CAST(? AS BINARY) AND `user_id` = CAST(? AS BINARY)"); // Prepare Statement (For Account Balance Update)

                mysqli_stmt_bind_param($stmt1, "sss", $newBal, $accID, $accOwner); // Bind Statement Parameter(s)

                // Transcation Statement

                $tStatus = 'COMPLETED'; // For Transaction Status

                if ($transcFound) { // For Transaction Update

                    $stmt2 = mysqli_prepare($conn, "UPDATE `transactions` SET `acc_bal` = ?, `status` = ? WHERE `trans_id` = CAST(? AS BINARY) AND `acc_num` = ? AND `user_id` = CAST(? AS BINARY)"); // Prepare Statement

                    mysqli_stmt_bind_param($stmt2, "dssis", $newBal, $tStatus, $trans, $accNum, $user); // Bind Parameter(s)

                } else { // Create Transaction (Highly Unlikely)

                    $stmt2 = mysqli_prepare($conn, "INSERT INTO `transactions` (`date`, `user_id`, `trans_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`, `acc_status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                    // Parameter(s)

                    $transId = generateUniqueID($conn, 'transactions', 'TRN');

                    $action = 'DEPOSIT';

                    $descr = "$action ($currency)";

                    $type = 'CREDIT';

                    mysqli_stmt_bind_param($stmt2, "ssssssssidds", $date, $user, $transId, $type, $action, $descr, $currency,$accID, $accNum, $newBal, $amount, $tStatus); // Bind Parameter(s)

                }

                if (mysqli_stmt_execute($stmt1) && mysqli_stmt_execute($stmt2)) { // Execute Statements

                    $approved = true; // Update Flag

                    mysqli_query($conn, "DELETE FROM `deposits` WHERE `dep_id` = '$id'"); // Delete Deposit Record

                    deleteFile($proof, '../../../'); // Delete Proof

                }

                // Close Statements

                mysqli_stmt_close($stmt1);

                mysqli_stmt_close($stmt2);

                if ($approved) {

                    // Send Email

                    $symbol = $currSymbol[$currency];

                    $subject = 'Deposit Confirmed #' . mt_rand(10000000, 99999999);

                    $msg = depositConfirmation($userData['firstname'], $symbol . number_format($amount, 2), $depositDate, $currency, $symbol . number_format($balance, 2), $symbol . number_format($newBal, 2));

                    $deliver = @deliverByPHPMailer($subject, $msg, makePlain($msg), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $msg); // Fallback

                    }

                    $owned = ($thirdParty) ? null : 'your ';

                    $notf = 'The deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into ' . $owned . $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ')' . ' on ' . $depositDate . ' has been confirmed.';

                    createNotification($conn, $user, 'Deposit Confirmed', $notf); // Notify Initiator

                    if ($thirdParty) {

                        $notf = 'The deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into your ' . $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ') by ' . $userData['firstname'] . ' ' . $userData['lastname'] . ' (JOINT USER)' . ' on ' . $depositDate . ' has been confirmed.';

                        createNotification($conn, $userData['main-user'], 'Third Party Deposit Confirmed', $notf); // Notify Main User

                    }

                }

                echo json_encode(['approved' => $approved]); // Encode JSON Response
                
                exit; // End Run

            } else { // Decline

                $declined = false; // Flag

                $decline = mysqli_prepare($conn, "DELETE FROM `payments` WHERE `pay_id` = ?"); // Prepare Statement
    
                mysqli_stmt_bind_param($decline, "s", $id); // Bind Parameter(s)

                $stmt = mysqli_prepare($conn, "UPDATE `transactions` SET `status` = ?, `acc_bal` = ? WHERE `trans_id` = CAST(? AS BINARY) AND `user_id` = CAST(? AS BINARY)"); // Prepare Statement (For Transaction Status Update)

                // Parameter(s)

                $statusOptions = ['DISPUTED', 'INCOMPLETE'];

                $tStatus = $statusOptions[array_rand($statusOptions)];

                mysqli_stmt_bind_param($stmt, "sdss", $tStatus, $balance, $trans, $user);

                if (mysqli_stmt_execute($decline) && mysqli_stmt_execute($stmt)) { // Execute Statements

                    $declined = true; // Update Flag

                    mysqli_query($conn, "DELETE FROM `deposits` WHERE `dep_id` = '$id'"); // Delete Deposit Record

                    deleteFile($proof, '../../../'); // Delete Proof

                } 

                // Close Statements

                mysqli_stmt_close($decline);

                mysqli_stmt_close($stmt);

                if ($declined) {

                    // Send Email

                    $symbol = $currSymbol[$currency];

                    $owned = ($thirdParty) ? null : 'your ';

                    $notf = 'Your deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into ' . $owned .  $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ')' . ' on ' . $depositDate . ' has been declined. This may be due to but not limited to discrepancies in payment data, insufficient balance, amongst other factors.';

                    createNotification($conn, $user, 'Deposit Declined', $notf); // Notify Initiator

                    if ($thirdParty) {

                        $notf = 'The deposit of ' . $currSymbol[$currency] . number_format($amount, 2) . ' ' . $currency . ' into your ' . $currency . ' account (' . substr($accNum, 0, 4) . '****' . substr($accNum, -3) . ') by ' . $userData['firstname'] . ' ' . $userData['lastname'] . ' (JOINT USER)' . ' on ' . $depositDate . ' has been declined. This may be due to but not limited to discrepancies in payment data, insufficient balance, amongst other factors.';

                        createNotification($conn, $userData['main-user'], 'Third Party Deposit Declined', $notf); // Notify Main User

                    }

                    $subject = 'Deposit Declined #' . mt_rand(10000000, 99999999);

                    $msg = payGatewayDeclined($depositDate, 'DEPOSIT', $currency, 'DECLINED', $symbol . number_format($amount, 200), $id);

                    $deliver = @deliverByPHPMailer($subject, $msg, makePlain($msg), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $msg); // Fallback

                    }

                }

                echo json_encode(['declined' => $declined]); // Encode JSON Response

                exit; // End Run

            }

        } else { // Delete Payment Record

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `deposits` WHERE `dep_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

                deleteFile($proof, '../../../'); // Delete Proof

            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }    

    }

?>