<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup
    
    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol 

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        // Sanitize Field(s)

        $id = filter_var($_REQUEST['acc-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['account-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $number = filter_var($_REQUEST['acc-number'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bankID = ($_REQUEST['bank'] != 0 && !empty($_REQUEST['bank'])) ? filter_var($_REQUEST['bank'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $balance = filter_var($_REQUEST['balance'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $accountData = accountData($id, $user, $conn); // Get Account Data

        if (!$accountData) {

            echo json_encode(['refresh' => true]); // Echo JSON Response

            exit; // End Run

        }

        // Look For Similar Account (Currency)

        $account = currencyAccountData($currency, $user, $conn);

        if ($account && ($currency != $accountData['currency'])) {

            echo json_encode(['accExists' => true, 'currency' => $currency]); // Echo JSON Response

            exit; // End Run

        }

        // Commence Data Drop

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `currency` = ?, `balance` = ?, `type` = ?, `acc_num` = ?, `bank_id` = ? WHERE `user_id` = ? AND `acc_id` = ?"); // Prepare Statement

        // Parameter(s)

        mysqli_stmt_bind_param($stmt, "sdsssss", $currency, $balance, $type, $number, $bankID, $user, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $edited = true;

        }
         
        mysqli_stmt_close($stmt); // Close Statement
        
        echo json_encode(['updated' => $edited]); // Echo JSON Response

    }

?>