<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $name = filter_var($_REQUEST['code-name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $code = filter_var($_REQUEST['code-pin'], FILTER_SANITIZE_SPECIAL_CHARS);

        $abbr = filter_var($_REQUEST['code-abbr'], FILTER_SANITIZE_SPECIAL_CHARS);

        $descr = filter_var($_REQUEST['code-desc'], FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['code-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $payMethod = filter_var($_REQUEST['code-pay'], FILTER_SANITIZE_SPECIAL_CHARS);

        $percentage = !empty($_REQUEST['code-percent']) && ($type == 'PERCENTAGE') ? filter_var($_REQUEST['code-percent'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;

        $amount = !empty($_REQUEST['code-amount']) && ($type == 'FIXED AMOUNT') ? filter_var($_REQUEST['code-amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;

        $directive = filter_var($_REQUEST['code-directive'], FILTER_SANITIZE_SPECIAL_CHARS);

        $msg = filter_var($_REQUEST['code-msg'], FILTER_SANITIZE_SPECIAL_CHARS);

        $status = filter_var($_REQUEST['code-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $errorCode = !(empty($_REQUEST['code-error'])) ? filter_var($_REQUEST['code-error'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $id = filter_var($_REQUEST['code-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Insert Into Database

        $updateCode = mysqli_prepare($conn, "UPDATE `billing_codes` SET `code` = ?, `name` = ? , `abbr` = ?, `descr` = ?, `type` = ?, `message` = ?, `directive` = ?, `error_code` = ?, `payment_method` = ?, `percentage` = ?, `amount` = ?, `status` = ? WHERE `code_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($updateCode, "sssssssssddss", $code, $name, $abbr, $descr, $type, $msg, $directive, $errorCode, $payMethod, $percentage, $amount, $status, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($updateCode)) { // Execute Statement

            echo json_encode(['codeUpdated' => true]); // Encode JSON Response

        } else {

            echo json_encode(['codeUpdated' => false]); // Encode JSON Response

        }

        mysqli_stmt_close($updateCode); // Close Statement

        exit(); // End Run

    }

?>