<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitze Field(s)

        $id = filter_var($_REQUEST['rpym-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $due = sanitizeDate($_REQUEST['due']);

        $status = filter_var($_REQUEST['status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `repayments_schedule` SET `due` = ?, `amount` = ?, `status` = ? WHERE `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sdss", $due, $amount, $status, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement(s)

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $edited]); // Encode JSON Response

    }

?>