<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitixe Fields

        $id = filter_var($_REQUEST['r-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['pay-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $oldQR = filter_var($_REQUEST['old-qr'], FILTER_SANITIZE_SPECIAL_CHARS);

        $name = filter_var($_REQUEST['pay-name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $attr = filter_var($_REQUEST['pay-credential'], FILTER_SANITIZE_SPECIAL_CHARS);

        $thirdParty = !empty($_REQUEST['pay-vendor']) ? filter_var($_REQUEST['pay-vendor'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $qr = !empty($_FILES['pay-qr']['name']) ? $_FILES['pay-qr'] : null;
        
        $qrPath = null;

        $preference = null;

        $directory = '../../../vault/qr-codes/';

        if ($type == 'CRYPTO') {

            $network = !empty($_REQUEST['network-type']) ? filter_var($_REQUEST['network-type'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

            $symbol = !empty($_REQUEST['name-abbr']) ? filter_var($_REQUEST['name-abbr'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

            if ($symbol == 'BTC') {

                $preference = 10;

            } else if ($symbol == 'ETH') {

                $preference = 9;

            } else if ($symbol == 'USDT') {

                $preference = 8;

            } else if ($symbol == 'SOL') {

                $preference = 7;

            }

            if ($symbol == null) {

                echo json_encode(['symNull' => true]);

                exit;

            }

        }

        // Handle Upload
        
        if ($qr) {

            $qrPath = fileUpload($qr, $directory, 'qr', null, true);

            if ($qrPath['status']) {

                $qrPath = $qrPath['vault'];

            } else {

                $msg = $qrPath['error'];

                echo json_encode(['uploadError' => true, 'message' => $msg]);

                exit;

            }

        }

        $edited = false; // Flag

        $query = "UPDATE `pay_resources` SET `resource_name` = ?, `resource_attr` = ?, `vendor_name` = ?";

        $types = 'sss';

        $values = [$name, $attr, $thirdParty];

        if ($qr) {

            $query .= ", `resource_qrcode` = ?";

            $types .= 's';
            
            $values[] = $qrPath; 

        }

        if ($type == 'CRYPTO') {

            $query .= ", `resource_symbol` = ?, `network_type` = ?";

            $types .= 'ss';
            
            $values[] = $symbol; 

            $values[] = $network;
            
        }

        $query .= ' WHERE `id` = ?';

        $types .= 's';

        $values[] = $id;

        $stmt = mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, $types, ...$values); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        if ($edited && $qr) {

            deleteFile($oldQR, '../../../');

        } else if (!$edited && $qrPath) {

            deleteFile($qrPath);

        }

        echo json_encode(['edited' => $edited]); // Encode JSON Response 

    }

?>