<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Functions File

    require('../../../vendor/autoload.php'); // Composer Package File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $tPin = filter_var($_REQUEST['transc-pin'], FILTER_SANITIZE_SPECIAL_CHARS);

        $marital = filter_var($_REQUEST['marital'], FILTER_SANITIZE_SPECIAL_CHARS);

        $gender = filter_var($_REQUEST['gender'], FILTER_SANITIZE_SPECIAL_CHARS);

        $phone = filter_var($_REQUEST['telephone'], FILTER_SANITIZE_SPECIAL_CHARS);

        $religion = !is_null($_REQUEST['religion']) ? filter_var($_REQUEST['religion'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $citizen = filter_var($_REQUEST['citizen'], FILTER_SANITIZE_SPECIAL_CHARS);

        $logAlerts = filter_var($_REQUEST['login-alerts'], FILTER_SANITIZE_SPECIAL_CHARS);

        $zip = filter_var($_REQUEST['zip-code'], FILTER_SANITIZE_SPECIAL_CHARS);

        $street = filter_var($_REQUEST['street-address'], FILTER_SANITIZE_SPECIAL_CHARS);

        $city = filter_var($_REQUEST['city'], FILTER_SANITIZE_SPECIAL_CHARS);

        $state = filter_var($_REQUEST['state'], FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var($_REQUEST['country'], FILTER_SANITIZE_SPECIAL_CHARS);

        $q1 = filter_var($_REQUEST['sq-1'], FILTER_SANITIZE_SPECIAL_CHARS);

        $a1 = filter_var($_REQUEST['answer-1'], FILTER_SANITIZE_SPECIAL_CHARS);

        $q2 = filter_var($_REQUEST['sq-2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $a2 = filter_var($_REQUEST['answer-2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['nok-fname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !is_null($_REQUEST['nok-mname']) ? filter_var($_REQUEST['nok-mname'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['nok-lname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $dob = sanitizeDate($_REQUEST['nok-dob']);

        $rel = filter_var($_REQUEST['nok-rel'], FILTER_SANITIZE_SPECIAL_CHARS);

        $addr = filter_var($_REQUEST['nok-address'], FILTER_SANITIZE_SPECIAL_CHARS);

        $notify = isset($_REQUEST['notify']) ? true : false;

        if (strlen($tPin) > 6 || strlen($tPin) < 6 || !ctype_digit($tPin)) { // Validate Transaction PIN 

            echo json_encode(['tPinError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `telephone` = ?, `gender` = ?, `marital_status` = ?, `religion` = ?, `trans_pin` = ?, `question_1` = ?, `answer_1` = ?, `question_2` = ?, `answer_2` = ?, `nationality` = ?, `zip_code` = ?, `street_address` = ?, `city` = ?, `state` = ?, `resident_country` = ?, `nok_fname` = ?, `nok_mname` = ?, `nok_lname` = ?, `nok_dob` = ?, `nok_address` = ?, `nok_rel` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssssssssssssssssssss", $phone, $gender, $marital, $religion, $tPin, $q1, $a1, $q2, $a2, $citizen, $zip, $street, $city, $state, $country, $fname, $mname, $lname, $dob, $addr, $rel, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        if ($edited && $notify) {

            $userData = userData($user, $conn); // Get User Data
            
            if ($userData) {

                // Send Email (Optional)

                $subject = 'Welcome Aboard!';

                $mail = completeReg($userData['firstname'], $userData['email'], $userData['raw-key'], $userData['trans-pin']);

                $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                if (!$deliver) {

                    @deliverByPHPMail($email, $subject, $mail); // Fallback

                }

            }

        }

        echo json_encode(['finalized' => $edited, 'id' => $user]); // Encode JSON Response

    }

?>