<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['pay-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Flag

        // Fetch Payment Data

        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`name`, `B`.`email`, `C`.`inv_num` FROM `invoice_payments` AS `A` LEFT JOIN `customers` AS `B` ON `A`.`customer_id` = `B`.`customer_id` LEFT JOIN `invoices` AS `C` ON `A`.`invoice_id` = `C`.`invoice_id` WHERE `A`.`invpay_id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $paidOn = $row['pay_time'];

                $currency = $row['currency'];

                $user = $row['user_id'];

                $amount = $row['amount'];

                $proof = $row['pay_proof'];

                $customer = $row['name'];

                $customerEmail = $row['email'];

                $invoiceNum = $row['inv_num'];

                $invID = $row['invoice_id'];

                $orderedOn = date('l, M d Y, (H:i)', strtotime($paidOn));

                $money = ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency;

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo json_encode(['recordError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $userData = userData($user, $conn); // Fetch User Info

        if (!$userData && $action !== 'DELETE') {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Determine Action

        if ($action == 'APPROVE' || $action == 'DECLINE') {

            // $action = isset($_REQUEST['approve']) ? 'APPROVE' : 'DECLINE';

            // Get Current Datetime

            $datetime = timeGMT();

            // Carry Out Approval / Decline

            if ($action === 'APPROVE') { // Approval
 
                $approved = false; // Flag

                $account = currencyAccountData($currency, $user, $conn); // Locate Account

                if (!$account) {

                    echo json_encode(['userError' => true]); // Encode JSON Response

                    exit; // End Run

                }

                $accNum = $account['acc-number'];

                $balance = $account['balance'];

                $accId = $account['acc-id'];

                // Create Transaction & Update Balance

                $stmt = mysqli_prepare($conn, "INSERT INTO `transactions` (`trans_id`, `user_id`, `date`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (Transaction Creation)

                // Parameter(s)

                $tID = generateUniqueID($conn, 'transactions', 'TRN'); // Generate Trans ID

                $type = 'CREDIT';

                $action = 'MISCELLANOUS';

                $descr = $customer . ' (INVOICE)';

                $newBal = $balance + $amount;

                $status = 'COMPLETED';

                mysqli_stmt_bind_param($stmt, "ssssssssidds", $tID, $user, $datetime, $type, $action,$descr, $currency, $accId, $accNum, $newBal, $amount, $status); // Bind Parameter(s)

                $stmt2 = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` + ? WHERE `acc_id` = ?"); // Prepare Statement (Update Account Balance)

                mysqli_stmt_bind_param($stmt2, "ds", $amount, $accId); // Bind Parameter(s)

                if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) { // Execute Statement(s)

                    $approved = true; // Flag

                    deleteFile($proof, '../../../'); // Delete Proof

                    mysqli_query($conn, "DELETE FROM `invoice_payments` WHERE `invpay_id` = '$id'"); // Delete

                    // Notify User

                    $notf = 'The payment for invoice #' . $invoiceNum . ' invoiced to ' . ($customer ?? 'UNKNOWN') . '(' . $customerEmail ?? 'UNKNOWN' . ') has been verified and your ' . $currency . ' account balance been funded with ' . $money . '.';

                    createNotification($conn, $user, 'Invoice Payment Approved', $notf);

                    // Notify Initiator

                    if (!is_null($customerEmail)) {

                        $subject = 'Invoice Payment Confirmed #' . mt_rand(10000000, 99999999); // Mail Subject

                        $paid = ($currSymbol[$currency] ?? null) . $amount . ' '.  $currency;

                        $mail = payGatewayApproved($orderedOn, 'INVOICE', 'Invoice #' . $invoiceNum, 'VERIFIED', $paid, $id); // Mail Draft

                        $deliverMail = @deliverByPHPMailer($subject, $mail, makePlain($mail), $customerEmail, join(' ', [$userData['firstname'], $userData['lastname']]));

                        if (!$deliverMail) {

                            @deliverByPHPMail($customerEmail, $subject, $mail); // Fallback

                        }

                    }

                }

                // Close Statements

                mysqli_stmt_close($stmt);

                mysqli_stmt_close($stmt2);

                echo json_encode(['approved' => $approved]); // Encode JSON Response

                exit; // End Run

            } else { // Decline

                $declined = false; // Flag

                $stmt = mysqli_prepare($conn, "UPDATE `invoices` SET `status` = ? WHERE `invoice_id` = ?"); // Prepare Statement

                $status = 'UNPAID';
    
                mysqli_stmt_bind_param($stmt, "ss", $status, $invID); // Bind Parameter(s)

                $decline = mysqli_prepare($conn, "DELETE FROM `invoice_payments` WHERE `invpay_id` = ?"); // Prepare Statement
    
                mysqli_stmt_bind_param($decline, "s", $id); // Bind Parameter(s)

                if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($decline)) { // Execute Statement

                    $declined = true; // Update Flag

                    deleteFile($proof, '../../../'); // Delete Proof

                    // Notify User

                    $notf = 'The payment of ' . $money . ' for invoice #' . $invoiceNum . ' invoiced to ' . ($customer ?? 'UNKNOWN') . '(' . $customerEmail ?? 'UNKNOWN' . ') has been reviewed and declined. This may be due to but not limited to discrepancies in payment data, insufficient balance, incomplete payment amongst other factors.';

                    createNotification($conn, $user, 'Invoice Payment Declined', $notf);

                    // Notify Initiator

                    if (!is_null($customerEmail)) {

                        $subject = 'Invoice Payment Declined #' . mt_rand(10000000, 99999999); // Mail Subject

                        $paid = ($currSymbol[$currency] ?? null) . $amount . ' '.  $currency;

                        $mail = payGatewayDeclined($orderedOn, 'INVOICE', 'Invoice #' . $invoiceNum, 'DECLINED', $paid, $id); // Mail Draft

                        $deliverMail = @deliverByPHPMailer($subject, $mail, makePlain($mail), $customerEmail, join(' ', [$userData['firstname'], $userData['lastname']]));

                        if (!$deliverMail) {

                            @deliverByPHPMail($customerEmail, $subject, $mail); // Fallback

                        }

                    }

                } 

                mysqli_stmt_close($decline);

                echo json_encode(['declined' => $declined]); // Encode JSON Response

                exit; // End Run

            }

        } else { // Delete Payment Record

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `invoice_payments` WHERE `invpay_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

                deleteFile($proof, '../../../'); // Delete Proof

            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }    

    }

?>