<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);
       
        $userData = userData($id, $conn); // Fetch User Info

        if (!$userData && $action != 'DELETE') {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Determine Action

        if ($action == 'APPROVE' || $action == 'DECLINE') {

            // Carry Out Approval / Decline

            if ($action === 'APPROVE') { // Approval

                $approved = false; // Approval Flag

                $stmt = mysqli_prepare($conn, "UPDATE `kyc_data` SET `status` = ? WHERE `user_id` = ?");

                // Parameter(s)

                $status = 'VERIFIED';

                mysqli_stmt_bind_param($stmt, "ss", $status, $id); // Bind Statement Parameter(s)

                if (mysqli_stmt_execute($stmt)) { // Execute Statement

                    mysqli_query($conn, "UPDATE `users` SET `kyc_bypass` = 'OFF' WHERE `user_id` = '$id'");

                    $approved = true; // Update Flag

                    $msg = 'Dear ' . join(' ', [$userData['firstname'], $userData['lastname']]) . ', your KYC application has been reviewed and approved. You can now enjoy the full ' . SITE_NAME . ' experience. Welcome aboard!';

                    createNotification($conn, $id, 'KYC Application Approved!', $msg);  // Notify User

                }
     
                mysqli_stmt_close($stmt); // Close Statement

                echo json_encode(['approved' => $approved]); // Encode JSON Response
                
                exit; // End Run

            } else { // Decline

                $declined = false; // Flag

                $stmt = mysqli_prepare($conn, "UPDATE `kyc_data` SET `status` = ? WHERE `user_id` = ?");

                // Parameter(s)

                $status = 'REJECTED';

                mysqli_stmt_bind_param($stmt, "ss", $status, $id); // Bind Statement Parameter(s)

                if (mysqli_stmt_execute($stmt)) { // Execute Statement

                    mysqli_query($conn, "UPDATE `users` SET `kyc_bypass` = 'OFF' WHERE `user_id` = '$id'");

                    $declined = true; // Update Flag

                    $msg = 'Dear ' . join(' ', [$userData['firstname'], $userData['lastname']]) . ', your KYC application has been reviewed and declined. This may be due to incoherent data, invalid/expired details amongst other factors. We\'re extremely sorry about this, please re-take the KYC application with valid information. Best regards!';

                    createNotification($conn, $id, 'KYC Application Declined!', $msg);  // Notify User

                }
     
                mysqli_stmt_close($stmt); // Close Statement
                
                echo json_encode(['declined' => $declined]); // Encode JSON Response

                exit; // End Run

            }

        } else { // Delete KYC Record

            // Fetch Record Data

            $found = false; // Location Flag

            $stmt = mysqli_prepare($conn, "SELECT * FROM `kyc_data` WHERE `user_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

            if (mysqli_num_rows($result) === 1) {

                $found = true; // Update Flag

                while (mysqli_fetch_assoc($result)) {

                    $proof = $row['id_proof'];

                    $proofBack = $row['id_proofBack'];

                }

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `kyc_data` WHERE `user_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

                if ($found) {

                    deleteFile($proof, '../../../'); // Delete Proof

                    deleteFile($proofBack, '../../../'); // Delete ProofBack

                }

            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }    

    }

?>