<?php

    // Credentials
    
    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['app-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false; // Deposit Flag

        // Fetch Payment Data

        $stmt = mysqli_prepare($conn, "SELECT * FROM `loan_requests` WHERE `req_id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $user = $row['user_id'];

                $amount = $row['amount'];

                $interest = $row['rate'];

                $term = $row['term'];

                $frequency = $row['frequency'];

                $accID = $row['account'];

                $accNum = $row['account'];

                $type = $row['reason'];

                $date = $row['date'];

                $currency = $row['currency'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo json_encode(['recordError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $userData = userData($user, $conn); // Fetch User Info

        if (!$userData && $action !== 'DELETE') {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        if ($action !== 'DELETE') {

            $accInfo = accountData($accID, $user, $conn); // Locate Account

            if (!$accInfo) {

                echo json_encode(['accError' => true]); // Encode JSON Response

                exit; // End Run

            }

            $balance = $accInfo['balance'];

        }

        // Determine Action

        if ($action == 'APPROVE' || $action == 'DECLINE') {

            // Get Current Datetime

            $datetime = timeGMT();    

            // Carry Out Approval / Decline

            if ($action == 'APPROVE') { // Approval

                $approved = false; // Approval Flag
                
                $newBal = $balance + $amount; // Calculate New Balance

                // Update / Create Transaction & Update Account Balance

                $stmt1 = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = ? WHERE `acc_id` = CAST(? AS BINARY) AND `user_id` = CAST(? AS BINARY)"); // Prepare Statement (For Account Balance Update)

                mysqli_stmt_bind_param($stmt1, "sss", $newBal, $accID, $user); // Bind Statement Parameter(s)

                // Transcation Statement

                // $tStatus = 'COMPLETED'; // For Transaction Status

                // $stmt2 = mysqli_prepare($conn, "INSERT INTO `transactions` (`date`, `user_id`, `trans_id`, `type`, `action`, `descr`, `currency`, `acc_id`, `acc_num`, `acc_bal`, `amount`, `acc_status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                // // Parameter(s)

                // $transId = generateUniqueID($conn, 'transactions', 'TRN');

                // $action = 'DEPOSIT';

                // $descr = "$action ($currency)";

                // $type = 'CREDIT';

                // mysqli_stmt_bind_param($stmt2, "ssssssssidds", $date, $user, $transId, $type, $action, $descr, $currency, $accID, $accNum, $newBal, $amount, $tStatus); // Bind Parameter(s)
                       
                $payments = generateRepaymentSchedule($amount, $interest, $term, $frequency);

                $loanID = generateUniqueID($conn, 'loans', 'LN');

                $stmt3 = mysqli_prepare($conn, "INSERT INTO `loans` (`loan_id`, `user_id`, `amount`, `repay`, `currency`, `acc_id`, `type`, `interest`, `frequency`, `term`, `due`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

                $due = ($term * 24 * 60 * 60); // Convert to Seconds

                $due = time() + $due;

                $dueDate = date('Y-m-d', $due); // Format Date

                $repay = ($amount * ($interest / 100) * ($term / 365)) + $amount;  // Simple interest

                mysqli_stmt_bind_param($stmt3, "ssddsssssss", $loanID, $user, $amount, $repay, $currency, $accID, $type, $interest, $frequency, $term, $dueDate); // Bind Parameter(s)                

                // $stmt4 = mysqli_prepare($conn, ""); // Prepare Statement

                $records = null; // Stores Repayment Records

                if (mysqli_stmt_execute($stmt1) && mysqli_stmt_execute($stmt3)/* && mysqli_stmt_execute($stmt2)*/) { // Execute Statements

                    $approved = true; // Update Flag

                    // Insert Payment Schedule
                    
                    $stmt4 = mysqli_prepare($conn, "INSERT INTO `repayments_schedule` (`loan_id`, `user_id`, `amount`, `due`) VALUES (?, ?, ?, ?)");

                    // Loop through each payment date and amount
                    foreach ($payments['paymentDates'] as $index => $dueDate) {
                        // Bind parameters for each repayment
                        mysqli_stmt_bind_param($stmt4, 'ssds', $loanID, $user, $payments['paymentAmount'], $dueDate);

                        $formattedAmount = $currSymbol[$currency] . number_format($payments['paymentAmount'], 2) . $currency;

                        $formattedDate = date('d/M/Y', strtotime($dueDate));

                        $records .= <<<HTML

                            <tr style="height:33px">

                                <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                    
                                    <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$formattedDate</p>
                                    
                                </td>
                                
                                <td style="min-width:90px;font-size:14px;white-space:normal;overflow-wrap:break-word;border:1px solid rgb(235, 237, 240);padding:4px 8px;cursor:default">
                                    
                                    <p style="font-size:14px;color:rgb(38, 38, 38);line-height:1.74;letter-spacing:0.05em;outline-style:none;overflow-wrap:break-word;margin-top:0px;margin-bottom:0px">$formattedAmount</p>
                                    
                                </td>

                            <tr> 
                        
                        HTML;
                        
                        // Execute the insert for this repayment
                        if (!mysqli_stmt_execute($stmt4)) {
                            // Handle error if any repayment insertion fails
                            echo "Error inserting repayment schedule: " . mysqli_stmt_error($stmt4);
                            break;
                        }
                    }

                    mysqli_query($conn, "DELETE FROM `loan_requests` WHERE `req_id` = '$id'"); // Delete Loan Request Record

                }

                // Close Statements

                mysqli_stmt_close($stmt1);

                mysqli_stmt_close($stmt3);

                mysqli_stmt_close($stmt4);

                // Send Email

                if ($approved) {

                    $symbol = $currSymbol[$currency];

                    $notf = 'Your request for ' . $currency . ' loan of ' . $symbol . number_format($amount, 2) . ' has been approved. Note this loan will last for ' . $term . ' days (' . $term / 30 . ' Months) and will be due on ' . date('l M d, Y', $due) . '.';

                    createNotification($conn, $user, 'Loan Approved', $notf);

                    $subject = 'Loan Granted #' . mt_rand(10000000, 99999999);

                    $requested = date('l, M d Y', strtotime($date));

                    $mail = loanConfirmation($userData['firstname'], $currency, $symbol . number_format($amount, 2), $type, $requested, $term, $frequency, $records);

                    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                }

                echo json_encode(['approved' => $approved]); // Encode JSON Response
                
                exit; // End Run

            } else { // Decline

                $declined = false; // Flag

                $decline = mysqli_prepare($conn, "DELETE FROM `loan_requests` WHERE `req_id` = ?"); // Prepare Statement
    
                mysqli_stmt_bind_param($decline, "s", $id); // Bind Parameter(s)

                if (mysqli_stmt_execute($decline)) { // Execute Statements

                    $declined = true; // Update Flag

                } 

                // Close Statements

                mysqli_stmt_close($decline);

                if ($declined) {

                    $symbol = $currSymbol[$currency];

                    $notf = 'We\'re geniuely sorry to inform you that your request for ' . $currency . ' loan of ' . $symbol . number_format($amount, 2) . ' has been declined.';

                    createNotification($conn, $user, 'Loan Declined', $notf);

                    $subject = 'Loan Approved #' . mt_rand(10000000, 99999999);

                    $requested = date('l, M d Y', strtotime($date));

                    $mail = loanDeclined($userData['firstname'], $currency, $symbol . number_format($amount, 2), $type, $requested, $term);

                    $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                    if (!$deliver) {

                        @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                    }

                }

                echo json_encode(['declined' => $declined]); // Encode JSON Response

                exit; // End Run

            }

        } else { // Delete Payment Record

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `loan_requests` WHERE `req_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag
            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        }    

    }

?>